/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.fs.AdversarialFileChannel;
import org.neo4j.adversaries.fs.AdversarialInputStream;
import org.neo4j.adversaries.fs.AdversarialOutputStream;
import org.neo4j.adversaries.fs.AdversarialReader;
import org.neo4j.adversaries.fs.AdversarialWriter;
import org.neo4j.adversaries.watcher.AdversarialFileWatcher;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.watcher.FileWatcher;

public class AdversarialFileSystemAbstraction
implements FileSystemAbstraction {
    private final FileSystemAbstraction delegate;
    private final Adversary adversary;
    private final Map<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem> thirdPartyFileSystems = new HashMap<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem>();

    public AdversarialFileSystemAbstraction(Adversary adversary) {
        this(adversary, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public AdversarialFileSystemAbstraction(Adversary adversary, FileSystemAbstraction delegate) {
        this.adversary = adversary;
        this.delegate = delegate;
    }

    public FileWatcher fileWatcher() throws IOException {
        this.adversary.injectFailure(UnsupportedOperationException.class, IOException.class);
        return new AdversarialFileWatcher(this.delegate.fileWatcher(), this.adversary);
    }

    public StoreChannel open(File fileName, String mode) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        return AdversarialFileChannel.wrap((StoreFileChannel)this.delegate.open(fileName, mode), this.adversary);
    }

    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, SecurityException.class);
        this.delegate.renameFile(from, to, copyOptions);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, SecurityException.class);
        return new AdversarialOutputStream(this.delegate.openAsOutputStream(fileName, append), this.adversary);
    }

    public StoreChannel create(File fileName) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        return AdversarialFileChannel.wrap((StoreFileChannel)this.delegate.create(fileName), this.adversary);
    }

    public boolean mkdir(File fileName) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.mkdir(fileName);
    }

    public File[] listFiles(File directory) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.listFiles(directory);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.listFiles(directory, filter);
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        this.adversary.injectFailure(UnsupportedEncodingException.class, FileNotFoundException.class, SecurityException.class);
        return new AdversarialWriter(this.delegate.openAsWriter(fileName, charset, append), this.adversary);
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        this.adversary.injectFailure(UnsupportedEncodingException.class, FileNotFoundException.class, SecurityException.class);
        return new AdversarialReader(this.delegate.openAsReader(fileName, charset), this.adversary);
    }

    public long getFileSize(File fileName) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.getFileSize(fileName);
    }

    public void copyFile(File from, File to) throws IOException {
        this.adversary.injectFailure(SecurityException.class, FileNotFoundException.class, IOException.class);
        this.delegate.copyFile(from, to);
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IOException.class, NullPointerException.class);
        this.delegate.copyRecursively(fromDirectory, toDirectory);
    }

    public boolean deleteFile(File fileName) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.deleteFile(fileName);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, SecurityException.class);
        return new AdversarialInputStream(this.delegate.openAsInputStream(fileName), this.adversary);
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IllegalArgumentException.class, FileNotFoundException.class, NullPointerException.class, IOException.class);
        this.delegate.moveToDirectory(file, toDirectory);
    }

    public boolean isDirectory(File file) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.isDirectory(file);
    }

    public boolean fileExists(File fileName) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.fileExists(fileName);
    }

    public void mkdirs(File fileName) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IOException.class);
        this.delegate.mkdirs(fileName);
    }

    public void deleteRecursively(File directory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, NullPointerException.class, IOException.class);
        this.delegate.deleteRecursively(directory);
    }

    public synchronized <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        FileSystemAbstraction.ThirdPartyFileSystem fileSystem = this.thirdPartyFileSystems.get(clazz);
        if (fileSystem == null) {
            fileSystem = (FileSystemAbstraction.ThirdPartyFileSystem)creator.apply(clazz);
            fileSystem = this.adversarialProxy(fileSystem, clazz);
            this.thirdPartyFileSystems.put(clazz, fileSystem);
        }
        return (K)fileSystem;
    }

    public void truncate(File path, long size) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, IllegalArgumentException.class, SecurityException.class, NullPointerException.class);
        this.delegate.truncate(path, size);
    }

    public long lastModifiedTime(File file) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class, NullPointerException.class);
        return this.delegate.lastModifiedTime(file);
    }

    public void deleteFileOrThrow(File file) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        this.delegate.deleteFileOrThrow(file);
    }

    private <K extends FileSystemAbstraction.ThirdPartyFileSystem> FileSystemAbstraction.ThirdPartyFileSystem adversarialProxy(final FileSystemAbstraction.ThirdPartyFileSystem fileSystem, Class<K> clazz) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                AdversarialFileSystemAbstraction.this.adversary.injectFailure(method.getExceptionTypes());
                return method.invoke((Object)fileSystem, args);
            }
        };
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return (FileSystemAbstraction.ThirdPartyFileSystem)Proxy.newProxyInstance(loader, new Class[]{clazz}, handler);
    }

    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        this.delegate.close();
    }
}

