/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.JavaType;
import org.nd4j.shade.jackson.databind.JsonMappingException;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.databind.annotation.JacksonStdImpl;
import org.nd4j.shade.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.nd4j.shade.jackson.databind.ser.std.NonTypedScalarSerializerBase;

@JacksonStdImpl
public final class BooleanSerializer
extends NonTypedScalarSerializerBase<Boolean> {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(Boolean.class);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeBoolean(value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectBooleanFormat(typeHint);
        }
    }
}

