/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.List;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.AggregationStrategy;
import org.mule.routing.ScatterGatherRouter;
import org.springframework.beans.factory.FactoryBean;

public class ScatterGatherRouterFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean<ScatterGatherRouter> {
    private long timeout = 0L;
    private List<MessageProcessor> messageProcessors;
    private AggregationStrategy aggregationStrategy;
    private ThreadingProfile threadingProfile;

    public ScatterGatherRouter getObject() throws Exception {
        ScatterGatherRouter sg = new ScatterGatherRouter();
        sg.setTimeout(this.timeout);
        for (MessageProcessor mp : this.messageProcessors) {
            sg.addRoute(mp);
        }
        if (this.aggregationStrategy != null) {
            sg.setAggregationStrategy(this.aggregationStrategy);
        }
        if (this.threadingProfile != null) {
            sg.setThreadingProfile(this.threadingProfile);
        }
        sg.setAnnotations(this.getAnnotations());
        return sg;
    }

    public Class<?> getObjectType() {
        return ScatterGatherRouter.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }
}

