/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.Collection;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.AbstractSelectiveRouter;
import org.mule.routing.MessageProcessorFilterPair;
import org.springframework.beans.factory.FactoryBean;

public abstract class AbstractSelectiveRouterFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean {
    private MessageProcessor defaultProcessor;
    private Collection<MessageProcessorFilterPair> conditionalMessageProcessors;

    public void setDefaultRoute(MessageProcessorFilterPair conditionalProcessor) {
        this.defaultProcessor = conditionalProcessor.getMessageProcessor();
    }

    public void setRoutes(Collection<MessageProcessorFilterPair> conditionalMessageProcessors) {
        this.conditionalMessageProcessors = conditionalMessageProcessors;
    }

    public Object getObject() throws Exception {
        AbstractSelectiveRouter router = this.newAbstractSelectiveRouter();
        router.setAnnotations(this.getAnnotations());
        router.setDefaultRoute(this.defaultProcessor);
        for (MessageProcessorFilterPair mpfp : this.conditionalMessageProcessors) {
            router.addRoute(mpfp.getMessageProcessor(), mpfp.getFilter());
        }
        return router;
    }

    protected abstract AbstractSelectiveRouter newAbstractSelectiveRouter();

    public boolean isSingleton() {
        return true;
    }
}

