/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.Registry;
import org.mule.api.registry.RegistryProvider;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.config.bootstrap.AbstractRegistryBootstrap;
import org.mule.config.bootstrap.BootstrapObjectFactory;
import org.mule.config.bootstrap.ClassPathRegistryBootstrapDiscoverer;
import org.mule.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.config.spring.MuleArtifactContext;
import org.mule.config.spring.OptionalObjectsController;
import org.mule.config.spring.SpringRegistry;
import org.mule.config.spring.factories.BootstrapObjectFactoryBean;
import org.mule.config.spring.factories.ConstantFactoryBean;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.ClassUtils;
import org.mule.util.Preconditions;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringRegistryBootstrap
extends AbstractRegistryBootstrap
implements BeanFactoryAware,
ApplicationContextAware {
    private OptionalObjectsController optionalObjectsController;
    private BeanDefinitionRegistry beanDefinitionRegistry;

    public SpringRegistryBootstrap() {
        super((RegistryBootstrapDiscoverer)new ClassPathRegistryBootstrapDiscoverer());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Preconditions.checkArgument((boolean)(beanFactory instanceof BeanDefinitionRegistry), (String)("this bootstrap class only accepts BeanFactory instances which implement " + BeanDefinitionRegistry.class));
        this.beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof MuleArtifactContext) {
            this.optionalObjectsController = ((MuleArtifactContext)applicationContext).getOptionalObjectsController();
        }
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        try {
            this.absorbAndDiscardOtherRegistries();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void registerTransformers() throws MuleException {
    }

    protected void doRegisterTransformer(String name, Class<?> returnClass, Class<? extends Transformer> transformerClass, String mime, boolean optional) throws Exception {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(transformerClass);
        DataType returnType = null;
        if (returnClass != null) {
            returnType = DataTypeFactory.create(returnClass, (String)mime);
            builder.addPropertyValue("returnDataType", (Object)returnType);
        }
        if (name == null) {
            name = "_" + TransformerUtils.generateTransformerName(transformerClass, (DataType)returnType);
        }
        builder.addPropertyValue("name", (Object)name);
        this.notifyIfOptional(name, optional);
        this.doRegisterObject(name, builder);
    }

    private void absorbAndDiscardOtherRegistries() {
        if (!(this.muleContext.getRegistry() instanceof RegistryProvider)) {
            return;
        }
        for (Registry registry : ((RegistryProvider)this.muleContext.getRegistry()).getRegistries()) {
            if (registry instanceof SpringRegistry) continue;
            for (Map.Entry entry : registry.lookupByType(Object.class).entrySet()) {
                this.registerInstance((String)entry.getKey(), entry.getValue());
            }
            this.muleContext.removeRegistry(registry);
        }
    }

    protected void doRegisterObject(String key, String className, boolean optional) throws Exception {
        this.notifyIfOptional(key, optional);
        Class clazz = this.getClass(className);
        this.doRegisterObject(key, clazz);
    }

    private void notifyIfOptional(String key, boolean optional) {
        if (optional && this.optionalObjectsController != null) {
            this.optionalObjectsController.registerOptionalKey(key);
        }
    }

    private void doRegisterObject(String key, Class<?> type) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        BeanDefinitionBuilder builder;
        if (BootstrapObjectFactory.class.isAssignableFrom(type)) {
            builder = BeanDefinitionBuilder.rootBeanDefinition(BootstrapObjectFactoryBean.class);
            builder.addConstructorArgValue(ClassUtils.instanciateClass(type, (Object[])new Object[0]));
        } else {
            builder = BeanDefinitionBuilder.rootBeanDefinition(type);
        }
        this.doRegisterObject(key, builder);
    }

    private void doRegisterObject(String key, BeanDefinitionBuilder builder) {
        this.beanDefinitionRegistry.registerBeanDefinition(key, (BeanDefinition)builder.getBeanDefinition());
    }

    private void registerInstance(String key, Object value) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ConstantFactoryBean.class);
        builder.addConstructorArgValue(value);
        this.doRegisterObject(key, builder);
    }

    protected OptionalObjectsController getOptionalObjectsController() {
        return this.optionalObjectsController;
    }
}

