/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.IOException;
import java.io.InputStream;
import org.mule.api.MuleContext;
import org.mule.config.ConfigResource;
import org.mule.config.spring.DefaultOptionalObjectsController;
import org.mule.config.spring.ExpressionEvaluatorPostProcessor;
import org.mule.config.spring.GlobalNamePostProcessor;
import org.mule.config.spring.MissingParserProblemReporter;
import org.mule.config.spring.MuleBeanDefinitionDocumentReader;
import org.mule.config.spring.MuleContextPostProcessor;
import org.mule.config.spring.MuleDocumentLoader;
import org.mule.config.spring.OptionalObjectsController;
import org.mule.config.spring.editors.MulePropertyEditorRegistrar;
import org.mule.config.spring.processors.AnnotatedTransformerObjectPostProcessor;
import org.mule.config.spring.processors.DiscardedOptionalBeanPostProcessor;
import org.mule.config.spring.processors.ExpressionEnricherPostProcessor;
import org.mule.config.spring.processors.LifecycleStatePostProcessor;
import org.mule.config.spring.processors.NoDevkitInjectorProcessor;
import org.mule.config.spring.processors.PostRegistrationActionsPostProcessor;
import org.mule.config.spring.util.LaxInstantiationStrategyWrapper;
import org.mule.registry.MuleRegistryHelper;
import org.mule.util.IOUtils;
import org.mule.util.Preconditions;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class MuleArtifactContext
extends AbstractXmlApplicationContext {
    private static final ThreadLocal<MuleContext> currentMuleContext = new ThreadLocal();
    private MuleContext muleContext;
    private Resource[] springResources;
    private final OptionalObjectsController optionalObjectsController;

    public MuleArtifactContext(MuleContext muleContext, ConfigResource[] configResources) throws BeansException {
        this(muleContext, MuleArtifactContext.convert(configResources));
    }

    public MuleArtifactContext(MuleContext muleContext, ConfigResource[] configResources, OptionalObjectsController optionalObjectsController) throws BeansException {
        this(muleContext, MuleArtifactContext.convert(configResources), optionalObjectsController);
    }

    public MuleArtifactContext(MuleContext muleContext, Resource[] springResources) throws BeansException {
        this(muleContext, springResources, (OptionalObjectsController)new DefaultOptionalObjectsController());
    }

    public MuleArtifactContext(MuleContext muleContext, Resource[] springResources, OptionalObjectsController optionalObjectsController) throws BeansException {
        Preconditions.checkArgument((optionalObjectsController != null ? 1 : 0) != 0, (String)"optionalObjectsController cannot be null");
        this.muleContext = muleContext;
        this.springResources = springResources;
        this.optionalObjectsController = optionalObjectsController;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.registerEditors(beanFactory);
        this.addBeanPostProcessors(beanFactory, new BeanPostProcessor[]{new MuleContextPostProcessor(this.muleContext), new ExpressionEvaluatorPostProcessor(this.muleContext), new GlobalNamePostProcessor(), new ExpressionEnricherPostProcessor(this.muleContext), new AnnotatedTransformerObjectPostProcessor(this.muleContext), new PostRegistrationActionsPostProcessor((ConfigurableApplicationContext)this, (MuleRegistryHelper)this.muleContext.getRegistry()), new DiscardedOptionalBeanPostProcessor(this.optionalObjectsController, (DefaultListableBeanFactory)beanFactory), new LifecycleStatePostProcessor(this.muleContext.getLifecycleManager().getState())});
        beanFactory.registerSingleton("_muleContext", (Object)this.muleContext);
    }

    private void registerEditors(ConfigurableListableBeanFactory beanFactory) {
        MulePropertyEditorRegistrar registrar = new MulePropertyEditorRegistrar();
        registrar.setMuleContext(this.muleContext);
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)registrar);
    }

    private void addBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, BeanPostProcessor ... processors) {
        for (BeanPostProcessor processor : processors) {
            beanFactory.addBeanPostProcessor(processor);
        }
    }

    private static Resource[] convert(ConfigResource[] resources) {
        Resource[] configResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ConfigResource resource = resources[i];
            if (resource.getUrl() != null) {
                configResources[i] = new UrlResource(resource.getUrl());
                continue;
            }
            try {
                configResources[i] = new ByteArrayResource(IOUtils.toByteArray((InputStream)resource.getInputStream()), resource.getResourceName());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configResources;
    }

    protected Resource[] getConfigResources() {
        return this.springResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        BeanDefinitionReader beanDefinitionReader = this.createBeanDefinitionReader(beanFactory);
        try {
            currentMuleContext.set(this.muleContext);
            beanDefinitionReader.loadBeanDefinitions(this.springResources);
        }
        finally {
            currentMuleContext.remove();
        }
    }

    protected BeanDefinitionReader createBeanDefinitionReader(DefaultListableBeanFactory beanFactory) {
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        beanDefinitionReader.setDocumentLoader((DocumentLoader)this.createLoader());
        beanDefinitionReader.setDocumentReaderClass(this.getBeanDefinitionDocumentReaderClass());
        beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        this.registerAnnotationConfigProcessors(beanDefinitionReader.getRegistry(), null);
        return beanDefinitionReader;
    }

    protected MuleDocumentLoader createLoader() {
        return new MuleDocumentLoader();
    }

    private void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry, Object source) {
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalConfigurationAnnotationProcessor", ConfigurationClassPostProcessor.class, source);
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class, source);
        this.registerInjectorProcessor(registry);
    }

    protected void registerInjectorProcessor(BeanDefinitionRegistry registry) {
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalAutowiredAnnotationProcessor", NoDevkitInjectorProcessor.class, null);
    }

    private void registerAnnotationConfigProcessor(BeanDefinitionRegistry registry, String key, Class<?> type, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(type);
        beanDefinition.setSource(source);
        this.registerPostProcessor(registry, beanDefinition, key);
    }

    protected void registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
    }

    protected Class<? extends MuleBeanDefinitionDocumentReader> getBeanDefinitionDocumentReaderClass() {
        return MuleBeanDefinitionDocumentReader.class;
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory(this.getInternalParentBeanFactory());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ContextAnnotationAutowireCandidateResolver());
        beanFactory.setInstantiationStrategy(new LaxInstantiationStrategyWrapper((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(), this.optionalObjectsController));
        return beanFactory;
    }

    public boolean isRunning() {
        try {
            return super.isRunning();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected OptionalObjectsController getOptionalObjectsController() {
        return this.optionalObjectsController;
    }

    public static ThreadLocal<MuleContext> getCurrentMuleContext() {
        return currentMuleContext;
    }
}

