/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.nio.ByteBuffer;
import java.util.Date;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.internal.Conversions;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.Matrix;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.DateHelper;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "tkhd";
    private static Logger LOG;
    private Date creationTime = new Date(0L);
    private Date modificationTime = new Date(0L);
    private long trackId;
    private long duration;
    private int layer;
    private int alternateGroup;
    private float volume;
    private Matrix matrix = Matrix.ROTATE_0;
    private double width;
    private double height;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;

    static {
        TrackHeaderBox.ajc$preClinit();
        LOG = LoggerFactory.getLogger(TrackHeaderBox.class);
    }

    public TrackHeaderBox() {
        super(TYPE);
    }

    public Date getCreationTime() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        Date date = creationTime;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, date);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.creationTime = creationTime;
        if (DateHelper.convert(creationTime) >= 0x100000000L) {
            this.setVersion(1);
        }
    }

    public Date getModificationTime() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.modificationTime;
    }

    public void setModificationTime(Date modificationTime) {
        Date date = modificationTime;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, date);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.modificationTime = modificationTime;
        if (DateHelper.convert(modificationTime) >= 0x100000000L) {
            this.setVersion(1);
        }
    }

    public long getTrackId() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.trackId;
    }

    public void setTrackId(long trackId) {
        long l = trackId;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, Conversions.longObject(l));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.trackId = trackId;
    }

    public long getDuration() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.duration;
    }

    public void setDuration(long duration) {
        long l = duration;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, Conversions.longObject(l));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.duration = duration;
        if (duration >= 0x100000000L) {
            this.setFlags(1);
        }
    }

    public int getLayer() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.layer;
    }

    public void setLayer(int layer) {
        int n = layer;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.layer = layer;
    }

    public int getAlternateGroup() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.alternateGroup;
    }

    public void setAlternateGroup(int alternateGroup) {
        int n = alternateGroup;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.alternateGroup = alternateGroup;
    }

    public float getVolume() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.volume;
    }

    public void setVolume(float volume) {
        float f = volume;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_13, (Object)this, (Object)this, Conversions.floatObject(f));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.volume = volume;
    }

    public Matrix getMatrix() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_14, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        Matrix matrix2 = matrix;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_15, (Object)this, (Object)this, matrix2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.matrix = matrix;
    }

    public double getWidth() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_16, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.width;
    }

    public void setWidth(double width) {
        double d = width;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_17, (Object)this, (Object)this, Conversions.doubleObject(d));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.width = width;
    }

    public double getHeight() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_18, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.height;
    }

    public void setHeight(double height) {
        double d = height;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_19, (Object)this, (Object)this, Conversions.doubleObject(d));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.height = height;
    }

    protected long getContentSize() {
        long contentSize = 4L;
        contentSize = this.getVersion() == 1 ? (contentSize += 32L) : (contentSize += 20L);
        return contentSize += 60L;
    }

    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        if (this.getVersion() == 1) {
            this.creationTime = DateHelper.convert(IsoTypeReader.readUInt64(content));
            this.modificationTime = DateHelper.convert(IsoTypeReader.readUInt64(content));
            this.trackId = IsoTypeReader.readUInt32(content);
            IsoTypeReader.readUInt32(content);
            this.duration = content.getLong();
        } else {
            this.creationTime = DateHelper.convert(IsoTypeReader.readUInt32(content));
            this.modificationTime = DateHelper.convert(IsoTypeReader.readUInt32(content));
            this.trackId = IsoTypeReader.readUInt32(content);
            IsoTypeReader.readUInt32(content);
            this.duration = content.getInt();
        }
        if (this.duration < -1L) {
            LOG.warn("tkhd duration is not in expected range");
        }
        IsoTypeReader.readUInt32(content);
        IsoTypeReader.readUInt32(content);
        this.layer = IsoTypeReader.readUInt16(content);
        this.alternateGroup = IsoTypeReader.readUInt16(content);
        this.volume = IsoTypeReader.readFixedPoint88(content);
        IsoTypeReader.readUInt16(content);
        this.matrix = Matrix.fromByteBuffer(content);
        this.width = IsoTypeReader.readFixedPoint1616(content);
        this.height = IsoTypeReader.readFixedPoint1616(content);
    }

    public void getContent(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_20, (Object)this, (Object)this, byteBuffer2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.writeVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt64(byteBuffer, DateHelper.convert(this.creationTime));
            IsoTypeWriter.writeUInt64(byteBuffer, DateHelper.convert(this.modificationTime));
            IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
            IsoTypeWriter.writeUInt32(byteBuffer, 0L);
            byteBuffer.putLong(this.duration);
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, DateHelper.convert(this.creationTime));
            IsoTypeWriter.writeUInt32(byteBuffer, DateHelper.convert(this.modificationTime));
            IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
            IsoTypeWriter.writeUInt32(byteBuffer, 0L);
            byteBuffer.putInt((int)this.duration);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt16(byteBuffer, this.layer);
        IsoTypeWriter.writeUInt16(byteBuffer, this.alternateGroup);
        IsoTypeWriter.writeFixedPoint88(byteBuffer, this.volume);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        this.matrix.getContent(byteBuffer);
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.width);
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.height);
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_21, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        StringBuilder result = new StringBuilder();
        result.append("TrackHeaderBox[");
        result.append("creationTime=").append(this.getCreationTime());
        result.append(";");
        result.append("modificationTime=").append(this.getModificationTime());
        result.append(";");
        result.append("trackId=").append(this.getTrackId());
        result.append(";");
        result.append("duration=").append(this.getDuration());
        result.append(";");
        result.append("layer=").append(this.getLayer());
        result.append(";");
        result.append("alternateGroup=").append(this.getAlternateGroup());
        result.append(";");
        result.append("volume=").append(this.getVolume());
        result.append(";");
        result.append("matrix=").append(this.matrix);
        result.append(";");
        result.append("width=").append(this.getWidth());
        result.append(";");
        result.append("height=").append(this.getHeight());
        result.append("]");
        return result.toString();
    }

    public boolean isEnabled() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_22, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 1) > 0;
    }

    public void setEnabled(boolean enabled) {
        boolean bl = enabled;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_23, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (enabled) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFE);
        }
    }

    public boolean isInMovie() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_24, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 2) > 0;
    }

    public void setInMovie(boolean inMovie) {
        boolean bl = inMovie;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_25, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (inMovie) {
            this.setFlags(this.getFlags() | 2);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFD);
        }
    }

    public boolean isInPreview() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_26, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 4) > 0;
    }

    public void setInPreview(boolean inPreview) {
        boolean bl = inPreview;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_27, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (inPreview) {
            this.setFlags(this.getFlags() | 4);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFB);
        }
    }

    public boolean isInPoster() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_28, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 8) > 0;
    }

    public void setInPoster(boolean inPoster) {
        boolean bl = inPoster;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_29, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (inPoster) {
            this.setFlags(this.getFlags() | 8);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFF7);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TrackHeaderBox.java", TrackHeaderBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreationTime", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "java.util.Date"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCreationTime", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "java.util.Date", "creationTime", "", "void"), 66);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAlternateGroup", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "int"), 112);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAlternateGroup", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "int", "alternateGroup", "", "void"), 116);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getVolume", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "float"), 120);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setVolume", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "float", "volume", "", "void"), 124);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMatrix", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "org.mp4parser.support.Matrix"), 128);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMatrix", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "org.mp4parser.support.Matrix", "matrix", "", "void"), 132);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWidth", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "double"), 136);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWidth", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "double", "width", "", "void"), 140);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHeight", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "double"), 144);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setHeight", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "double", "height", "", "void"), 148);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getModificationTime", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "java.util.Date"), 73);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContent", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "java.nio.ByteBuffer", "byteBuffer", "", "void"), 195);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "java.lang.String"), 223);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEnabled", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "boolean"), 249);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEnabled", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "boolean", "enabled", "", "void"), 253);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isInMovie", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "boolean"), 261);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInMovie", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "boolean", "inMovie", "", "void"), 265);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isInPreview", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "boolean"), 273);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInPreview", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "boolean", "inPreview", "", "void"), 277);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isInPoster", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "boolean"), 285);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInPoster", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "boolean", "inPoster", "", "void"), 289);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setModificationTime", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "java.util.Date", "modificationTime", "", "void"), 77);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTrackId", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "long"), 85);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTrackId", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "long", "trackId", "", "void"), 89);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDuration", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "long"), 93);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDuration", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "long", "duration", "", "void"), 97);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLayer", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "", "", "", "int"), 104);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLayer", "org.mp4parser.boxes.iso14496.part12.TrackHeaderBox", "int", "layer", "", "void"), 108);
    }
}

