/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mp4parser.Box;
import org.mp4parser.BoxParser;
import org.mp4parser.Container;
import org.mp4parser.ParsableBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicContainer
implements Container {
    private List<Box> boxes = new ArrayList<Box>();

    public BasicContainer() {
    }

    public BasicContainer(List<Box> boxes) {
        this.boxes = boxes;
    }

    @Override
    public List<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public void setBoxes(List<? extends Box> boxes) {
        this.boxes = new ArrayList<Box>(boxes);
    }

    protected long getContainerSize() {
        long contentSize = 0L;
        int i = 0;
        while (i < this.getBoxes().size()) {
            contentSize += this.boxes.get(i).getSize();
            ++i;
        }
        return contentSize;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        ArrayList<Box> boxesToBeReturned = null;
        Box oneBox = null;
        List<Box> boxes = this.getBoxes();
        for (Box boxe : boxes) {
            if (!clazz.isInstance(boxe)) continue;
            if (oneBox == null) {
                oneBox = boxe;
                continue;
            }
            if (boxesToBeReturned == null) {
                boxesToBeReturned = new ArrayList<Box>(2);
                boxesToBeReturned.add(oneBox);
            }
            boxesToBeReturned.add(boxe);
        }
        if (boxesToBeReturned != null) {
            return boxesToBeReturned;
        }
        if (oneBox != null) {
            return Collections.singletonList(oneBox);
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        List<Box> boxes = this.getBoxes();
        int i = 0;
        while (i < boxes.size()) {
            Box boxe = boxes.get(i);
            if (clazz.isInstance(boxe)) {
                boxesToBeReturned.add(boxe);
            }
            if (recursive && boxe instanceof Container) {
                boxesToBeReturned.addAll(((Container)((Object)boxe)).getBoxes(clazz, recursive));
            }
            ++i;
        }
        return boxesToBeReturned;
    }

    public void addBox(Box box) {
        if (box != null) {
            this.boxes = new ArrayList<Box>(this.getBoxes());
            this.boxes.add(box);
        }
    }

    public void initContainer(ReadableByteChannel readableByteChannel, long containerSize, BoxParser boxParser) throws IOException {
        ParsableBox b;
        for (long contentProcessed = 0L; containerSize < 0L || contentProcessed < containerSize; contentProcessed += b.getSize()) {
            try {
                b = boxParser.parseBox(readableByteChannel, this instanceof ParsableBox ? ((ParsableBox)((Object)this)).getType() : null);
                this.boxes.add(b);
                continue;
            }
            catch (EOFException e) {
                if (containerSize < 0L) {
                    return;
                }
                throw e;
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append("[");
        int i = 0;
        while (i < this.boxes.size()) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(this.boxes.get(i).toString());
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public final void writeContainer(WritableByteChannel bb) throws IOException {
        for (Box box : this.getBoxes()) {
            box.getBox(bb);
        }
    }
}

