/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart.repository;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

final class HelmHome {
    private static final FileAttribute<Set<PosixFilePermission>> permissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"));
    private final Path path;

    HelmHome() {
        this(null);
    }

    HelmHome(Path helmHomePath) {
        if (helmHomePath == null) {
            String helmHome = System.getProperty("helm.home", System.getenv("HELM_HOME"));
            if (helmHome == null) {
                helmHome = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".helm").toString();
                assert (helmHome != null);
            }
            this.path = Paths.get(helmHome, new String[0]);
        } else {
            this.path = helmHomePath;
        }
    }

    final Path toPath() {
        return this.path;
    }

    final Path reify() throws IOException {
        Path helmHome;
        block28: {
            block27: {
                Path repository;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                Path cache;
                                block22: {
                                    helmHome = Files.createDirectories(this.toPath(), permissions);
                                    assert (helmHome != null);
                                    cache = helmHome.resolve("cache");
                                    assert (cache != null);
                                    try {
                                        Files.createDirectory(cache, permissions);
                                    }
                                    catch (FileAlreadyExistsException thatsFine) {
                                        if (Files.isDirectory(cache, new LinkOption[0])) break block22;
                                        throw thatsFine;
                                    }
                                }
                                Path cacheArchive = cache.resolve("archive");
                                assert (cacheArchive != null);
                                try {
                                    Files.createDirectory(cacheArchive, permissions);
                                }
                                catch (FileAlreadyExistsException thatsFine) {
                                    if (Files.isDirectory(cacheArchive, new LinkOption[0])) break block23;
                                    throw thatsFine;
                                }
                            }
                            Path plugins = helmHome.resolve("plugins");
                            assert (plugins != null);
                            try {
                                Files.createDirectory(plugins, permissions);
                            }
                            catch (FileAlreadyExistsException thatsFine) {
                                if (Files.isDirectory(plugins, new LinkOption[0])) break block24;
                                throw thatsFine;
                            }
                        }
                        repository = helmHome.resolve("repository");
                        assert (repository != null);
                        try {
                            Files.createDirectory(repository, permissions);
                        }
                        catch (FileAlreadyExistsException thatsFine) {
                            if (Files.isDirectory(repository, new LinkOption[0])) break block25;
                            throw thatsFine;
                        }
                    }
                    Path repositoryCache = repository.resolve("cache");
                    assert (repositoryCache != null);
                    try {
                        Files.createDirectory(repositoryCache, permissions);
                    }
                    catch (FileAlreadyExistsException thatsFine) {
                        if (Files.isDirectory(repositoryCache, new LinkOption[0])) break block26;
                        throw thatsFine;
                    }
                }
                Path repositoryLocal = repository.resolve("local");
                assert (repositoryLocal != null);
                try {
                    Files.createDirectory(repositoryLocal, permissions);
                }
                catch (FileAlreadyExistsException thatsFine) {
                    if (Files.isDirectory(repositoryLocal, new LinkOption[0])) break block27;
                    throw thatsFine;
                }
            }
            Path starters = helmHome.resolve("starters");
            assert (starters != null);
            try {
                Files.createDirectory(starters, permissions);
            }
            catch (FileAlreadyExistsException thatsFine) {
                if (Files.isDirectory(starters, new LinkOption[0])) break block28;
                throw thatsFine;
            }
        }
        return helmHome;
    }
}

