/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.kamranzafar.jtar.TarInputStream;
import org.microbean.helm.chart.DirectoryChartLoader;
import org.microbean.helm.chart.StreamOrientedChartLoader;
import org.microbean.helm.chart.TapeArchiveChartLoader;
import org.microbean.helm.chart.ZipInputStreamChartLoader;

public class URLChartLoader
extends StreamOrientedChartLoader<URL> {
    private final IdentityHashMap<AutoCloseable, Void> closeables = new IdentityHashMap();

    @Override
    protected Iterable<? extends Map.Entry<? extends String, ? extends InputStream>> toNamedInputStreamEntries(URL url) throws IOException {
        Iterable<? extends Map.Entry<? extends String, ? extends InputStream>> returnValue;
        Objects.requireNonNull(url);
        String scheme = url.getProtocol();
        Path path = null;
        if ("file".equals(scheme)) {
            URI uri = null;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException wrapMe) {
                throw new IllegalArgumentException(wrapMe.getMessage(), wrapMe);
            }
            assert (uri != null);
            try {
                path = Paths.get(uri);
            }
            catch (IllegalArgumentException notAFile) {
                path = null;
            }
        }
        if (path == null || !Files.isDirectory(path, new LinkOption[0])) {
            String urlString = url.toString();
            assert (urlString != null);
            if (urlString.endsWith(".zip") || urlString.endsWith(".jar")) {
                ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(this.openStream(url)));
                this.closeables.put(zipInputStream, null);
                ZipInputStreamChartLoader loader = new ZipInputStreamChartLoader();
                this.closeables.put(loader, null);
                returnValue = loader.toNamedInputStreamEntries(zipInputStream);
            } else {
                TarInputStream tarInputStream = new TarInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(this.openStream(url))));
                this.closeables.put((AutoCloseable)tarInputStream, null);
                TapeArchiveChartLoader loader = new TapeArchiveChartLoader();
                this.closeables.put(loader, null);
                returnValue = loader.toNamedInputStreamEntries(tarInputStream);
            }
        } else {
            DirectoryChartLoader loader = new DirectoryChartLoader();
            this.closeables.put(loader, null);
            returnValue = loader.toNamedInputStreamEntries(path);
        }
        return returnValue;
    }

    protected InputStream openStream(URL url) throws IOException {
        InputStream returnValue = null;
        if (url != null) {
            URLConnection urlConnection = url.openConnection();
            assert (urlConnection != null);
            urlConnection.setRequestProperty("User-Agent", "microbean-helm");
            returnValue = urlConnection.getInputStream();
        }
        return returnValue;
    }

    @Override
    public void close() throws IOException {
        Iterator iterator;
        Set<AutoCloseable> keys;
        if (!this.closeables.isEmpty() && (keys = this.closeables.keySet()) != null && !keys.isEmpty() && (iterator = keys.iterator()) != null) {
            while (iterator.hasNext()) {
                AutoCloseable closeable = (AutoCloseable)iterator.next();
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (IOException | RuntimeException throwMe) {
                        throw throwMe;
                    }
                    catch (Exception willNeverHappen) {
                        throw new AssertionError((Object)willNeverHappen);
                    }
                }
                iterator.remove();
            }
        }
        assert (this.closeables.isEmpty());
    }
}

