/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm;

import hapi.chart.ChartOuterClass;
import hapi.services.tiller.ReleaseServiceGrpc;
import hapi.services.tiller.Tiller;
import io.fabric8.kubernetes.client.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.microbean.helm.Tiller;
import org.microbean.helm.chart.Requirements;

public class ReleaseManager
implements Closeable {
    public static final int DNS_SUBDOMAIN_MAX_LENGTH = 253;
    public static final Pattern DNS_SUBDOMAIN_PATTERN = Pattern.compile("^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$");
    public static final int DNS_LABEL_MAX_LENGTH = 63;
    public static final Pattern DNS_LABEL_PATTERN = Pattern.compile("^[a-z0-9]([-a-z0-9]*[a-z0-9])?$");
    public static final int HELM_RELEASE_NAME_MAX_LENGTH = 53;
    public static final Pattern RFC_1123_PATTERN = DNS_SUBDOMAIN_PATTERN;
    private final Tiller tiller;

    public ReleaseManager(Tiller tiller) {
        Objects.requireNonNull(tiller);
        this.tiller = tiller;
    }

    protected final Tiller getTiller() {
        return this.tiller;
    }

    @Override
    public void close() throws IOException {
        this.getTiller().close();
    }

    public Future<Tiller.GetReleaseContentResponse> getContent(Tiller.GetReleaseContentRequest request) throws IOException {
        Objects.requireNonNull(request);
        this.validate(request);
        ReleaseServiceGrpc.ReleaseServiceFutureStub stub = this.getTiller().getReleaseServiceFutureStub();
        assert (stub != null);
        return stub.getReleaseContent(request);
    }

    public Future<Tiller.GetHistoryResponse> getHistory(Tiller.GetHistoryRequest request) throws IOException {
        Objects.requireNonNull(request);
        this.validate(request);
        ReleaseServiceGrpc.ReleaseServiceFutureStub stub = this.getTiller().getReleaseServiceFutureStub();
        assert (stub != null);
        return stub.getHistory(request);
    }

    public Future<Tiller.GetReleaseStatusResponse> getStatus(Tiller.GetReleaseStatusRequest request) throws IOException {
        Objects.requireNonNull(request);
        this.validate(request);
        ReleaseServiceGrpc.ReleaseServiceFutureStub stub = this.getTiller().getReleaseServiceFutureStub();
        assert (stub != null);
        return stub.getReleaseStatus(request);
    }

    public Future<Tiller.InstallReleaseResponse> install(Tiller.InstallReleaseRequest.Builder requestBuilder, ChartOuterClass.Chart.Builder chartBuilder) throws IOException {
        Objects.requireNonNull(requestBuilder);
        Objects.requireNonNull(chartBuilder);
        this.validate(requestBuilder);
        requestBuilder.setChart(Requirements.apply(chartBuilder, requestBuilder.getValuesBuilder()));
        String releaseNamespace = requestBuilder.getNamespace();
        if (releaseNamespace == null || releaseNamespace.isEmpty()) {
            Config configuration = this.getTiller().getConfiguration();
            if (configuration == null) {
                requestBuilder.setNamespace("default");
            } else {
                releaseNamespace = configuration.getNamespace();
                if (releaseNamespace == null || releaseNamespace.isEmpty()) {
                    requestBuilder.setNamespace("default");
                } else {
                    this.validateNamespace(releaseNamespace);
                    requestBuilder.setNamespace(releaseNamespace);
                }
            }
        } else {
            this.validateNamespace(releaseNamespace);
        }
        ReleaseServiceGrpc.ReleaseServiceFutureStub stub = this.getTiller().getReleaseServiceFutureStub();
        assert (stub != null);
        return stub.installRelease(requestBuilder.build());
    }

    public Iterator<Tiller.ListReleasesResponse> list(Tiller.ListReleasesRequest request) {
        Objects.requireNonNull(request);
        this.validate(request);
        ReleaseServiceGrpc.ReleaseServiceBlockingStub stub = this.getTiller().getReleaseServiceBlockingStub();
        assert (stub != null);
        return stub.listReleases(request);
    }

    public Future<Tiller.RollbackReleaseResponse> rollback(Tiller.RollbackReleaseRequest request) throws IOException {
        Objects.requireNonNull(request);
        this.validate(request);
        ReleaseServiceGrpc.ReleaseServiceFutureStub stub = this.getTiller().getReleaseServiceFutureStub();
        assert (stub != null);
        return stub.rollbackRelease(request);
    }

    public Iterator<Tiller.TestReleaseResponse> test(Tiller.TestReleaseRequest request) {
        Objects.requireNonNull(request);
        this.validate(request);
        ReleaseServiceGrpc.ReleaseServiceBlockingStub stub = this.getTiller().getReleaseServiceBlockingStub();
        assert (stub != null);
        return stub.runReleaseTest(request);
    }

    public Future<Tiller.UninstallReleaseResponse> uninstall(Tiller.UninstallReleaseRequest request) throws IOException {
        Objects.requireNonNull(request);
        this.validate(request);
        ReleaseServiceGrpc.ReleaseServiceFutureStub stub = this.getTiller().getReleaseServiceFutureStub();
        assert (stub != null);
        return stub.uninstallRelease(request);
    }

    public Future<Tiller.UpdateReleaseResponse> update(Tiller.UpdateReleaseRequest.Builder requestBuilder, ChartOuterClass.Chart.Builder chartBuilder) throws IOException {
        Objects.requireNonNull(requestBuilder);
        Objects.requireNonNull(chartBuilder);
        this.validate(requestBuilder);
        requestBuilder.setChart(Requirements.apply(chartBuilder, requestBuilder.getValuesBuilder()));
        ReleaseServiceGrpc.ReleaseServiceFutureStub stub = this.getTiller().getReleaseServiceFutureStub();
        assert (stub != null);
        return stub.updateRelease(requestBuilder.build());
    }

    protected void validate(Tiller.GetReleaseContentRequestOrBuilder request) {
        Objects.requireNonNull(request);
        this.validateReleaseName(request.getName());
    }

    protected void validate(Tiller.GetHistoryRequestOrBuilder request) {
        Objects.requireNonNull(request);
        this.validateReleaseName(request.getName());
    }

    protected void validate(Tiller.GetReleaseStatusRequestOrBuilder request) {
        Objects.requireNonNull(request);
        this.validateReleaseName(request.getName());
    }

    protected void validate(Tiller.InstallReleaseRequestOrBuilder request) {
        Objects.requireNonNull(request);
        this.validateReleaseName(request.getName());
    }

    protected void validate(Tiller.ListReleasesRequestOrBuilder request) {
        Objects.requireNonNull(request);
        String filter = request.getFilter();
        if (filter != null && !filter.isEmpty()) {
            Pattern.compile(filter);
        }
    }

    protected void validate(Tiller.RollbackReleaseRequestOrBuilder request) {
        Objects.requireNonNull(request);
        this.validateReleaseName(request.getName());
    }

    protected void validate(Tiller.TestReleaseRequestOrBuilder request) {
        Objects.requireNonNull(request);
        this.validateReleaseName(request.getName());
    }

    protected void validate(Tiller.UninstallReleaseRequestOrBuilder request) {
        Objects.requireNonNull(request);
        this.validateReleaseName(request.getName());
    }

    protected void validate(Tiller.UpdateReleaseRequestOrBuilder request) {
        Objects.requireNonNull(request);
        this.validateReleaseName(request.getName());
    }

    protected void validateReleaseName(String name) {
        if (name != null) {
            int nameLength = name.length();
            if (nameLength > 53) {
                throw new IllegalArgumentException("Invalid release name: " + name + "; length is greater than " + 53 + " characters: " + nameLength);
            }
            if (nameLength > 0) {
                Matcher matcher = DNS_SUBDOMAIN_PATTERN.matcher(name);
                assert (matcher != null);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Invalid release name: " + name + "; must match " + DNS_SUBDOMAIN_PATTERN.toString());
                }
            }
        }
    }

    protected void validateNamespace(String namespace) {
        if (namespace != null) {
            int namespaceLength = namespace.length();
            if (namespaceLength > 63) {
                throw new IllegalArgumentException("Invalid namespace: " + namespace + "; length is greater than " + 63 + " characters: " + namespaceLength);
            }
            if (namespaceLength > 0) {
                Matcher matcher = DNS_LABEL_PATTERN.matcher(namespace);
                assert (matcher != null);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Invalid namespace: " + namespace + "; must match " + DNS_LABEL_PATTERN.toString());
                }
            }
        }
    }
}

