/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Filesystem$ {
    public static final Filesystem$ MODULE$;

    static {
        new Filesystem$();
    }

    public ByteBuffer toMappedByteBuffer(String path) {
        File f = new File(path);
        FileInputStream fis = new FileInputStream(f);
        int size = (int)f.length();
        FileChannel channel = fis.getChannel();
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        channel.close();
        fis.close();
        return buffer;
    }

    public byte[] slurp(String path, int bs) {
        ByteBuffer buffer = this.toMappedByteBuffer(path);
        int i = 0;
        byte[] data = (byte[])Array$.MODULE$.ofDim(buffer.capacity(), ClassTag$.MODULE$.Byte());
        while (buffer.hasRemaining()) {
            int n = package$.MODULE$.min(buffer.remaining(), bs);
            buffer.get(data, i, n);
            i += n;
        }
        return data;
    }

    public int slurp$default$2() {
        return 262144;
    }

    /*
     * WARNING - void declaration
     */
    public void mapToByteArray(String path, byte[] data, int startIndex, int size) {
        MappedByteBuffer mappedByteBuffer;
        File f = new File(path);
        FileInputStream fis = new FileInputStream(f);
        try {
            FileChannel channel = fis.getChannel();
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, startIndex, size);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.close();
            throw throwable;
        }
        fis.close();
        MappedByteBuffer buffer = mappedByteBuffer;
        buffer.get(data, startIndex, size);
    }

    public String basename(String path) {
        String string;
        int n = path.lastIndexOf(".");
        switch (n) {
            default: {
                string = path.substring(0, n);
                break;
            }
            case -1: {
                string = path;
            }
        }
        return string;
    }

    public Tuple2<String, String> split(String path) {
        Tuple2 tuple2;
        int n = path.lastIndexOf(".");
        switch (n) {
            default: {
                tuple2 = new Tuple2((Object)path.substring(0, n), (Object)path.substring(n + 1, path.length()));
                break;
            }
            case -1: {
                tuple2 = new Tuple2((Object)path, (Object)"");
            }
        }
        return tuple2;
    }

    public String join(Seq<String> parts) {
        return parts.mkString(File.separator);
    }

    /*
     * WARNING - void declaration
     */
    public String readText(String path) {
        String string;
        BufferedSource src = Source$.MODULE$.fromFile(path, "UTF-8");
        try {
            string = src.mkString();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        src.close();
        return string;
    }

    public String readText(File file) {
        return this.readText(file.getAbsolutePath());
    }

    public void writeBytes(String path, byte[] bytes) {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        bos.write(bytes);
        bos.close();
    }

    public void writeText(String path, String text) {
        Files.write(Paths.get(path, new String[0]), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void writeText(File file, String text) {
        this.writeText(file.getAbsolutePath(), text);
    }

    public void move(String source, String target) {
        Files.move(Paths.get(source, new String[0]), Paths.get(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public void move(File source, File target) {
        this.move(source.getAbsolutePath(), target.getAbsolutePath());
    }

    public void copy(String source, String target) {
        Files.copy(Paths.get(source, new String[0]), Paths.get(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public void copy(File source, File target) {
        this.copy(source.getAbsolutePath(), target.getAbsolutePath());
    }

    public String ensureDirectory(String path) {
        Boolean bl;
        File f = new File(path);
        if (f.exists()) {
            Predef$.MODULE$.require(f.isDirectory(), (Function0)new Serializable(f){
                public static final long serialVersionUID = 0L;
                private final File f$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " exists and is not a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f$1}));
                }
                {
                    this.f$1 = f$1;
                }
            });
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)f.mkdirs());
        }
        return path;
    }

    private Filesystem$() {
        MODULE$ = this;
    }
}

