/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.util;

import geotrellis.util.FileRangeReader$;
import geotrellis.util.RangeReader;
import geotrellis.util.RangeReader$class;
import java.io.File;
import java.io.FileInputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import scala.Array$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u000f\tya)\u001b7f%\u0006tw-\u001a*fC\u0012,'O\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\u0005)\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u0017I\u000bgnZ3SK\u0006$WM\u001d\u0005\t'\u0001\u0011\t\u0011)A\u0005)\u0005!a-\u001b7f!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0002j_*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0017\u0005\u00111\u0015\u000e\\3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0002\u0005\u0005\u0002\u0010\u0001!)1\u0003\ba\u0001)!)!\u0005\u0001C\u0001G\u0005YAo\u001c;bY2+gn\u001a;i+\u0005!\u0003CA\u0005&\u0013\t1#B\u0001\u0003M_:<\u0007\"\u0002\u0015\u0001\t\u0003I\u0013\u0001\u0005:fC\u0012\u001cE.\u001b9qK\u0012\u0014\u0016M\\4f)\rQ\u0003G\r\t\u0004\u0013-j\u0013B\u0001\u0017\u000b\u0005\u0015\t%O]1z!\tIa&\u0003\u00020\u0015\t!!)\u001f;f\u0011\u0015\tt\u00051\u0001%\u0003\u0015\u0019H/\u0019:u\u0011\u0015\u0019t\u00051\u00015\u0003\u0019aWM\\4uQB\u0011\u0011\"N\u0005\u0003m)\u00111!\u00138u\u000f\u0015A$\u0001#\u0001:\u0003=1\u0015\u000e\\3SC:<WMU3bI\u0016\u0014\bCA\b;\r\u0015\t!\u0001#\u0001<'\tQ\u0004\u0002C\u0003\u001eu\u0011\u0005Q\bF\u0001:\u0011\u0015y$\b\"\u0001A\u0003\u0015\t\u0007\u000f\u001d7z)\ty\u0012\tC\u0003C}\u0001\u00071)\u0001\u0003qCRD\u0007C\u0001#H\u001d\tIQ)\u0003\u0002G\u0015\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1%\u0002C\u0003@u\u0011\u00051\n\u0006\u0002 \u0019\")1C\u0013a\u0001)\u0001")
public class FileRangeReader
implements RangeReader {
    private final File file;

    public static FileRangeReader apply(File file) {
        return FileRangeReader$.MODULE$.apply(file);
    }

    public static FileRangeReader apply(String string) {
        return FileRangeReader$.MODULE$.apply(string);
    }

    @Override
    public byte[] readRange(long start, int length) {
        return RangeReader$class.readRange(this, start, length);
    }

    @Override
    public byte[] readAll() {
        return RangeReader$class.readAll(this);
    }

    @Override
    public long totalLength() {
        return this.file.length();
    }

    @Override
    public byte[] readClippedRange(long start, int length) {
        FileInputStream inputStream = new FileInputStream(this.file);
        FileChannel channel = inputStream.getChannel();
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, start, length);
        int i = 0;
        byte[] data = (byte[])Array$.MODULE$.ofDim(buffer.capacity(), ClassTag$.MODULE$.Byte());
        while (buffer.hasRemaining()) {
            int n = package$.MODULE$.min(buffer.remaining(), 262144);
            buffer.get(data, i, n);
            i += n;
        }
        channel.close();
        inputStream.close();
        return data;
    }

    public FileRangeReader(File file) {
        this.file = file;
        RangeReader$class.$init$(this);
    }
}

