/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.viewshed;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import scala.Double$;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.RichDouble$;
import scala.sys.package$;

public final class Viewshed$
implements Serializable {
    public static final Viewshed$ MODULE$;

    static {
        new Viewshed$();
    }

    public Tile apply(Tile r, int startCol, int startRow) {
        Tuple2<Object, Object> tuple2 = r.dimensions();
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tuple2._1$mcI$sp(), tuple2._2$mcI$sp());
            int cols = sp2._1$mcI$sp();
            int rows = sp2._2$mcI$sp();
            MutableArrayTile tile = ArrayTile$.MODULE$.alloc(BitCellType$.MODULE$, cols, rows);
            double height = r.getDouble(startCol, startRow);
            Tile requiredHeights = this.offsets(r, startCol, startRow);
            for (int index$macro$679 = 0; index$macro$679 < rows; ++index$macro$679) {
                for (int index$macro$678 = 0; index$macro$678 < cols; ++index$macro$678) {
                    if (height >= requiredHeights.getDouble(index$macro$678, index$macro$679) - 0.5) {
                        tile.set(index$macro$678, index$macro$679, 1);
                        continue;
                    }
                    tile.set(index$macro$678, index$macro$679, 0);
                }
            }
            return tile;
        }
        throw new MatchError(tuple2);
    }

    public Tile offsets(Tile r, int startCol, int startRow) {
        Tuple2<Object, Object> tuple2 = r.dimensions();
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tuple2._1$mcI$sp(), tuple2._2$mcI$sp());
            int cols = sp2._1$mcI$sp();
            int rows = sp2._2$mcI$sp();
            if (startRow >= rows || startRow < 0 || startCol >= cols || startCol < 0) {
                throw package$.MODULE$.error("Point indices out of bounds");
            }
            MutableArrayTile tile = ArrayTile$.MODULE$.alloc(DoubleConstantNoDataCellType$.MODULE$, cols, rows);
            for (int index$macro$683 = 0; index$macro$683 < rows; ++index$macro$683) {
                for (int index$macro$682 = 0; index$macro$682 < cols; ++index$macro$682) {
                    double height = r.getDouble(index$macro$682, index$macro$683);
                    if (Double.isNaN(height)) {
                        tile.setDouble(index$macro$682, index$macro$683, Double.NaN);
                        continue;
                    }
                    double max = Double$.MODULE$.MinValue();
                    if (startRow != index$macro$683) {
                        Tuple2.mcII.sp sp3 = startRow < index$macro$683 ? new Tuple2.mcII.sp(startRow + 1, index$macro$683) : new Tuple2.mcII.sp(index$macro$683 + 1, startRow);
                        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(sp3._1$mcI$sp(), sp3._2$mcI$sp());
                        int rowMin = sp4._1$mcI$sp();
                        int rowMax = sp4._2$mcI$sp();
                        for (int index$macro$680 = rowMin; index$macro$680 <= rowMax; ++index$macro$680) {
                            double x = (double)(index$macro$680 - startRow) / (double)(index$macro$683 - startRow) * (double)(index$macro$682 - startCol) + (double)startCol;
                            int xInt = (int)x;
                            Predef$ predef$ = Predef$.MODULE$;
                            double z = RichDouble$.MODULE$.isValidInt$extension(x) ? r.getDouble(xInt, index$macro$680) : ((double)(xInt + 1) - x) * r.getDouble(xInt, index$macro$680) + (x - (double)xInt) * r.getDouble(xInt + 1, index$macro$680);
                            double requiredHeight = (double)(startRow - index$macro$683) / (double)(index$macro$680 - index$macro$683) * (z - height) + height;
                            if (!(requiredHeight > max)) continue;
                            max = requiredHeight;
                        }
                    }
                    if (startCol != index$macro$682) {
                        Tuple2.mcII.sp sp5 = startCol < index$macro$682 ? new Tuple2.mcII.sp(startCol + 1, index$macro$682) : new Tuple2.mcII.sp(index$macro$682 + 1, startCol);
                        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(sp5._1$mcI$sp(), sp5._2$mcI$sp());
                        int colMin = sp6._1$mcI$sp();
                        int colMax = sp6._2$mcI$sp();
                        for (int index$macro$681 = colMin; index$macro$681 <= colMax; ++index$macro$681) {
                            double y = (double)(index$macro$681 - startCol) / (double)(index$macro$682 - startCol) * (double)(index$macro$683 - startRow) + (double)startRow;
                            int yInt = (int)y;
                            Predef$ predef$ = Predef$.MODULE$;
                            double z = RichDouble$.MODULE$.isValidInt$extension(y) ? r.getDouble(index$macro$681, yInt) : ((double)(yInt + 1) - y) * r.getDouble(index$macro$681, yInt) + (y - (double)yInt) * r.getDouble(index$macro$681, yInt + 1);
                            double requiredHeight = (double)(startCol - index$macro$682) / (double)(index$macro$681 - index$macro$682) * (z - height) + height;
                            if (!(requiredHeight > max)) continue;
                            max = requiredHeight;
                        }
                    }
                    tile.setDouble(index$macro$682, index$macro$683, max);
                }
            }
            return tile;
        }
        throw new MatchError(tuple2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Viewshed$() {
        MODULE$ = this;
    }
}

