/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.viewshed;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class ApproxViewshed$
implements Serializable {
    public static final ApproxViewshed$ MODULE$;

    static {
        new ApproxViewshed$();
    }

    public Tile apply(Tile r, int col, int row) {
        return package$.MODULE$.withTileMethods(r).localEqual(this.offsets(r, col, row));
    }

    public Tile offsets(Tile r, int startCol, int startRow) {
        int rows = r.rows();
        int cols = r.cols();
        if (startCol < 0 || startCol >= cols || startRow < 0 && startRow >= rows) {
            throw scala.sys.package$.MODULE$.error("Point indices out of bounds");
        }
        double k = r.getDouble(startCol, startRow);
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(DoubleConstantNoDataCellType$.MODULE$, cols, rows);
        tile.setDouble(startCol, startRow, k);
        int maxLayer = BoxesRunTime.unboxToInt((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{rows - startRow, cols - startCol, startRow + 1, startCol + 1})).max((Ordering)Ordering.Int$.MODULE$));
        Predef$ predef$ = Predef$.MODULE$;
        Serializable serializable = new Serializable(r, startCol, startRow, rows, cols, k, tile){
            public static final long serialVersionUID = 0L;
            private final Tile r$1;
            private final int startCol$1;
            private final int startRow$1;
            private final int rows$1;
            private final int cols$1;
            private final double k$1;
            private final MutableArrayTile tile$1;

            public final void apply(int layer) {
                this.apply$mcVI$sp(layer);
            }

            public void apply$mcVI$sp(int layer) {
                for (int index$macro$677 = 0; index$macro$677 < 2 * layer; ++index$macro$677) {
                    this.doY$1(this.startCol$1 - layer + index$macro$677, this.startRow$1 - layer, layer);
                    this.doY$1(this.startCol$1 + layer - index$macro$677, this.startRow$1 + layer, layer);
                    this.doX$1(this.startCol$1 - layer, this.startRow$1 + layer - index$macro$677, layer);
                    this.doX$1(this.startCol$1 + layer, this.startRow$1 - layer + index$macro$677, layer);
                }
            }

            private final void doY$1(int x, int y, int layer$1) {
                if (y >= 0 && y < this.rows$1 && x >= 0 && x < this.cols$1) {
                    double z = this.r$1.getDouble(x, y);
                    if (layer$1 == 1) {
                        this.tile$1.setDouble(x, y, z);
                    } else {
                        double closestHeight;
                        double d;
                        double xVal = scala.math.package$.MODULE$.abs(1.0 / (double)(this.startRow$1 - y)) * (double)(this.startCol$1 - x) + (double)x;
                        int xInt = (int)xVal;
                        if (this.startRow$1 == y) {
                            d = this.tile$1.getDouble(x, y - scala.math.package$.MODULE$.signum(y - this.startRow$1));
                        } else {
                            Predef$ predef$ = Predef$.MODULE$;
                            d = closestHeight = RichDouble$.MODULE$.isValidInt$extension(xVal) ? this.tile$1.getDouble(xInt, y - scala.math.package$.MODULE$.signum(y - this.startRow$1)) : ((double)(xInt + 1) - xVal) * this.tile$1.getDouble(xInt, y - scala.math.package$.MODULE$.signum(y - this.startRow$1)) + (xVal - (double)xInt) * this.tile$1.getDouble(xInt + 1, y - scala.math.package$.MODULE$.signum(y - this.startRow$1));
                        }
                        if (y > this.startRow$1) {
                            this.tile$1.setDouble(x, y, scala.math.package$.MODULE$.max(z, 1.0 / (double)(this.startRow$1 - (y - 1)) * (this.k$1 - closestHeight) + closestHeight));
                        } else {
                            this.tile$1.setDouble(x, y, scala.math.package$.MODULE$.max(z, -1.0 / (double)(this.startRow$1 - (y + 1)) * (this.k$1 - closestHeight) + closestHeight));
                        }
                    }
                }
            }

            private final void doX$1(int x, int y, int layer$1) {
                if (y >= 0 && y < this.rows$1 && x >= 0 && x < this.cols$1) {
                    double z = this.r$1.getDouble(x, y);
                    if (layer$1 == 1) {
                        this.tile$1.setDouble(x, y, z);
                    } else {
                        double closestHeight;
                        double d;
                        double yVal = scala.math.package$.MODULE$.abs(1.0 / (double)(this.startCol$1 - x)) * (double)(this.startRow$1 - y) + (double)y;
                        int yInt = (int)yVal;
                        if (this.startCol$1 == x) {
                            d = this.tile$1.getDouble(x - scala.math.package$.MODULE$.signum(x - this.startCol$1), y);
                        } else {
                            Predef$ predef$ = Predef$.MODULE$;
                            d = closestHeight = RichDouble$.MODULE$.isValidInt$extension(yVal) ? this.tile$1.getDouble(x - scala.math.package$.MODULE$.signum(x - this.startCol$1), yInt) : ((double)(yInt + 1) - yVal) * this.tile$1.getDouble(x - scala.math.package$.MODULE$.signum(x - this.startCol$1), yInt) + (yVal - (double)yInt) * this.tile$1.getDouble(x - scala.math.package$.MODULE$.signum(x - this.startCol$1), yInt + 1);
                        }
                        if (x > this.startCol$1) {
                            this.tile$1.setDouble(x, y, scala.math.package$.MODULE$.max(z, 1.0 / (double)(this.startCol$1 - (x - 1)) * (this.k$1 - closestHeight) + closestHeight));
                        } else {
                            this.tile$1.setDouble(x, y, scala.math.package$.MODULE$.max(z, -1.0 / (double)(this.startCol$1 - (x + 1)) * (this.k$1 - closestHeight) + closestHeight));
                        }
                    }
                }
            }
            {
                this.r$1 = r$1;
                this.startCol$1 = startCol$1;
                this.startRow$1 = startRow$1;
                this.rows$1 = rows$1;
                this.cols$1 = cols$1;
                this.k$1 = k$1;
                this.tile$1 = tile$1;
            }
        };
        Range range = Range$.MODULE$.apply(1, maxLayer);
        if (!range.isEmpty()) {
            int n = range.start();
            while (true) {
                serializable.apply$mcVI$sp(n);
                if (n == range.lastElement()) break;
                n += range.step();
            }
        }
        return tile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ApproxViewshed$() {
        MODULE$ = this;
    }
}

