/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.vectorize;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001%\u00111\u0002U8ms\u001e|g.\u001b>fe*\u00111\u0001B\u0001\nm\u0016\u001cGo\u001c:ju\u0016T!!\u0002\u0004\u0002\rI\f7\u000f^3s\u0015\u00059\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001BC\u0002\u0013\u0005!#A\u0001s+\u0005\u0019\u0002C\u0001\u000b\u0016\u001b\u0005!\u0011B\u0001\f\u0005\u0005\u0011!\u0016\u000e\\3\t\u0011a\u0001!\u0011!Q\u0001\nM\t!A\u001d\u0011\t\u0011i\u0001!\u0011!Q\u0001\nm\tAB]1ti\u0016\u0014X\t\u001f;f]R\u0004\"\u0001\u0006\u000f\n\u0005u!!\u0001\u0004*bgR,'/\u0012=uK:$\b\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0002\"G\u0011\u0002\"A\t\u0001\u000e\u0003\tAQ!\u0005\u0010A\u0002MAQA\u0007\u0010A\u0002mAqA\n\u0001C\u0002\u0013\u0005q%\u0001\u0003d_2\u001cX#\u0001\u0015\u0011\u0005-I\u0013B\u0001\u0016\r\u0005\rIe\u000e\u001e\u0005\u0007Y\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u000b\r|Gn\u001d\u0011\t\u000f9\u0002!\u0019!C\u0001O\u0005!!o\\<t\u0011\u0019\u0001\u0004\u0001)A\u0005Q\u0005)!o\\<tA!9!\u0007\u0001b\u0001\n\u0003\u0019\u0014!\u00045bY\u001a\u001cU\r\u001c7XS\u0012$\b.F\u00015!\tYQ'\u0003\u00027\u0019\t1Ai\\;cY\u0016Da\u0001\u000f\u0001!\u0002\u0013!\u0014A\u00045bY\u001a\u001cU\r\u001c7XS\u0012$\b\u000e\t\u0005\bu\u0001\u0011\r\u0011\"\u00014\u00039A\u0017\r\u001c4DK2d\u0007*Z5hQRDa\u0001\u0010\u0001!\u0002\u0013!\u0014a\u00045bY\u001a\u001cU\r\u001c7IK&<\u0007\u000e\u001e\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005Q!\u000e^:GC\u000e$xN]=\u0016\u0003\u0001\u0003\"!\u0011&\u000e\u0003\tS!a\u0011#\u0002\t\u001d,w.\u001c\u0006\u0003\u000b\u001a\u000b1A\u001b;t\u0015\t9\u0005*\u0001\bwSZLGm]8mkRLwN\\:\u000b\u0003%\u000b1aY8n\u0013\tY%IA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0011\u0019i\u0005\u0001)A\u0005\u0001\u0006Y!\u000e^:GC\u000e$xN]=!\u0011\u001dy\u0005A1A\u0005\u0002\u001d\n\u0001BT(U\r>+f\n\u0012\u0005\u0007#\u0002\u0001\u000b\u0011\u0002\u0015\u0002\u00139{EKR(V\u001d\u0012\u0003\u0003bB*\u0001\u0005\u0004%\taJ\u0001\u0005\u0019\u00163E\u000b\u0003\u0004V\u0001\u0001\u0006I\u0001K\u0001\u0006\u0019\u00163E\u000b\t\u0005\b/\u0002\u0011\r\u0011\"\u0001(\u0003\u0011!uj\u0016(\t\re\u0003\u0001\u0015!\u0003)\u0003\u0015!uj\u0016(!\u0011\u001dY\u0006A1A\u0005\u0002\u001d\nQAU%H\u0011RCa!\u0018\u0001!\u0002\u0013A\u0013A\u0002*J\u000f\"#\u0006\u0005C\u0004`\u0001\t\u0007I\u0011A\u0014\u0002\u0005U\u0003\u0006BB1\u0001A\u0003%\u0001&A\u0002V!\u0002Bqa\u0019\u0001C\u0002\u0013\u0005q%A\u0004U\u001fBcUI\u0012+\t\r\u0015\u0004\u0001\u0015!\u0003)\u0003!!v\n\u0015'F\rR\u0003\u0003bB4\u0001\u0005\u0004%\taJ\u0001\u000b\u0005>#FkT'M\u000b\u001a#\u0006BB5\u0001A\u0003%\u0001&A\u0006C\u001fR#v*\u0014'F\rR\u0003\u0003bB6\u0001\u0005\u0004%\taJ\u0001\f\u0005>#FkT'S\u0013\u001eCE\u000b\u0003\u0004n\u0001\u0001\u0006I\u0001K\u0001\r\u0005>#FkT'S\u0013\u001eCE\u000b\t\u0005\b_\u0002\u0011\r\u0011\"\u0001(\u0003!!v\n\u0015*J\u000f\"#\u0006BB9\u0001A\u0003%\u0001&A\u0005U\u001fB\u0013\u0016j\u0012%UA!)1\u000f\u0001C\u0001i\u0006\u00111\u000f\u001a\u000b\u0003kv\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\t1\fgn\u001a\u0006\u0002u\u0006!!.\u0019<b\u0013\taxO\u0001\u0004TiJLgn\u001a\u0005\u0006}J\u0004\r\u0001K\u0001\u0002I\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0011AA:n)\r)\u0018Q\u0001\u0005\u0006}~\u0004\r\u0001\u000b\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003\u0011i\u0017M]6\u0015\u0011\u00055\u00111CA\f\u00037\u00012!QA\b\u0013\r\t\tB\u0011\u0002\u000b\u0007>|'\u000fZ5oCR,\u0007bBA\u000b\u0003\u000f\u0001\r\u0001K\u0001\u0004G>d\u0007bBA\r\u0003\u000f\u0001\r\u0001K\u0001\u0004e><\bbBA\u000f\u0003\u000f\u0001\r\u0001K\u0001\u0002[\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012!C7bW\u0016l\u0015M]6t)1\t)#a\u000b\u0002@\u0005\u0005\u00131IA#!\rY\u0011qE\u0005\u0004\u0003Sa!aA!os\"A\u0011QFA\u0010\u0001\u0004\ty#\u0001\u0004q_&tGo\u001d\t\u0007\u0003c\tY$!\u0004\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tq!\\;uC\ndWMC\u0002\u0002:1\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti$a\r\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u0003+\ty\u00021\u0001)\u0011\u001d\tI\"a\bA\u0002!BaA`A\u0010\u0001\u0004A\u0003bBA$\u0003?\u0001\r\u0001K\u0001\u0003a\u0012Dq!a\u0013\u0001\t\u0003\ti%A\tgS:$g*\u001a=u\t&\u0014Xm\u0019;j_:$\u0012\u0002KA(\u0003#\n\u0019&!\u0016\t\u000f\u0005U\u0011\u0011\na\u0001Q!9\u0011\u0011DA%\u0001\u0004A\u0003B\u0002@\u0002J\u0001\u0007\u0001\u0006C\u0004\u0002X\u0005%\u0003\u0019\u0001\u0015\u0002\u0017Q\f'oZ3u-\u0006dW/\u001a\u0005\b\u00037\u0002A\u0011AA/\u000359W\r\u001e'j]\u0016\f'OU5oOV!\u0011qLA:)\u0019\t\t'a\u001a\u0002jA\u0019\u0011)a\u0019\n\u0007\u0005\u0015$I\u0001\u0006MS:,\u0017M\u001d*j]\u001eDq!a\u0016\u0002Z\u0001\u0007\u0001\u0006\u0003\u0005\u0002l\u0005e\u0003\u0019AA7\u0003)\u0019H/\u0019:u!>Lg\u000e\u001e\t\u0006\u0017\u0005=\u0004\u0006K\u0005\u0004\u0003cb!A\u0002+va2,'\u0007\u0002\u0005\u0002v\u0005e#\u0019AA<\u0005\u0005!\u0016\u0003BA=\u0003K\u00012aCA>\u0013\r\ti\b\u0004\u0002\b\u001d>$\b.\u001b8h\u0001")
public class Polygonizer {
    private final Tile r;
    private final RasterExtent rasterExtent;
    private final int cols;
    private final int rows;
    private final double halfCellWidth;
    private final double halfCellHeight;
    private final GeometryFactory jtsFactory;
    private final int NOTFOUND;
    private final int LEFT;
    private final int DOWN;
    private final int RIGHT;
    private final int UP;
    private final int TOPLEFT;
    private final int BOTTOMLEFT;
    private final int BOTTOMRIGHT;
    private final int TOPRIGHT;

    public Tile r() {
        return this.r;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    public double halfCellWidth() {
        return this.halfCellWidth;
    }

    public double halfCellHeight() {
        return this.halfCellHeight;
    }

    public GeometryFactory jtsFactory() {
        return this.jtsFactory;
    }

    public int NOTFOUND() {
        return this.NOTFOUND;
    }

    public int LEFT() {
        return this.LEFT;
    }

    public int DOWN() {
        return this.DOWN;
    }

    public int RIGHT() {
        return this.RIGHT;
    }

    public int UP() {
        return this.UP;
    }

    public int TOPLEFT() {
        return this.TOPLEFT;
    }

    public int BOTTOMLEFT() {
        return this.BOTTOMLEFT;
    }

    public int BOTTOMRIGHT() {
        return this.BOTTOMRIGHT;
    }

    public int TOPRIGHT() {
        return this.TOPRIGHT;
    }

    public String sd(int d) {
        String string = this.NOTFOUND() == d ? "NOTFOUND" : (this.LEFT() == d ? "LEFT" : (this.DOWN() == d ? "DOWN" : (this.RIGHT() == d ? "RIGHT" : (this.UP() == d ? "UP" : "BAD"))));
        return string;
    }

    public String sm(int d) {
        String string = this.TOPLEFT() == d ? "TOPLEFT" : (this.BOTTOMLEFT() == d ? "BOTTOMLEFT" : (this.BOTTOMRIGHT() == d ? "BOTTOMRIGHT" : (this.TOPRIGHT() == d ? "TOPRIGHT" : "BAD")));
        return string;
    }

    public Coordinate mark(int col, int row, int m) {
        block6: {
            Coordinate coordinate;
            block3: {
                double mapY;
                double mapX;
                block5: {
                    block4: {
                        block2: {
                            mapX = this.rasterExtent.gridColToMap(col);
                            mapY = this.rasterExtent.gridRowToMap(row);
                            if (m != this.TOPLEFT()) break block2;
                            coordinate = new Coordinate(mapX - this.halfCellWidth(), mapY + this.halfCellHeight());
                            break block3;
                        }
                        if (m != this.BOTTOMLEFT()) break block4;
                        coordinate = new Coordinate(mapX - this.halfCellWidth(), mapY - this.halfCellHeight());
                        break block3;
                    }
                    if (m != this.BOTTOMRIGHT()) break block5;
                    coordinate = new Coordinate(mapX + this.halfCellWidth(), mapY - this.halfCellHeight());
                    break block3;
                }
                if (m != this.TOPRIGHT()) break block6;
                coordinate = new Coordinate(mapX + this.halfCellWidth(), mapY + this.halfCellHeight());
            }
            return coordinate;
        }
        throw package$.MODULE$.error("Bad Mark Integer");
    }

    public Object makeMarks(ArrayBuffer<Coordinate> points, int col, int row, int d, int pd) {
        block31: {
            BoxedUnit boxedUnit;
            block28: {
                block30: {
                    block29: {
                        block27: {
                            if (d != this.DOWN()) break block27;
                            if (pd != this.DOWN()) {
                                if (pd == this.RIGHT()) {
                                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.BOTTOMLEFT()));
                                } else if (pd == this.LEFT()) {
                                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.TOPLEFT()));
                                } else {
                                    points.$plus$eq((Object)this.mark(col, row - 1, this.TOPRIGHT()));
                                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.TOPLEFT()));
                                }
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            break block28;
                        }
                        if (d != this.RIGHT()) break block29;
                        if (pd != this.RIGHT()) {
                            if (pd == this.UP()) {
                                boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMRIGHT()));
                            } else if (pd == this.DOWN()) {
                                boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMLEFT()));
                            } else {
                                points.$plus$eq((Object)this.mark(col - 1, row, this.TOPLEFT()));
                                boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMLEFT()));
                            }
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block28;
                    }
                    if (d != this.UP()) break block30;
                    if (pd != this.UP()) {
                        if (pd == this.LEFT()) {
                            boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.TOPRIGHT()));
                        } else if (pd == this.RIGHT()) {
                            boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMRIGHT()));
                        } else {
                            points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMLEFT()));
                            boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMRIGHT()));
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    break block28;
                }
                if (d != this.LEFT()) break block31;
                if (pd != this.LEFT()) {
                    if (pd == this.DOWN()) {
                        boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPLEFT()));
                    } else if (pd == this.UP()) {
                        boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPRIGHT()));
                    } else {
                        points.$plus$eq((Object)this.mark(col + 1, row, this.BOTTOMRIGHT()));
                        boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPRIGHT()));
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown direction ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)d)})));
    }

    public int findNextDirection(int col, int row, int d, int targetValue) {
        for (int i = d + 3; i < d + 7; ++i) {
            int m = i % 4;
            if (m == 0) {
                if (col <= 0 || this.r().get(col - 1, row) != targetValue) continue;
                return this.LEFT();
            }
            if (m == 1) {
                if (row + 1 >= this.rows() || this.r().get(col, row + 1) != targetValue) continue;
                return this.DOWN();
            }
            if (m == 2) {
                if (col + 1 >= this.cols() || this.r().get(col + 1, row) != targetValue) continue;
                return this.RIGHT();
            }
            if (m != 3 || row <= 0 || this.r().get(col, row - 1) != targetValue) continue;
            return this.UP();
        }
        return this.NOTFOUND();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> LinearRing getLinearRing(int targetValue, Tuple2<Object, Object> startPoint) {
        ArrayBuffer arrayBuffer;
        ArrayBuffer points = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int startCol = startPoint._1$mcI$sp();
        int startRow = startPoint._2$mcI$sp();
        int direction = this.NOTFOUND();
        if (startRow + 1 < this.rows() && this.r().get(startCol, startRow + 1) == targetValue) {
            direction = this.DOWN();
        }
        if (direction == this.NOTFOUND() && startCol < this.cols() && this.r().get(startCol + 1, startRow) == targetValue) {
            direction = this.RIGHT();
        }
        if (direction == this.NOTFOUND()) {
            points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMLEFT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMRIGHT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPRIGHT()));
            arrayBuffer = points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
            return this.jtsFactory().createLinearRing((Coordinate[])points.toArray(ClassTag$.MODULE$.apply(Coordinate.class)));
        }
        points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
        Object object = direction == this.RIGHT() ? points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMLEFT())) : BoxedUnit.UNIT;
        int previousDirection = direction;
        int col = startCol;
        int row = startRow;
        boolean bl = false;
        while (true) {
            boolean bl2;
            void var5_5;
            void var4_4;
            void var7_7;
            void var3_3;
            void var8_8;
            void var9_9;
            int n;
            if (bl) {
                Object object2 = previousDirection == this.UP() ? points.$plus$eq((Object)this.mark(col, row, this.TOPRIGHT())) : BoxedUnit.UNIT;
                arrayBuffer = points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
                return this.jtsFactory().createLinearRing((Coordinate[])points.toArray(ClassTag$.MODULE$.apply(Coordinate.class)));
            }
            if (n == this.DOWN()) {
                ++var9_9;
            } else if (n == this.RIGHT()) {
                ++var8_8;
            } else if (n == this.UP()) {
                --var9_9;
            } else if (n == this.LEFT()) {
                --var8_8;
            }
            this.makeMarks((ArrayBuffer<Coordinate>)var3_3, (int)var8_8, (int)var9_9, n, (int)var7_7);
            var7_7 = n;
            n = this.findNextDirection((int)var8_8, (int)var9_9, n, targetValue);
            if (var8_8 != var4_4 || var9_9 != var5_5) continue;
            if (var7_7 == this.LEFT() || var7_7 == this.DOWN()) {
                bl2 = true;
                continue;
            }
            if (var7_7 != this.UP() && var7_7 != this.RIGHT() || n != this.DOWN() && n != this.LEFT()) continue;
            bl2 = true;
        }
    }

    public Polygonizer(Tile r, RasterExtent rasterExtent) {
        this.r = r;
        this.rasterExtent = rasterExtent;
        this.cols = r.cols();
        this.rows = r.rows();
        this.halfCellWidth = rasterExtent.cellwidth() / 2.0;
        this.halfCellHeight = rasterExtent.cellheight() / 2.0;
        this.jtsFactory = new GeometryFactory();
        this.NOTFOUND = -1;
        this.LEFT = 0;
        this.DOWN = 1;
        this.RIGHT = 2;
        this.UP = 3;
        this.TOPLEFT = 0;
        this.BOTTOMLEFT = 1;
        this.BOTTOMRIGHT = 2;
        this.TOPRIGHT = 3;
    }
}

