/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.summary;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.Grid;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.FastMapHistogram$;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.histogram.StreamingHistogram$;
import geotrellis.raster.summary.SinglebandTileSummaryMethods;
import geotrellis.raster.summary.Statistics;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;

public abstract class SinglebandTileSummaryMethods$class {
    public static Histogram histogram(SinglebandTileSummaryMethods $this) {
        return FastMapHistogram$.MODULE$.fromTile((Tile)$this.self());
    }

    public static Histogram histogramDouble(SinglebandTileSummaryMethods $this) {
        return $this.histogramDouble(StreamingHistogram$.MODULE$.DEFAULT_NUM_BUCKETS());
    }

    public static Histogram histogramDouble(SinglebandTileSummaryMethods $this, int numBuckets) {
        return StreamingHistogram$.MODULE$.fromTile((Tile)$this.self(), numBuckets);
    }

    public static int[] classBreaks(SinglebandTileSummaryMethods $this, int numBreaks) {
        return $this.histogram().quantileBreaks$mcI$sp(numBreaks);
    }

    public static double[] classBreaksDouble(SinglebandTileSummaryMethods $this, int numBreaks) {
        return $this.histogramDouble().quantileBreaks$mcD$sp(numBreaks);
    }

    public static Option statistics(SinglebandTileSummaryMethods $this) {
        return $this.histogram().statistics();
    }

    public static Option statisticsDouble(SinglebandTileSummaryMethods $this) {
        return $this.histogramDouble().statistics();
    }

    public static Tile standardDeviations(SinglebandTileSummaryMethods $this, double factor) {
        Predef$.MODULE$.require($this.statistics().nonEmpty());
        Statistics statistics2 = (Statistics)$this.statistics().get();
        if (statistics2 != null) {
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(statistics2.mean(), statistics2.stddev());
            double mean = sp2._1$mcD$sp();
            double stddev = sp2._2$mcD$sp();
            int[] indata = ((Tile)$this.self()).toArray();
            int len = indata.length;
            int[] result = (int[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Int());
            for (int i = 0; i < len; ++i) {
                double delta = (double)indata[i] - mean;
                result[i] = (int)(delta * factor / stddev);
            }
            return ArrayTile$.MODULE$.apply(result, ((Grid)$this.self()).cols(), ((Grid)$this.self()).rows());
        }
        throw new MatchError((Object)statistics2);
    }

    public static double standardDeviations$default$1(SinglebandTileSummaryMethods $this) {
        return 1.0;
    }

    public static void $init$(SinglebandTileSummaryMethods $this) {
    }
}

