/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.sigmoidal;

import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCells;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.FloatCells;
import geotrellis.raster.IntCells;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UShortCells;
import scala.Double$;
import scala.Float$;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.Traversable;
import scala.collection.immutable.Vector$;
import scala.math.package$;

public final class SigmoidalContrast$ {
    public static final SigmoidalContrast$ MODULE$;

    static {
        new SigmoidalContrast$();
    }

    public double geotrellis$raster$sigmoidal$SigmoidalContrast$$transform(DataType cellType, double alpha, double beta, double intensity) {
        block6: {
            block11: {
                double d;
                block8: {
                    double gu;
                    int bits;
                    block10: {
                        block9: {
                            block7: {
                                double d2;
                                block3: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                bits = cellType.bits();
                                                if (!(cellType instanceof FloatCells)) break block2;
                                                d2 = (intensity - (double)Float$.MODULE$.MinValue()) / (double)(Float.MAX_VALUE - Float$.MODULE$.MinValue());
                                                break block3;
                                            }
                                            if (!(cellType instanceof DoubleCells)) break block4;
                                            d2 = (intensity / (double)2 - Double$.MODULE$.MinValue() / (double)2) / (8.988465674311579E307 - Double$.MODULE$.MinValue() / (double)2);
                                            break block3;
                                        }
                                        boolean bl = cellType instanceof BitCells ? true : (cellType instanceof UByteCells ? true : cellType instanceof UShortCells);
                                        if (!bl) break block5;
                                        d2 = intensity / (double)((1 << bits) - 1);
                                        break block3;
                                    }
                                    boolean bl = cellType instanceof ByteCells ? true : (cellType instanceof ShortCells ? true : cellType instanceof IntCells);
                                    if (!bl) break block6;
                                    d2 = (intensity + (double)(1 << bits - 1)) / (double)((1 << bits) - 1);
                                }
                                double numer = 1.0 / (1.0 + package$.MODULE$.exp(beta * (alpha - d2))) - 1.0 / (1.0 + package$.MODULE$.exp(beta));
                                double denom = 1.0 / (1.0 + package$.MODULE$.exp(beta * (alpha - 1.0))) - 1.0 / (1.0 + package$.MODULE$.exp(beta * alpha));
                                gu = package$.MODULE$.max(0.0, package$.MODULE$.min(1.0, numer / denom));
                                if (!(cellType instanceof FloatCells)) break block7;
                                d = 3.4028234663852886E38 * ((double)2 * gu - 1.0);
                                break block8;
                            }
                            if (!(cellType instanceof DoubleCells)) break block9;
                            d = Double.MAX_VALUE * ((double)2 * gu - 1.0);
                            break block8;
                        }
                        boolean bl = cellType instanceof BitCells ? true : (cellType instanceof UByteCells ? true : cellType instanceof UShortCells);
                        if (!bl) break block10;
                        d = (double)((1 << bits) - 1) * gu;
                        break block8;
                    }
                    boolean bl = cellType instanceof ByteCells ? true : (cellType instanceof ShortCells ? true : cellType instanceof IntCells);
                    if (!bl) break block11;
                    d = (double)((1 << bits) - 1) * gu - (double)(1 << bits - 1);
                }
                return d;
            }
            throw new MatchError((Object)cellType);
        }
        throw new MatchError((Object)cellType);
    }

    public Tile apply(Tile tile, double alpha, double beta) {
        DataType dataType = tile.cellType();
        Serializable localTransform = new Serializable(alpha, beta, dataType){
            public static final long serialVersionUID = 0L;
            private final double alpha$2;
            private final double beta$2;
            private final DataType eta$0$1$1;

            public final double apply(double intensity) {
                return this.apply$mcDD$sp(intensity);
            }

            public double apply$mcDD$sp(double intensity) {
                return SigmoidalContrast$.MODULE$.geotrellis$raster$sigmoidal$SigmoidalContrast$$transform(this.eta$0$1$1, this.alpha$2, this.beta$2, intensity);
            }
            {
                this.alpha$2 = alpha$2;
                this.beta$2 = beta$2;
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
        return tile.mapDouble((Function1<Object, Object>)localTransform);
    }

    public MultibandTile apply(MultibandTile tile, double alpha, double beta) {
        DataType dataType = tile.cellType();
        Serializable localTransform = new Serializable(alpha, beta, dataType){
            public static final long serialVersionUID = 0L;
            private final double alpha$1;
            private final double beta$1;
            private final DataType eta$0$2$1;

            public final double apply(double intensity) {
                return this.apply$mcDD$sp(intensity);
            }

            public double apply$mcDD$sp(double intensity) {
                return SigmoidalContrast$.MODULE$.geotrellis$raster$sigmoidal$SigmoidalContrast$$transform(this.eta$0$2$1, this.alpha$1, this.beta$1, intensity);
            }
            {
                this.alpha$1 = alpha$1;
                this.beta$1 = beta$1;
                this.eta$0$2$1 = eta$0$2$1;
            }
        };
        return MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)tile.bands().map((Function1)new Serializable((Function1)localTransform){
            public static final long serialVersionUID = 0L;
            private final Function1 localTransform$1;

            public final Tile apply(Tile x$1) {
                return x$1.mapDouble((Function1<Object, Object>)this.localTransform$1);
            }
            {
                this.localTransform$1 = localTransform$1;
            }
        }, Vector$.MODULE$.canBuildFrom())));
    }

    private SigmoidalContrast$() {
        MODULE$ = this;
    }
}

