/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.Tile;
import geotrellis.raster.resample.Resample;
import geotrellis.vector.Extent;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple4;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u0013\t\u0001\")\u001b7j]\u0016\f'OU3tC6\u0004H.\u001a\u0006\u0003\u0007\u0011\t\u0001B]3tC6\u0004H.\u001a\u0006\u0003\u000b\u0019\taA]1ti\u0016\u0014(\"A\u0004\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005!\u0011Vm]1na2,\u0007\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\tQLG.\u001a\t\u0003#Ii\u0011\u0001B\u0005\u0003'\u0011\u0011A\u0001V5mK\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0004fqR,g\u000e\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0019\taA^3di>\u0014\u0018BA\u000e\u0019\u0005\u0019)\u0005\u0010^3oi\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"2a\b\u0011\"!\tY\u0001\u0001C\u0003\u00109\u0001\u0007\u0001\u0003C\u0003\u00169\u0001\u0007a\u0003C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\u0002\tal\u0017N\\\u000b\u0002KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1Ai\\;cY\u0016Da\u0001\f\u0001!\u0002\u0013)\u0013!\u0002=nS:\u0004\u0003b\u0002\u0018\u0001\u0005\u0004%I\u0001J\u0001\u0005q6\f\u0007\u0010\u0003\u00041\u0001\u0001\u0006I!J\u0001\u0006q6\f\u0007\u0010\t\u0005\be\u0001\u0011\r\u0011\"\u0003%\u0003\u0011IX.\u001b8\t\rQ\u0002\u0001\u0015!\u0003&\u0003\u0015IX.\u001b8!\u0011\u001d1\u0004A1A\u0005\n\u0011\nA!_7bq\"1\u0001\b\u0001Q\u0001\n\u0015\nQ!_7bq\u0002BQA\u000f\u0001\u0005Bm\nQB]3tC6\u0004H.\u001a,bY&$Gc\u0001\u001f@\u0003B\u0011a%P\u0005\u0003}\u001d\u00121!\u00138u\u0011\u0015\u0001\u0015\b1\u0001&\u0003\u0005A\b\"\u0002\":\u0001\u0004)\u0013!A=\t\u000b\u0011\u0003A\u0011I#\u0002'I,7/Y7qY\u0016$u.\u001e2mKZ\u000bG.\u001b3\u0015\u0007\u00152u\tC\u0003A\u0007\u0002\u0007Q\u0005C\u0003C\u0007\u0002\u0007Q\u0005C\u0003J\u0001\u0011\u0005!*A\u000fsKN|GN^3U_BdUM\u001a;D_>\u0014Hm]!oIJ\u000bG/[8t)\rYej\u0014\t\u0007M1cD(J\u0013\n\u00055;#A\u0002+va2,G\u0007C\u0003A\u0011\u0002\u0007Q\u0005C\u0003C\u0011\u0002\u0007Q\u0005C\u0003R\u0001\u0011\u0005!+A\u0006cS2Lg.Z1s\u0013:$H#\u0002\u001fT+^K\u0006\"\u0002+Q\u0001\u0004a\u0014a\u00027fMR\u001cu\u000e\u001c\u0005\u0006-B\u0003\r\u0001P\u0001\u0007i>\u0004(k\\<\t\u000ba\u0003\u0006\u0019A\u0013\u0002\ra\u0014\u0016\r^5p\u0011\u0015Q\u0006\u000b1\u0001&\u0003\u0019I(+\u0019;j_\")A\f\u0001C\u0001;\u0006q!-\u001b7j]\u0016\f'\u000fR8vE2,G#B\u0013_?\u0002\f\u0007\"\u0002+\\\u0001\u0004a\u0004\"\u0002,\\\u0001\u0004a\u0004\"\u0002-\\\u0001\u0004)\u0003\"\u0002.\\\u0001\u0004)\u0003\"B2\u0001\t\u0013!\u0017\u0001\u00032jY&tW-\u0019:\u0015\u000b\u0015*gm\u001a5\t\u000bQ\u0013\u0007\u0019\u0001\u001f\t\u000bY\u0013\u0007\u0019\u0001\u001f\t\u000ba\u0013\u0007\u0019A\u0013\t\u000bi\u0013\u0007\u0019A\u0013")
public class BilinearResample
extends Resample {
    private final Tile tile;
    private final double xmin;
    private final double xmax;
    private final double ymin;
    private final double ymax;

    private double xmin() {
        return this.xmin;
    }

    private double xmax() {
        return this.xmax;
    }

    private double ymin() {
        return this.ymin;
    }

    private double ymax() {
        return this.ymax;
    }

    @Override
    public int resampleValid(double x, double y) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.resolveTopLeftCoordsAndRatios(x, y);
        if (tuple4 != null) {
            Tuple4 tuple42 = new Tuple4(tuple4._1(), tuple4._2(), tuple4._3(), tuple4._4());
            int leftCol = BoxesRunTime.unboxToInt((Object)tuple42._1());
            int topRow = BoxesRunTime.unboxToInt((Object)tuple42._2());
            double xRatio = BoxesRunTime.unboxToDouble((Object)tuple42._3());
            double yRatio = BoxesRunTime.unboxToDouble((Object)tuple42._4());
            return this.bilinearInt(leftCol, topRow, xRatio, yRatio);
        }
        throw new MatchError(tuple4);
    }

    @Override
    public double resampleDoubleValid(double x, double y) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.resolveTopLeftCoordsAndRatios(x, y);
        if (tuple4 != null) {
            Tuple4 tuple42 = new Tuple4(tuple4._1(), tuple4._2(), tuple4._3(), tuple4._4());
            int leftCol = BoxesRunTime.unboxToInt((Object)tuple42._1());
            int topRow = BoxesRunTime.unboxToInt((Object)tuple42._2());
            double xRatio = BoxesRunTime.unboxToDouble((Object)tuple42._3());
            double yRatio = BoxesRunTime.unboxToDouble((Object)tuple42._4());
            return this.bilinearDouble(leftCol, topRow, xRatio, yRatio);
        }
        throw new MatchError(tuple4);
    }

    public Tuple4<Object, Object, Object, Object> resolveTopLeftCoordsAndRatios(double x, double y) {
        double xRatio;
        double dleft = x - this.xmin();
        double dright = this.xmax() - x;
        double dtop = this.ymax() - y;
        double dbottom = y - this.ymin();
        int leftCol = (int)package$.MODULE$.floor(dleft / this.cellwidth());
        int topRow = (int)package$.MODULE$.floor(dtop / this.cellheight());
        double d = dleft < 0.0 ? 1.0 : (xRatio = dright < 0.0 ? 0.0 : dleft / this.cellwidth() - (double)leftCol);
        double yRatio = dtop < 0.0 ? 1.0 : (dbottom < 0.0 ? 0.0 : dtop / this.cellheight() - (double)topRow);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftCol), (Object)BoxesRunTime.boxToInteger((int)topRow), (Object)BoxesRunTime.boxToDouble((double)xRatio), (Object)BoxesRunTime.boxToDouble((double)yRatio));
    }

    public int bilinearInt(int leftCol, int topRow, double xRatio, double yRatio) {
        double v = this.bilinear(leftCol, topRow, xRatio, yRatio);
        return Double.isNaN(v) ? Integer.MIN_VALUE : (int)package$.MODULE$.round(v);
    }

    public double bilinearDouble(int leftCol, int topRow, double xRatio, double yRatio) {
        return this.bilinear(leftCol, topRow, xRatio, yRatio);
    }

    private double bilinear(int leftCol, int topRow, double xRatio, double yRatio) {
        double z;
        double z2;
        double z3;
        double z4;
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(leftCol + 1, topRow + 1);
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(sp2._1$mcI$sp(), sp2._2$mcI$sp());
        int rightCol = sp3._1$mcI$sp();
        int bottomRow = sp3._2$mcI$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(1.0 - xRatio, 1.0 - yRatio);
        Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(sp4._1$mcD$sp(), sp4._2$mcD$sp());
        double invXR = sp5._1$mcD$sp();
        double invYR = sp5._2$mcD$sp();
        double accum = 0.0;
        double accumDivisor = 0.0;
        if (leftCol >= 0 && topRow >= 0 && leftCol < this.cols() && topRow < this.rows() && !Double.isNaN(z4 = this.tile.getDouble(leftCol, topRow))) {
            double mult = invXR * invYR;
            accumDivisor = 0.0 + mult;
            accum = 0.0 + z4 * mult;
        }
        if (rightCol >= 0 && topRow >= 0 && rightCol < this.cols() && topRow < this.rows() && !Double.isNaN(z3 = this.tile.getDouble(rightCol, topRow))) {
            double mult = (1.0 - invXR) * invYR;
            accumDivisor += mult;
            accum += z3 * mult;
        }
        if (leftCol >= 0 && bottomRow >= 0 && leftCol < this.cols() && bottomRow < this.rows() && !Double.isNaN(z2 = this.tile.getDouble(leftCol, bottomRow))) {
            double mult = invXR * (1.0 - invYR);
            accumDivisor += mult;
            accum += z2 * mult;
        }
        if (rightCol >= 0 && bottomRow >= 0 && rightCol < this.cols() && bottomRow < this.rows() && !Double.isNaN(z = this.tile.getDouble(rightCol, bottomRow))) {
            double mult = (1.0 - invXR) * (1.0 - invYR);
            accumDivisor += mult;
            accum += z * mult;
        }
        return accum / accumDivisor;
    }

    public BilinearResample(Tile tile, Extent extent2) {
        this.tile = tile;
        super(tile, extent2);
        this.xmin = extent2.xmin() + this.cellwidth() / 2.0;
        this.xmax = extent2.xmax() - this.cellwidth() / 2.0;
        this.ymin = extent2.ymin() + this.cellheight() / 2.0;
        this.ymax = extent2.ymax() - this.cellheight() / 2.0;
    }
}

