/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.reproject;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellSize;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.RowTransform$;
import geotrellis.raster.reproject.SinglebandRasterReprojectMethods;
import geotrellis.raster.resample.Resample;
import geotrellis.raster.resample.Resample$;
import geotrellis.vector.Extent;
import java.util.Arrays;
import scala.Array$;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class SinglebandRasterReprojectMethods$class {
    public static Raster reproject(SinglebandRasterReprojectMethods $this, RasterExtent targetRasterExtent, Function2 transform, Function2 inverseTransform, Reproject.Options options) {
        Raster raster = (Raster)$this.self();
        if (raster != null) {
            Tuple2 tuple2 = new Tuple2(raster.tile(), (Object)raster.extent());
            Tile tile = (Tile)tuple2._1();
            Extent extent2 = (Extent)tuple2._2();
            RasterExtent rasterExtent = ((Raster)$this.self()).rasterExtent();
            if (rasterExtent != null) {
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(rasterExtent.cellwidth(), rasterExtent.cellheight());
                sp2._1$mcD$sp();
                sp2._2$mcD$sp();
                if (targetRasterExtent != null) {
                    Object object;
                    Tuple5 tuple5 = new Tuple5((Object)targetRasterExtent.extent(), (Object)BoxesRunTime.boxToDouble((double)targetRasterExtent.cellwidth()), (Object)BoxesRunTime.boxToDouble((double)targetRasterExtent.cellheight()), (Object)BoxesRunTime.boxToInteger((int)targetRasterExtent.cols()), (Object)BoxesRunTime.boxToInteger((int)targetRasterExtent.rows()));
                    Extent newExtent = (Extent)tuple5._1();
                    double newCellWidth = BoxesRunTime.unboxToDouble((Object)tuple5._2());
                    double newCellHeight = BoxesRunTime.unboxToDouble((Object)tuple5._3());
                    int newCols = BoxesRunTime.unboxToInt((Object)tuple5._4());
                    int newRows = BoxesRunTime.unboxToInt((Object)tuple5._5());
                    MutableArrayTile newTile = ArrayTile$.MODULE$.empty(tile.cellType(), newCols, newRows);
                    if (options.errorThreshold() != 0.0) {
                        double d = options.errorThreshold();
                        RowTransform$ rowTransform$ = RowTransform$.MODULE$;
                        object = d == 0.0 ? new Serializable(inverseTransform){
                            public static final long serialVersionUID = 0L;
                            private final Function2 transform$1;

                            public final void apply(double[] srcX, double[] srcY, double[] destX, double[] destY) {
                                for (int index$macro$649 = 0; index$macro$649 < srcX.length; ++index$macro$649) {
                                    Tuple2 tuple2 = (Tuple2)this.transform$1.apply((Object)BoxesRunTime.boxToDouble((double)srcX[index$macro$649]), (Object)BoxesRunTime.boxToDouble((double)srcY[index$macro$649]));
                                    if (tuple2 != null) {
                                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                                        double x = sp2._1$mcD$sp();
                                        double y = sp2._2$mcD$sp();
                                        destX[index$macro$649] = x;
                                        destY[index$macro$649] = y;
                                        continue;
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                            }
                            {
                                this.transform$1 = transform$1;
                            }
                        } : new Serializable(inverseTransform, d){
                            public static final long serialVersionUID = 0L;
                            private final Function2 transform$2;
                            private final double errorThreshold$1;

                            public final void apply(double[] srcX, double[] srcY, double[] destX, double[] destY) {
                                int len = srcX.length;
                                Tuple2 tuple2 = (Tuple2)this.transform$2.apply((Object)BoxesRunTime.boxToDouble((double)srcX[0]), (Object)BoxesRunTime.boxToDouble((double)srcY[0]));
                                if (tuple2 != null) {
                                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                                    double xmin = sp2._1$mcD$sp();
                                    double ymin = sp2._2$mcD$sp();
                                    Tuple2 tuple22 = (Tuple2)this.transform$2.apply((Object)BoxesRunTime.boxToDouble((double)srcX[len - 1]), (Object)BoxesRunTime.boxToDouble((double)srcY[len - 1]));
                                    if (tuple22 != null) {
                                        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(tuple22._1$mcD$sp(), tuple22._2$mcD$sp());
                                        double xmax = sp3._1$mcD$sp();
                                        double ymax = sp3._2$mcD$sp();
                                        destX[0] = xmin;
                                        destY[0] = ymin;
                                        destX[len - 1] = xmax;
                                        destY[len - 1] = ymax;
                                        RowTransform$.MODULE$.geotrellis$raster$reproject$RowTransform$$computeApprox((Function2<Object, Object, Tuple2<Object, Object>>)this.transform$2, this.errorThreshold$1, srcX, srcY, destX, destY, 0, len);
                                        return;
                                    }
                                    throw new MatchError((Object)tuple22);
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            {
                                this.transform$2 = transform$2;
                                this.errorThreshold$1 = errorThreshold$1;
                            }
                        };
                    } else {
                        RowTransform$ rowTransform$ = RowTransform$.MODULE$;
                        object = new /* invalid duplicate definition of identical inner class */;
                    }
                    Serializable rowTransform = object;
                    Tuple2<Object, Object> tuple22 = targetRasterExtent.gridToMap(0, 0);
                    if (tuple22 != null) {
                        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(tuple22._1$mcD$sp(), tuple22._2$mcD$sp());
                        double topLeftX = sp3._1$mcD$sp();
                        double topLeftY = sp3._2$mcD$sp();
                        double[] destX = (double[])Array$.MODULE$.ofDim(newCols, ClassTag$.MODULE$.Double());
                        double currX = topLeftX;
                        for (int index$macro$651 = 0; index$macro$651 < newCols; ++index$macro$651) {
                            destX[index$macro$651] = currX;
                            currX += newCellWidth;
                        }
                        double[] dArray = (double[])Array$.MODULE$.ofDim(newCols, ClassTag$.MODULE$.Double());
                        package$ package$2 = package$.MODULE$;
                        package$DoubleArrayFiller$ package$DoubleArrayFiller$2 = package$DoubleArrayFiller$.MODULE$;
                        Arrays.fill(dArray, topLeftY);
                        double[] srcX = (double[])Array$.MODULE$.ofDim(newCols, ClassTag$.MODULE$.Double());
                        double[] srcY = (double[])Array$.MODULE$.ofDim(newCols, ClassTag$.MODULE$.Double());
                        Resample resampler = Resample$.MODULE$.apply(options.method(), tile, extent2, new CellSize(newCellWidth, newCellHeight));
                        if (tile.cellType().isFloatingPoint()) {
                            Serializable resample = new Serializable($this, resampler){
                                public static final long serialVersionUID = 0L;
                                public final Resample resampler$1;

                                public final double apply(double x, double y) {
                                    return this.resampler$1.resampleDouble(x, y);
                                }

                                public double apply$mcDDD$sp(double x, double y) {
                                    return this.resampler$1.resampleDouble(x, y);
                                }
                                {
                                    this.resampler$1 = resampler$1;
                                }
                            };
                            for (int index$macro$653 = 0; index$macro$653 < newRows; ++index$macro$653) {
                                rowTransform.apply((Object)destX, (Object)dArray, (Object)srcX, (Object)srcY);
                                for (int index$macro$652 = 0; index$macro$652 < newCols; ++index$macro$652) {
                                    double d = srcY[index$macro$652];
                                    double d2 = srcX[index$macro$652];
                                    double v = resample.resampler$1.resampleDouble(d2, d);
                                    newTile.setDouble(index$macro$652, index$macro$653, v);
                                    dArray[index$macro$652] = dArray[index$macro$652] - newCellHeight;
                                }
                            }
                        } else {
                            Serializable resample = new Serializable($this, resampler){
                                public static final long serialVersionUID = 0L;
                                public final Resample resampler$1;

                                public final int apply(double x, double y) {
                                    return this.resampler$1.resample(x, y);
                                }

                                public int apply$mcIDD$sp(double x, double y) {
                                    return this.resampler$1.resample(x, y);
                                }
                                {
                                    this.resampler$1 = resampler$1;
                                }
                            };
                            for (int index$macro$655 = 0; index$macro$655 < newRows; ++index$macro$655) {
                                rowTransform.apply((Object)destX, (Object)dArray, (Object)srcX, (Object)srcY);
                                for (int index$macro$654 = 0; index$macro$654 < newCols; ++index$macro$654) {
                                    double x = srcX[index$macro$654];
                                    double y = srcY[index$macro$654];
                                    int v = resample.resampler$1.resample(x, y);
                                    newTile.set(index$macro$654, index$macro$655, v);
                                    dArray[index$macro$654] = dArray[index$macro$654] - newCellHeight;
                                }
                            }
                        }
                        return new Raster<MutableArrayTile>(newTile, newExtent);
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError((Object)targetRasterExtent);
            }
            throw new MatchError((Object)rasterExtent);
        }
        throw new MatchError((Object)raster);
    }

    public static void $init$(SinglebandRasterReprojectMethods $this) {
    }
}

