/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.reproject;

import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RowTransform$ {
    public static final RowTransform$ MODULE$;

    static {
        new RowTransform$();
    }

    public Function4<double[], double[], double[], double[], BoxedUnit> exact(Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return new Serializable(transform){
            public static final long serialVersionUID = 0L;
            private final Function2 transform$1;

            public final void apply(double[] srcX, double[] srcY, double[] destX, double[] destY) {
                for (int index$macro$649 = 0; index$macro$649 < srcX.length; ++index$macro$649) {
                    Tuple2 tuple2 = (Tuple2)this.transform$1.apply((Object)BoxesRunTime.boxToDouble((double)srcX[index$macro$649]), (Object)BoxesRunTime.boxToDouble((double)srcY[index$macro$649]));
                    if (tuple2 != null) {
                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                        double x = sp2._1$mcD$sp();
                        double y = sp2._2$mcD$sp();
                        destX[index$macro$649] = x;
                        destY[index$macro$649] = y;
                        continue;
                    }
                    throw new MatchError((Object)tuple2);
                }
            }
            {
                this.transform$1 = transform$1;
            }
        };
    }

    public Function4<double[], double[], double[], double[], BoxedUnit> approximate(Function2<Object, Object, Tuple2<Object, Object>> transform, double errorThreshold) {
        return errorThreshold == 0.0 ? new /* invalid duplicate definition of identical inner class */ : new Serializable(transform, errorThreshold){
            public static final long serialVersionUID = 0L;
            private final Function2 transform$2;
            private final double errorThreshold$1;

            public final void apply(double[] srcX, double[] srcY, double[] destX, double[] destY) {
                int len = srcX.length;
                Tuple2 tuple2 = (Tuple2)this.transform$2.apply((Object)BoxesRunTime.boxToDouble((double)srcX[0]), (Object)BoxesRunTime.boxToDouble((double)srcY[0]));
                if (tuple2 != null) {
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                    double xmin = sp2._1$mcD$sp();
                    double ymin = sp2._2$mcD$sp();
                    Tuple2 tuple22 = (Tuple2)this.transform$2.apply((Object)BoxesRunTime.boxToDouble((double)srcX[len - 1]), (Object)BoxesRunTime.boxToDouble((double)srcY[len - 1]));
                    if (tuple22 != null) {
                        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(tuple22._1$mcD$sp(), tuple22._2$mcD$sp());
                        double xmax = sp3._1$mcD$sp();
                        double ymax = sp3._2$mcD$sp();
                        destX[0] = xmin;
                        destY[0] = ymin;
                        destX[len - 1] = xmax;
                        destY[len - 1] = ymax;
                        RowTransform$.MODULE$.geotrellis$raster$reproject$RowTransform$$computeApprox((Function2<Object, Object, Tuple2<Object, Object>>)this.transform$2, this.errorThreshold$1, srcX, srcY, destX, destY, 0, len);
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.transform$2 = transform$2;
                this.errorThreshold$1 = errorThreshold$1;
            }
        };
    }

    public void geotrellis$raster$reproject$RowTransform$$computeApprox(Function2<Object, Object, Tuple2<Object, Object>> transform, double errorThreshold, double[] srcX, double[] srcY, double[] destX, double[] destY, int startIndex, int length) {
        Tuple2 tuple2;
        block3: {
            block5: {
                BoxedUnit boxedUnit;
                block4: {
                    double deltaY;
                    double deltaX;
                    double ymin;
                    double xmin;
                    double srcXMin;
                    int midPoint;
                    while (true) {
                        if (length == 2) {
                            return;
                        }
                        midPoint = startIndex + (length - 1) / 2;
                        tuple2 = (Tuple2)transform.apply((Object)BoxesRunTime.boxToDouble((double)srcX[midPoint]), (Object)BoxesRunTime.boxToDouble((double)srcY[midPoint]));
                        if (tuple2 == null) break block3;
                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                        double xmid = sp2._1$mcD$sp();
                        double ymid = sp2._2$mcD$sp();
                        destX[midPoint] = xmid;
                        destY[midPoint] = ymid;
                        if (length == 3) break block4;
                        double srcXMax = srcX[startIndex + length - 1];
                        srcXMin = srcX[startIndex];
                        double xmax = destX[startIndex + length - 1];
                        xmin = destX[startIndex];
                        double ymax = destY[startIndex + length - 1];
                        ymin = destY[startIndex];
                        double dx = srcXMax - srcXMin;
                        deltaX = (xmax - xmin) / dx;
                        deltaY = (ymax - ymin) / dx;
                        double dxmid = srcX[midPoint] - srcXMin;
                        double error = package$.MODULE$.abs(xmin + deltaX * dxmid - xmid) + package$.MODULE$.abs(ymin + deltaY * dxmid - ymid);
                        if (!(error > errorThreshold)) break;
                        this.geotrellis$raster$reproject$RowTransform$$computeApprox(transform, errorThreshold, srcX, srcY, destX, destY, startIndex, midPoint - startIndex + 1);
                        length = startIndex + length - midPoint;
                        startIndex = midPoint;
                    }
                    for (int index$macro$650 = startIndex + 1; index$macro$650 < startIndex + length - 1; ++index$macro$650) {
                        if (index$macro$650 == midPoint) continue;
                        double dxi = srcX[index$macro$650] - srcXMin;
                        destX[index$macro$650] = xmin + deltaX * dxi;
                        destY[index$macro$650] = ymin + deltaY * dxi;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private RowTransform$() {
        MODULE$ = this;
    }
}

