/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.reproject;

import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Polygon;
import geotrellis.proj4.CRS;
import geotrellis.proj4.Transform$;
import geotrellis.raster.CellSize;
import geotrellis.raster.GridExtent;
import geotrellis.raster.GridExtent$;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.Reproject$Options$;
import geotrellis.vector.Extent;
import geotrellis.vector.Geometry;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ReprojectRasterExtent$ {
    public static final ReprojectRasterExtent$ MODULE$;

    static {
        new ReprojectRasterExtent$();
    }

    public Extent reprojectExtent(GridExtent ge, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        Extent extent2 = ge.extent();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(extent2.width() / ge.cellwidth(), extent2.height() / ge.cellheight());
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(sp2._1$mcD$sp(), sp2._2$mcD$sp());
        double cols = sp3._1$mcD$sp();
        double rows = sp3._2$mcD$sp();
        int PIXEL_STEP = (int)package$.MODULE$.min(50.0, package$.MODULE$.min(cols, rows));
        double xThreshold = cols / (double)PIXEL_STEP * ge.cellwidth();
        double yThreshold = rows / (double)PIXEL_STEP * ge.cellheight();
        double threshold = package$.MODULE$.min(xThreshold, yThreshold);
        geotrellis.vector.Polygon denseGeom = new geotrellis.vector.Polygon((Polygon)Densifier.densify((com.vividsolutions.jts.geom.Geometry)extent2.toPolygon().jtsGeom(), (double)threshold));
        return geotrellis.vector.package$.MODULE$.ReprojectPolygon(denseGeom).reproject(transform).envelope();
    }

    public GridExtent apply(GridExtent ge, Function2<Object, Object, Tuple2<Object, Object>> transform, Reproject.Options options) {
        Tuple2 tuple2;
        block2: {
            Tuple2 tuple22;
            block3: {
                Option<GridExtent> option;
                block6: {
                    Option<CellSize> option2;
                    block9: {
                        GridExtent gridExtent;
                        block5: {
                            Tuple2.mcDD.sp sp2;
                            Extent newExtent;
                            block8: {
                                double transformedYmin;
                                double transformedXmax;
                                double transformedYmax;
                                double transformedXmin;
                                block7: {
                                    block4: {
                                        Extent extent2 = ge.extent();
                                        newExtent = this.reprojectExtent(ge, transform);
                                        tuple2 = (Tuple2)transform.apply((Object)BoxesRunTime.boxToDouble((double)extent2.xmin()), (Object)BoxesRunTime.boxToDouble((double)extent2.ymax()));
                                        if (tuple2 == null) break block2;
                                        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                                        transformedXmin = sp3._1$mcD$sp();
                                        transformedYmax = sp3._2$mcD$sp();
                                        tuple22 = (Tuple2)transform.apply((Object)BoxesRunTime.boxToDouble((double)extent2.xmax()), (Object)BoxesRunTime.boxToDouble((double)extent2.ymin()));
                                        if (tuple22 == null) break block3;
                                        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(tuple22._1$mcD$sp(), tuple22._2$mcD$sp());
                                        transformedXmax = sp4._1$mcD$sp();
                                        transformedYmin = sp4._2$mcD$sp();
                                        option = options.parentGridExtent();
                                        if (!(option instanceof Some)) break block4;
                                        Some some = (Some)option;
                                        gridExtent = ((GridExtent)some.x()).createAlignedGridExtent(new Extent(transformedXmin, transformedYmin, transformedXmax, transformedYmax));
                                        break block5;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block6;
                                    option2 = options.targetCellSize();
                                    if (!(option2 instanceof Some)) break block7;
                                    Some some = (Some)option2;
                                    sp2 = new Tuple2.mcDD.sp(((CellSize)some.x()).width(), ((CellSize)some.x()).height());
                                    break block8;
                                }
                                if (!None$.MODULE$.equals(option2)) break block9;
                                double distance = geotrellis.vector.package$.MODULE$.tupleOfIntToPoint((Tuple2)new Tuple2.mcDD.sp(transformedXmin, transformedYmax)).distance((Geometry)geotrellis.vector.package$.MODULE$.tupleOfIntToPoint((Tuple2)new Tuple2.mcDD.sp(transformedXmax, transformedYmin)));
                                double cols = ge.extent().width() / ge.cellwidth();
                                double rows = ge.extent().height() / ge.cellheight();
                                double pixelSize = distance / package$.MODULE$.sqrt(cols * cols + rows * rows);
                                sp2 = new Tuple2.mcDD.sp(pixelSize, pixelSize);
                            }
                            Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(sp2._1$mcD$sp(), sp2._2$mcD$sp());
                            double pixelSizeX = sp5._1$mcD$sp();
                            double pixelSizeY = sp5._2$mcD$sp();
                            double newColsDouble = newExtent.width() / pixelSizeX;
                            double newRowsDouble = newExtent.height() / pixelSizeY;
                            int newCols = (int)(newColsDouble + 0.5);
                            int newRows = (int)(newRowsDouble + 0.5);
                            Extent adjustedExtent = new Extent(newExtent.xmin(), newExtent.ymax() - pixelSizeY * (double)newRows, newExtent.xmin() + pixelSizeX * (double)newCols, newExtent.ymax());
                            gridExtent = GridExtent$.MODULE$.apply(adjustedExtent, pixelSizeX, pixelSizeY);
                        }
                        return gridExtent;
                    }
                    throw new MatchError(option2);
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    public GridExtent apply(GridExtent ge, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return this.apply(ge, transform, Reproject$Options$.MODULE$.DEFAULT());
    }

    public GridExtent apply(GridExtent ge, CRS src, CRS dest, Reproject.Options options) {
        CRS cRS = src;
        return !(cRS != null ? !cRS.equals(dest) : dest != null) ? ge : this.apply(ge, (Function2<Object, Object, Tuple2<Object, Object>>)Transform$.MODULE$.apply(src, dest), options);
    }

    public GridExtent apply(GridExtent ge, CRS src, CRS dest) {
        return this.apply(ge, src, dest, Reproject$Options$.MODULE$.DEFAULT());
    }

    public RasterExtent apply(RasterExtent re, Function2<Object, Object, Tuple2<Object, Object>> transform, Reproject.Options options) {
        return this.apply((GridExtent)re, transform, options).toRasterExtent();
    }

    public RasterExtent apply(RasterExtent re, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        Reproject.Options options = Reproject$Options$.MODULE$.DEFAULT();
        return this.apply((GridExtent)re, transform, options).toRasterExtent();
    }

    public RasterExtent apply(RasterExtent re, CRS src, CRS dest, Reproject.Options options) {
        RasterExtent rasterExtent;
        CRS cRS = src;
        if (!(cRS != null ? !cRS.equals(dest) : dest != null)) {
            rasterExtent = re;
        } else {
            Function2 function2 = Transform$.MODULE$.apply(src, dest);
            rasterExtent = this.apply((GridExtent)re, (Function2<Object, Object, Tuple2<Object, Object>>)function2, options).toRasterExtent();
        }
        return rasterExtent;
    }

    public RasterExtent apply(RasterExtent re, CRS src, CRS dest) {
        return this.apply(re, src, dest, Reproject$Options$.MODULE$.DEFAULT());
    }

    private ReprojectRasterExtent$() {
        MODULE$ = this;
    }
}

