/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.reproject;

import geotrellis.proj4.CRS;
import geotrellis.proj4.Transform$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridExtent;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.reproject.RasterReprojectMethods;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.Reproject$Options$;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.vector.Extent;
import scala.Function2;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;

public abstract class RasterReprojectMethods$class {
    public static Raster reproject(RasterReprojectMethods $this, RasterExtent targetRasterExtent, Function2 transform, Function2 inverseTransform) {
        return $this.reproject(targetRasterExtent, (Function2<Object, Object, Tuple2<Object, Object>>)transform, (Function2<Object, Object, Tuple2<Object, Object>>)inverseTransform, Reproject$Options$.MODULE$.DEFAULT());
    }

    public static Raster reproject(RasterReprojectMethods $this, CRS src, CRS dest, Reproject.Options options) {
        Raster raster;
        CRS cRS = src;
        if (!(cRS != null ? !cRS.equals(dest) : dest != null)) {
            raster = (Raster)$this.self();
        } else {
            Function2 transform = Transform$.MODULE$.apply(src, dest);
            Function2 inverseTransform = Transform$.MODULE$.apply(dest, src);
            Option<RasterExtent> option = options.targetRasterExtent();
            RasterExtent targetRasterExtent = (RasterExtent)(!option.isEmpty() ? option.get() : ReprojectRasterExtent$.MODULE$.apply((GridExtent)((Raster)$this.self()).rasterExtent(), (Function2<Object, Object, Tuple2<Object, Object>>)transform, options).toRasterExtent());
            raster = $this.reproject(targetRasterExtent, (Function2<Object, Object, Tuple2<Object, Object>>)transform, (Function2<Object, Object, Tuple2<Object, Object>>)inverseTransform, options);
        }
        return raster;
    }

    public static Raster reproject(RasterReprojectMethods $this, CRS src, CRS dest) {
        return $this.reproject(src, dest, Reproject$Options$.MODULE$.DEFAULT());
    }

    public static Raster reproject(RasterReprojectMethods $this, GridBounds gridBounds, CRS src, CRS dest, Reproject.Options options) {
        Function2 transform = Transform$.MODULE$.apply(src, dest);
        Function2 inverseTransform = Transform$.MODULE$.apply(dest, src);
        return $this.reproject(gridBounds, (Function2<Object, Object, Tuple2<Object, Object>>)transform, (Function2<Object, Object, Tuple2<Object, Object>>)inverseTransform, options);
    }

    public static Raster reproject(RasterReprojectMethods $this, GridBounds gridBounds, CRS src, CRS dest) {
        return $this.reproject(gridBounds, src, dest, Reproject$Options$.MODULE$.DEFAULT());
    }

    public static Raster reproject(RasterReprojectMethods $this, GridBounds gridBounds, Function2 transform, Function2 inverseTransform, Reproject.Options options) {
        RasterExtent rasterExtent = ((Raster)$this.self()).rasterExtent();
        Extent windowExtent = rasterExtent.extentFor(gridBounds, rasterExtent.extentFor$default$2());
        RasterExtent windowRasterExtent = RasterExtent$.MODULE$.apply(windowExtent, gridBounds.width(), gridBounds.height());
        Serializable serializable = new Serializable($this, windowRasterExtent, transform, options){
            public static final long serialVersionUID = 0L;
            public final RasterExtent windowRasterExtent$1;
            public final Function2 transform$2;
            public final Reproject.Options options$2;

            public final RasterExtent apply() {
                return ReprojectRasterExtent$.MODULE$.apply(this.windowRasterExtent$1, (Function2<Object, Object, Tuple2<Object, Object>>)this.transform$2, this.options$2);
            }
            {
                void var4_4;
                void var3_3;
                this.windowRasterExtent$1 = windowRasterExtent$1;
                this.transform$2 = var3_3;
                this.options$2 = var4_4;
            }
        };
        Option<RasterExtent> option = options.targetRasterExtent();
        RasterExtent targetRasterExtent = (RasterExtent)(!option.isEmpty() ? option.get() : ReprojectRasterExtent$.MODULE$.apply((GridExtent)serializable.windowRasterExtent$1, (Function2<Object, Object, Tuple2<Object, Object>>)serializable.transform$2, serializable.options$2).toRasterExtent());
        return $this.reproject(targetRasterExtent, (Function2<Object, Object, Tuple2<Object, Object>>)transform, (Function2<Object, Object, Tuple2<Object, Object>>)inverseTransform, options);
    }

    public static Raster reproject(RasterReprojectMethods $this, GridBounds gridBounds, Function2 transform, Function2 inverseTransform) {
        return $this.reproject(gridBounds, (Function2<Object, Object, Tuple2<Object, Object>>)transform, (Function2<Object, Object, Tuple2<Object, Object>>)inverseTransform, Reproject$Options$.MODULE$.DEFAULT());
    }

    public static void $init$(RasterReprojectMethods $this) {
    }
}

