/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.render.png;

import geotrellis.raster.Tile;
import geotrellis.raster.render.png.Chunk;
import geotrellis.raster.render.png.Filter;
import geotrellis.raster.render.png.GreyPngEncoding;
import geotrellis.raster.render.png.IndexedPngEncoding;
import geotrellis.raster.render.png.NoFilter$;
import geotrellis.raster.render.png.PaethFilter$;
import geotrellis.raster.render.png.PngColorEncoding;
import geotrellis.raster.render.png.PngEncoder$;
import geotrellis.raster.render.png.RgbPngEncoding;
import geotrellis.raster.render.png.Settings;
import geotrellis.raster.render.png.Util$;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0001\u0003\u0001.\u0011!\u0002\u00158h\u000b:\u001cw\u000eZ3s\u0015\t\u0019A!A\u0002q]\u001eT!!\u0002\u0004\u0002\rI,g\u000eZ3s\u0015\t9\u0001\"\u0001\u0004sCN$XM\u001d\u0006\u0002\u0013\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M!\u0001\u0001\u0004\n\u0016!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u0011QbE\u0005\u0003)9\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u000e-%\u0011qC\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t3\u0001\u0011)\u001a!C\u00015\u0005A1/\u001a;uS:<7/F\u0001\u001c!\taR$D\u0001\u0003\u0013\tq\"A\u0001\u0005TKR$\u0018N\\4t\u0011!\u0001\u0003A!E!\u0002\u0013Y\u0012!C:fiRLgnZ:!\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011A%\n\t\u00039\u0001AQ!G\u0011A\u0002mAqa\n\u0001C\u0002\u0013\u0015\u0001&A\u0005T\u0013\u001es\u0015\tV+S\u000bV\t\u0011\u0006E\u0002\u000eU1J!a\u000b\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00055i\u0013B\u0001\u0018\u000f\u0005\u0011\u0011\u0015\u0010^3\t\rA\u0002\u0001\u0015!\u0004*\u0003)\u0019\u0016j\u0012(B)V\u0013V\t\t\u0005\be\u0001\u0011\r\u0011\"\u00024\u0003\u0011I\u0005\n\u0012*\u0016\u0003Q\u0002\"!D\u001b\n\u0005Yr!aA%oi\"1\u0001\b\u0001Q\u0001\u000eQ\nQ!\u0013%E%\u0002BqA\u000f\u0001C\u0002\u0013\u00151'\u0001\u0003C\u0017\u001e#\u0005B\u0002\u001f\u0001A\u00035A'A\u0003C\u0017\u001e#\u0005\u0005C\u0004?\u0001\t\u0007IQA\u001a\u0002\tAcE+\u0012\u0005\u0007\u0001\u0002\u0001\u000bQ\u0002\u001b\u0002\u000bAcE+\u0012\u0011\t\u000f\t\u0003!\u0019!C\u0003g\u0005!AK\u0015(T\u0011\u0019!\u0005\u0001)A\u0007i\u0005)AK\u0015(TA!9a\t\u0001b\u0001\n\u000b\u0019\u0014\u0001B%E\u0003RCa\u0001\u0013\u0001!\u0002\u001b!\u0014!B%E\u0003R\u0003\u0003b\u0002&\u0001\u0005\u0004%)aM\u0001\u0005\u0013\u0016sE\t\u0003\u0004M\u0001\u0001\u0006i\u0001N\u0001\u0006\u0013\u0016sE\t\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0002P\u0003\u00191\u0015\n\u0014+F%V\tA\u0006\u0003\u0004R\u0001\u0001\u0006i\u0001L\u0001\b\r&cE+\u0012*!\u0011\u001d\u0019\u0006A1A\u0005\u0006M\nQ\u0001R#Q)\"Ca!\u0016\u0001!\u0002\u001b!\u0014A\u0002#F!RC\u0005\u0005C\u0004X\u0001\t\u0007IQA\u001a\u0002\u000bMC\u0015J\u0012+\t\re\u0003\u0001\u0015!\u00045\u0003\u0019\u0019\u0006*\u0013$UA!)1\f\u0001C\u00019\u0006YqO]5uK\"+\u0017\rZ3s)\ri\u0006M\u001b\t\u0003\u001byK!a\u0018\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Cj\u0003\rAY\u0001\u0004I>\u001c\bCA2i\u001b\u0005!'BA3g\u0003\tIwNC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%$'\u0001\u0005#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0011\u00159!\f1\u0001l!\taW.D\u0001\u0007\u0013\tqgA\u0001\u0003US2,\u0007\"\u00029\u0001\t\u0003\t\u0018aE<sSR,')Y2lOJ|WO\u001c3J]\u001a|GCA/s\u0011\u0015\tw\u000e1\u0001c\u0011\u0015!\b\u0001\"\u0001v\u0003A\u0019'/Z1uK\nKH/\u001a\"vM\u001a,'\u000f\u0006\u0002wyB\u0011qO_\u0007\u0002q*\u0011\u0011PZ\u0001\u0004]&|\u0017BA>y\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006\u000fM\u0004\ra\u001b\u0005\u0006}\u0002!\ta`\u0001\u000foJLG/\u001a)jq\u0016dG)\u0019;b)\u0015i\u0016\u0011AA\u0002\u0011\u0015\tW\u00101\u0001c\u0011\u00159Q\u00101\u0001l\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tac\u001e:ji\u0016\u0004\u0016\u000e_3m\t\u0006$\u0018MT8GS2$XM\u001d\u000b\u0006;\u0006-\u0011Q\u0002\u0005\u0007C\u0006\u0015\u0001\u0019\u00012\t\r\u001d\t)\u00011\u0001l\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\t1c\u001e:ji\u0016\u0004\u0016\u000e_3m\t\u0006$\u0018\rU1fi\"$R!XA\u000b\u0003/Aa!YA\b\u0001\u0004\u0011\u0007BB\u0004\u0002\u0010\u0001\u00071\u000eC\u0004\u0002\u001c\u0001!\t!!\b\u0002\u0011]\u0014\u0018\u000e^3F]\u0012$2!XA\u0010\u0011\u0019\t\u0017\u0011\u0004a\u0001E\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012!E<sSR,w*\u001e;qkR\u001cFO]3b[R)Q,a\n\u00022!A\u0011\u0011FA\u0011\u0001\u0004\tY#\u0001\u0002pgB\u00191-!\f\n\u0007\u0005=BM\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004\b\u0003C\u0001\ra\u001b\u0005\b\u0003k\u0001A\u0011AA\u001c\u000399(/\u001b;f\u0005f$X-\u0011:sCf$2!KA\u001d\u0011\u00199\u00111\u0007a\u0001W\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012!C<sSR,\u0007+\u0019;i)\u0015i\u0016\u0011IA*\u0011!\t\u0019%a\u000fA\u0002\u0005\u0015\u0013\u0001\u00029bi\"\u0004B!a\u0012\u0002N9\u0019Q\"!\u0013\n\u0007\u0005-c\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017r\u0001BB\u0004\u0002<\u0001\u00071\u000eC\u0005\u0002X\u0001\t\t\u0011\"\u0001\u0002Z\u0005!1m\u001c9z)\r!\u00131\f\u0005\t3\u0005U\u0003\u0013!a\u00017!I\u0011q\f\u0001\u0012\u0002\u0013\u0005\u0011\u0011M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019GK\u0002\u001c\u0003KZ#!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003cr\u0011AC1o]>$\u0018\r^5p]&!\u0011QOA6\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003s\u0002\u0011\u0011!C!\u0003w\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAABM\u0006!A.\u00198h\u0013\u0011\ty%!!\t\u0011\u0005%\u0005!!A\u0005\u0002M\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"!$\u0001\u0003\u0003%\t!a$\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011SAL!\ri\u00111S\u0005\u0004\u0003+s!aA!os\"I\u0011\u0011TAF\u0003\u0003\u0005\r\u0001N\u0001\u0004q\u0012\n\u0004\"CAO\u0001\u0005\u0005I\u0011IAP\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAQ!\u0019\t\u0019+!+\u0002\u00126\u0011\u0011Q\u0015\u0006\u0004\u0003Os\u0011AC2pY2,7\r^5p]&!\u00111VAS\u0005!IE/\u001a:bi>\u0014\b\"CAX\u0001\u0005\u0005I\u0011AAY\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAZ\u0003s\u00032!DA[\u0013\r\t9L\u0004\u0002\b\u0005>|G.Z1o\u0011)\tI*!,\u0002\u0002\u0003\u0007\u0011\u0011\u0013\u0005\n\u0003{\u0003\u0011\u0011!C!\u0003\u007f\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002i!I\u00111\u0019\u0001\u0002\u0002\u0013\u0005\u0013QY\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u0010\u0005\n\u0003\u0013\u0004\u0011\u0011!C!\u0003\u0017\fa!Z9vC2\u001cH\u0003BAZ\u0003\u001bD!\"!'\u0002H\u0006\u0005\t\u0019AAI\u000f%\t\tNAA\u0001\u0012\u0003\t\u0019.\u0001\u0006Q]\u001e,enY8eKJ\u00042\u0001HAk\r!\t!!!A\t\u0002\u0005]7#BAk\u00033,\u0002CBAn\u0003C\\B%\u0004\u0002\u0002^*\u0019\u0011q\u001c\b\u0002\u000fI,h\u000e^5nK&!\u00111]Ao\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0005\bE\u0005UG\u0011AAt)\t\t\u0019\u000e\u0003\u0006\u0002D\u0006U\u0017\u0011!C#\u0003\u000bD!\"!<\u0002V\u0006\u0005I\u0011QAx\u0003\u0015\t\u0007\u000f\u001d7z)\r!\u0013\u0011\u001f\u0005\u00073\u0005-\b\u0019A\u000e\t\u0015\u0005U\u0018Q[A\u0001\n\u0003\u000b90A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0018q \t\u0005\u001b\u0005m8$C\u0002\u0002~:\u0011aa\u00149uS>t\u0007\"\u0003B\u0001\u0003g\f\t\u00111\u0001%\u0003\rAH\u0005\r\u0005\u000b\u0005\u000b\t).!A\u0005\n\t\u001d\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0003\u0011\t\u0005}$1B\u0005\u0005\u0005\u001b\t\tI\u0001\u0004PE*,7\r\u001e")
public class PngEncoder
implements Product,
Serializable {
    private final Settings settings;
    private final byte[] SIGNATURE;
    private final int IHDR;
    private final int BKGD;
    private final int PLTE;
    private final int TRNS;
    private final int IDAT;
    private final int IEND;
    private final byte FILTER;
    private final int DEPTH;
    private final int SHIFT;

    public static Option<Settings> unapply(PngEncoder pngEncoder) {
        return PngEncoder$.MODULE$.unapply(pngEncoder);
    }

    public static PngEncoder apply(Settings settings) {
        return PngEncoder$.MODULE$.apply(settings);
    }

    public static <A> Function1<Settings, A> andThen(Function1<PngEncoder, A> function1) {
        return PngEncoder$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PngEncoder> compose(Function1<A, Settings> function1) {
        return PngEncoder$.MODULE$.compose(function1);
    }

    public Settings settings() {
        return this.settings;
    }

    public final byte[] SIGNATURE() {
        return this.SIGNATURE;
    }

    public final int IHDR() {
        return this.IHDR;
    }

    public final int BKGD() {
        return this.BKGD;
    }

    public final int PLTE() {
        return this.PLTE;
    }

    public final int TRNS() {
        return this.TRNS;
    }

    public final int IDAT() {
        return this.IDAT;
    }

    public final int IEND() {
        return this.IEND;
    }

    public final byte FILTER() {
        return this.FILTER;
    }

    public final int DEPTH() {
        return this.DEPTH;
    }

    public final int SHIFT() {
        return this.SHIFT;
    }

    public void writeHeader(DataOutputStream dos, Tile raster) {
        int width = raster.cols();
        int height = raster.rows();
        dos.write(this.SIGNATURE());
        Chunk cIHDR = new Chunk(this.IHDR());
        cIHDR.writeInt(width);
        cIHDR.writeInt(height);
        cIHDR.writeByte((byte)8);
        cIHDR.writeByte(this.settings().colorType().n());
        cIHDR.writeByte((byte)0);
        cIHDR.writeByte((byte)0);
        cIHDR.writeByte((byte)0);
        cIHDR.writeTo(dos);
    }

    public void writeBackgroundInfo(DataOutputStream dos) {
        block1: {
            PngColorEncoding pngColorEncoding;
            block2: {
                RgbPngEncoding rgbPngEncoding;
                block0: {
                    GreyPngEncoding greyPngEncoding;
                    pngColorEncoding = this.settings().colorType();
                    if (!(pngColorEncoding instanceof GreyPngEncoding) || !((greyPngEncoding = (GreyPngEncoding)pngColorEncoding).transparent() instanceof Some)) break block0;
                    Some some = (Some)greyPngEncoding.transparent();
                    Chunk cTRNS = new Chunk(this.TRNS());
                    cTRNS.writeByte((byte)0);
                    int n = BoxesRunTime.unboxToInt((Object)some.x()) >> 8;
                    Util$ util$ = Util$.MODULE$;
                    cTRNS.writeByte((byte)n);
                    cTRNS.writeTo(dos);
                    break block1;
                }
                if (!(pngColorEncoding instanceof RgbPngEncoding) || !((rgbPngEncoding = (RgbPngEncoding)pngColorEncoding).transparent() instanceof Some)) break block2;
                Some some = (Some)rgbPngEncoding.transparent();
                Chunk cTRNS = new Chunk(this.TRNS());
                cTRNS.writeByte((byte)0);
                int n = BoxesRunTime.unboxToInt((Object)some.x()) >> 24;
                Util$ util$ = Util$.MODULE$;
                cTRNS.writeByte((byte)n);
                cTRNS.writeByte((byte)0);
                int n2 = BoxesRunTime.unboxToInt((Object)some.x()) >> 16;
                Util$ util$2 = Util$.MODULE$;
                cTRNS.writeByte((byte)n2);
                cTRNS.writeByte((byte)0);
                int n3 = BoxesRunTime.unboxToInt((Object)some.x()) >> 8;
                Util$ util$3 = Util$.MODULE$;
                cTRNS.writeByte((byte)n3);
                cTRNS.writeTo(dos);
                break block1;
            }
            if (!(pngColorEncoding instanceof IndexedPngEncoding)) break block1;
            IndexedPngEncoding indexedPngEncoding = (IndexedPngEncoding)pngColorEncoding;
            Chunk cPLTE = new Chunk(this.PLTE());
            Predef$.MODULE$.intArrayOps(indexedPngEncoding.rgbs()).foreach((Function1)new Serializable(this, cPLTE){
                public static final long serialVersionUID = 0L;
                private final Chunk cPLTE$1;

                public final void apply(int rgb) {
                    this.apply$mcVI$sp(rgb);
                }

                public void apply$mcVI$sp(int rgb) {
                    int n = rgb >> 16;
                    Util$ util$ = Util$.MODULE$;
                    this.cPLTE$1.writeByte((byte)n);
                    int n2 = rgb >> 8;
                    Util$ util$2 = Util$.MODULE$;
                    this.cPLTE$1.writeByte((byte)n2);
                    Util$ util$3 = Util$.MODULE$;
                    this.cPLTE$1.writeByte((byte)rgb);
                }
                {
                    this.cPLTE$1 = cPLTE$1;
                }
            });
            cPLTE.writeTo(dos);
            Chunk cTRNS = new Chunk(this.TRNS());
            Predef$.MODULE$.intArrayOps(indexedPngEncoding.as()).foreach((Function1)new Serializable(this, cTRNS){
                public static final long serialVersionUID = 0L;
                public final Chunk cTRNS$1;

                public final void apply(int a) {
                    Util$ util$ = Util$.MODULE$;
                    this.cTRNS$1.writeByte((byte)a);
                }

                public void apply$mcVI$sp(int a) {
                    Util$ util$ = Util$.MODULE$;
                    this.cTRNS$1.writeByte((byte)a);
                }
                {
                    this.cTRNS$1 = cTRNS$1;
                }
            });
            cTRNS.writeTo(dos);
        }
    }

    public ByteBuffer createByteBuffer(Tile raster) {
        block6: {
            ByteBuffer bb;
            block3: {
                int[] data;
                int size;
                block5: {
                    block4: {
                        block2: {
                            size = raster.size();
                            data = raster.toArray();
                            bb = ByteBuffer.allocate(size * this.DEPTH());
                            if (this.DEPTH() != 4) break block2;
                            Util$.MODULE$.initByteBuffer32(bb, data, size);
                            break block3;
                        }
                        if (this.DEPTH() != 3) break block4;
                        Util$.MODULE$.initByteBuffer24(bb, data, size);
                        break block3;
                    }
                    if (this.DEPTH() != 2) break block5;
                    Util$.MODULE$.initByteBuffer16(bb, data, size);
                    break block3;
                }
                if (this.DEPTH() != 1) break block6;
                Util$.MODULE$.initByteBuffer8(bb, data, size);
            }
            return bb;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported depth: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.DEPTH())})));
    }

    public void writePixelData(DataOutputStream dos, Tile raster) {
        block4: {
            block3: {
                Filter filter;
                block2: {
                    filter = this.settings().filter();
                    if (!PaethFilter$.MODULE$.equals(filter)) break block2;
                    this.writePixelDataPaeth(dos, raster);
                    break block3;
                }
                if (!NoFilter$.MODULE$.equals(filter)) break block4;
                this.writePixelDataNoFilter(dos, raster);
            }
            return;
        }
        throw package$.MODULE$.error("filter %s not supported");
    }

    public void writePixelDataNoFilter(DataOutputStream dos, Tile raster) {
        int cols = raster.cols();
        int size = cols * raster.rows();
        Chunk cIDAT = new Chunk(this.IDAT());
        ByteBuffer bb = this.createByteBuffer(raster);
        DeflaterOutputStream dfos = new DeflaterOutputStream((OutputStream)cIDAT.cos(), new Deflater(1));
        int byteWidth = cols * this.DEPTH();
        byte[] currLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        for (int yspan = 0; yspan < size; yspan += cols) {
            bb.position(yspan * this.DEPTH());
            bb.get(currLine);
            dfos.write(this.FILTER());
            dfos.write(currLine);
        }
        dfos.finish();
        cIDAT.writeTo(dos);
    }

    public void writePixelDataPaeth(DataOutputStream dos, Tile raster) {
        int cols = raster.cols();
        int size = cols * raster.rows();
        Chunk cIDAT = new Chunk(this.IDAT());
        ByteBuffer bb = this.createByteBuffer(raster);
        DeflaterOutputStream dfos = new DeflaterOutputStream((OutputStream)cIDAT.cos(), new Deflater(1));
        int byteWidth = cols * this.DEPTH();
        byte[] lineOut = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        byte[] prevLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        byte[] currLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        for (int yspan = 0; yspan < size; yspan += cols) {
            int j;
            bb.position(yspan * this.DEPTH());
            bb.get(currLine);
            for (j = 0; j < this.DEPTH(); ++j) {
                int n = currLine[j] - prevLine[j];
                Util$ util$ = Util$.MODULE$;
                lineOut[j] = (byte)n;
            }
            while (j < byteWidth) {
                int a = currLine[j - this.DEPTH()] & 0xFF;
                int b = prevLine[j] & 0xFF;
                int c = prevLine[j - this.DEPTH()] & 0xFF;
                int pa = b - c;
                int pb = a - c;
                int pc = pa + pb;
                if (pa < 0) {
                    pa = -pa;
                }
                if (pb < 0) {
                    pb = -pb;
                }
                if (pc < 0) {
                    pc = -pc;
                }
                if (pa <= pb && pa <= pc) {
                    c = a;
                } else if (pb <= pc) {
                    c = b;
                }
                int n = currLine[j] - c;
                Util$ util$ = Util$.MODULE$;
                lineOut[j] = (byte)n;
                ++j;
            }
            dfos.write(this.FILTER());
            dfos.write(lineOut);
            byte[] tmp = prevLine;
            prevLine = currLine;
            currLine = tmp;
        }
        dfos.finish();
        cIDAT.writeTo(dos);
    }

    public void writeEnd(DataOutputStream dos) {
        Chunk cIEND = new Chunk(this.IEND());
        cIEND.writeTo(dos);
    }

    public void writeOutputStream(OutputStream os, Tile raster) {
        DataOutputStream dos = new DataOutputStream(os);
        this.writeHeader(dos, raster);
        this.writeBackgroundInfo(dos);
        this.writePixelData(dos, raster);
        this.writeEnd(dos);
        dos.flush();
    }

    public byte[] writeByteArray(Tile raster) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeOutputStream(baos, raster);
        return baos.toByteArray();
    }

    public void writePath(String path, Tile raster) {
        FileOutputStream fos = new FileOutputStream(new File(path));
        this.writeOutputStream(fos, raster);
        fos.close();
    }

    public PngEncoder copy(Settings settings) {
        return new PngEncoder(settings);
    }

    public Settings copy$default$1() {
        return this.settings();
    }

    public String productPrefix() {
        return "PngEncoder";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.settings();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PngEncoder;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof PngEncoder)) return false;
        boolean bl = true;
        if (!bl) return false;
        PngEncoder pngEncoder = (PngEncoder)x$1;
        Settings settings = this.settings();
        Settings settings2 = pngEncoder.settings();
        if (settings == null) {
            if (settings2 != null) {
                return false;
            }
        } else if (!((Object)settings).equals(settings2)) return false;
        if (!pngEncoder.canEqual(this)) return false;
        return true;
    }

    public PngEncoder(Settings settings) {
        this.settings = settings;
        Product.class.$init$((Product)this);
        this.SIGNATURE = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)137, 80, 78, 71, 13, 10, 26, 10}), ClassTag$.MODULE$.Byte());
        this.IHDR = 1229472850;
        this.BKGD = 1649100612;
        this.PLTE = 1347179589;
        this.TRNS = 1951551059;
        this.IDAT = 1229209940;
        this.IEND = 1229278788;
        this.FILTER = settings.filter().n();
        this.DEPTH = settings.colorType().depth();
        this.SHIFT = (this.DEPTH() - 1) * 8;
    }
}

