/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.render;

import geotrellis.raster.CellGrid;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.package$;
import geotrellis.raster.render.ColorMap;
import geotrellis.raster.render.ColorMap$;
import geotrellis.raster.render.ColorRamp;
import geotrellis.raster.render.IntColorMap;
import geotrellis.raster.render.IntColorMap$;
import geotrellis.raster.render.Png;
import geotrellis.raster.render.Png$;
import geotrellis.raster.render.PngRenderMethods;
import geotrellis.raster.render.png.PaethFilter$;
import geotrellis.raster.render.png.PngColorEncoding;
import geotrellis.raster.render.png.PngColorEncoding$;
import geotrellis.raster.render.png.PngEncoder;
import geotrellis.raster.render.png.RgbaPngEncoding$;
import geotrellis.raster.render.png.Settings;
import scala.Array$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;

public abstract class PngRenderMethods$class {
    public static Png renderPng(PngRenderMethods $this) {
        return $this.renderPng(RgbaPngEncoding$.MODULE$);
    }

    public static Png renderPng(PngRenderMethods $this, PngColorEncoding colorEncoding) {
        return Png$.MODULE$.arrayByteToPng(new PngEncoder(new Settings(colorEncoding, PaethFilter$.MODULE$)).writeByteArray((Tile)$this.self()));
    }

    public static Png renderPng(PngRenderMethods $this, ColorMap colorMap) {
        PngColorEncoding colorEncoding = PngColorEncoding$.MODULE$.apply(colorMap.colors(), colorMap.options().noDataColor(), colorMap.options().fallbackColor());
        ColorMap convertedColorMap = colorEncoding.convertColorMap(colorMap);
        return PngRenderMethods$class.renderPng($this, colorEncoding, convertedColorMap);
    }

    public static Png renderPng(PngRenderMethods $this, ColorRamp colorRamp) {
        Png png;
        if (((CellGrid)$this.self()).cellType().isFloatingPoint()) {
            Histogram<Object> histogram2 = package$.MODULE$.withTileMethods((Tile)$this.self()).histogram();
            int[] quantileBreaks2 = histogram2.quantileBreaks$mcI$sp(colorRamp.numStops());
            png = $this.renderPng(new IntColorMap((Map<Object, Object>)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(quantileBreaks2).zip(colorRamp.colors(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms()), IntColorMap$.MODULE$.$lessinit$greater$default$2()).cache(histogram2));
        } else {
            Histogram<Object> histogram3 = package$.MODULE$.withTileMethods((Tile)$this.self()).histogramDouble();
            png = $this.renderPng(ColorMap$.MODULE$.fromQuantileBreaks(histogram3, colorRamp, Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        return png;
    }

    private static Png renderPng(PngRenderMethods $this, PngColorEncoding colorEncoding, ColorMap colorMap) {
        PngEncoder encoder = new PngEncoder(new Settings(colorEncoding, PaethFilter$.MODULE$));
        return Png$.MODULE$.arrayByteToPng(encoder.writeByteArray(colorMap.render((Tile)$this.self())));
    }

    public static void $init$(PngRenderMethods $this) {
    }
}

