/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.regiongroup;

import geotrellis.raster.Connectivity;
import geotrellis.raster.FourNeighbors$;
import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.regiongroup.RegionGroupOptions;
import geotrellis.raster.regiongroup.RegionGroupOptions$;
import geotrellis.raster.regiongroup.RegionGroupResult;
import geotrellis.raster.regiongroup.RegionPartition;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class RegionGroup$ {
    public static final RegionGroup$ MODULE$;

    static {
        new RegionGroup$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RegionGroupResult apply(Tile r, RegionGroupOptions options) {
        int regionId = -1;
        RegionPartition regions = new RegionPartition();
        Map regionMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int cols = r.cols();
        int rows = r.rows();
        IntArrayTile tile = IntArrayTile$.MODULE$.empty(cols, rows);
        boolean ignoreNoData = options.ignoreNoData();
        Connectivity connectivity = options.connectivity();
        FourNeighbors$ fourNeighbors$ = FourNeighbors$.MODULE$;
        if (connectivity != null && connectivity.equals(fourNeighbors$)) {
            for (int index$macro$641 = 0; index$macro$641 < rows; ++index$macro$641) {
                int valueToLeft = Integer.MIN_VALUE;
                for (int index$macro$640 = 0; index$macro$640 < cols; ++index$macro$640) {
                    int v = r.get(index$macro$640, index$macro$641);
                    if (v != Integer.MIN_VALUE || !ignoreNoData) {
                        int top;
                        int n = top = index$macro$641 > 0 ? r.get(index$macro$640, index$macro$641 - 1) : v + 1;
                        if (v == top) {
                            int leftRegion;
                            int topRegion = tile.get(index$macro$640, index$macro$641 - 1);
                            tile.set(index$macro$640, index$macro$641, topRegion);
                            if (v == valueToLeft && index$macro$640 > 0 && (leftRegion = tile.get(index$macro$640 - 1, index$macro$641)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$640 - 1, index$macro$641));
                            }
                        } else if (v == valueToLeft && index$macro$640 > 0) {
                            tile.set(index$macro$640, index$macro$641, tile.get(index$macro$640 - 1, index$macro$641));
                        } else {
                            regions.add(++regionId);
                            tile.set(index$macro$640, index$macro$641, regionId);
                            regionMap.update((Object)BoxesRunTime.boxToInteger((int)regionId), (Object)BoxesRunTime.boxToInteger((int)v));
                        }
                    }
                    valueToLeft = v;
                }
            }
        } else {
            for (int index$macro$643 = 0; index$macro$643 < rows; ++index$macro$643) {
                int valueToLeft = Integer.MIN_VALUE;
                int valueToTopLeft = Integer.MIN_VALUE;
                int valueToTop = Integer.MIN_VALUE;
                for (int index$macro$642 = 0; index$macro$642 < cols; ++index$macro$642) {
                    int topRight;
                    int v = r.get(index$macro$642, index$macro$643);
                    int n = topRight = index$macro$643 > 0 && index$macro$642 < cols - 1 ? r.get(index$macro$642 + 1, index$macro$643 - 1) : v + 1;
                    if (index$macro$642 == 0) {
                        valueToTop = index$macro$643 > 0 ? r.get(index$macro$642, index$macro$643 - 1) : v + 1;
                    }
                    if (v != Integer.MIN_VALUE || !ignoreNoData) {
                        if (v == topRight) {
                            int topRegion;
                            int topLeftRegion;
                            int leftRegion;
                            int topRightRegion = tile.get(index$macro$642 + 1, index$macro$643 - 1);
                            tile.set(index$macro$642, index$macro$643, topRightRegion);
                            if (v == valueToLeft && index$macro$642 > 0 && (leftRegion = tile.get(index$macro$642 - 1, index$macro$643)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$642 - 1, index$macro$643));
                            }
                            if (v == valueToTopLeft && index$macro$642 > 0 && index$macro$643 > 0 && (topLeftRegion = tile.get(index$macro$642 - 1, index$macro$643 - 1)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$642 - 1, index$macro$643 - 1));
                            }
                            if (v == valueToTop && index$macro$643 > 0 && (topRegion = tile.get(index$macro$642, index$macro$643 - 1)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$642, index$macro$643 - 1));
                            }
                        } else if (v == valueToTop) {
                            int topLeftRegion;
                            int leftRegion;
                            int topRegion = tile.get(index$macro$642, index$macro$643 - 1);
                            tile.set(index$macro$642, index$macro$643, topRegion);
                            if (v == valueToLeft && index$macro$642 > 0 && (leftRegion = tile.get(index$macro$642 - 1, index$macro$643)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$642 - 1, index$macro$643));
                            }
                            if (v == valueToTopLeft && index$macro$642 > 0 && index$macro$643 > 0 && (topLeftRegion = tile.get(index$macro$642 - 1, index$macro$643 - 1)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$642 - 1, index$macro$643 - 1));
                            }
                        } else if (v == valueToLeft && index$macro$642 > 0) {
                            int topLeftRegion;
                            int westRegion = tile.get(index$macro$642 - 1, index$macro$643);
                            tile.set(index$macro$642, index$macro$643, westRegion);
                            if (v == valueToTopLeft && index$macro$642 > 0 && index$macro$643 > 0 && (topLeftRegion = tile.get(index$macro$642 - 1, index$macro$643 - 1)) != westRegion) {
                                regions.add(westRegion, tile.get(index$macro$642 - 1, index$macro$643 - 1));
                            }
                        } else if (v == valueToTopLeft && index$macro$642 > 0 && index$macro$643 > 0) {
                            tile.set(index$macro$642, index$macro$643, tile.get(index$macro$642 - 1, index$macro$643 - 1));
                        } else {
                            regions.add(++regionId);
                            tile.set(index$macro$642, index$macro$643, regionId);
                            regionMap.update((Object)BoxesRunTime.boxToInteger((int)regionId), (Object)BoxesRunTime.boxToInteger((int)v));
                        }
                    }
                    valueToLeft = v;
                    valueToTopLeft = valueToTop;
                    valueToTop = topRight;
                }
            }
        }
        for (int index$macro$645 = 0; index$macro$645 < rows; ++index$macro$645) {
            for (int index$macro$644 = 0; index$macro$644 < cols; ++index$macro$644) {
                BoxedUnit boxedUnit;
                int v = tile.get(index$macro$644, index$macro$645);
                if (v == Integer.MIN_VALUE && ignoreNoData) continue;
                int cls = regions.getClass(v);
                if (cls != v && regionMap.contains((Object)BoxesRunTime.boxToInteger((int)v))) {
                    if (!regionMap.contains((Object)BoxesRunTime.boxToInteger((int)cls))) throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Region map should contain class identifier ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cls)})));
                    boxedUnit = regionMap.remove((Object)BoxesRunTime.boxToInteger((int)v));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                tile.set(index$macro$644, index$macro$645, regions.getClass(v));
            }
        }
        return new RegionGroupResult(tile, (scala.collection.immutable.Map<Object, Object>)regionMap.toMap(Predef$.MODULE$.$conforms()));
    }

    public RegionGroupOptions apply$default$2() {
        return RegionGroupOptions$.MODULE$.default();
    }

    private RegionGroup$() {
        MODULE$ = this;
    }
}

