/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.rasterize.polygon;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.strtree.STRtree;
import geotrellis.raster.PixelIsPoint$;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$Options$;
import geotrellis.vector.Polygon;
import java.util.Arrays;
import scala.Array$;
import scala.Double$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class PolygonRasterizer$ {
    public static final PolygonRasterizer$ MODULE$;

    static {
        new PolygonRasterizer$();
    }

    public List<Tuple2<Object, Object>> geotrellis$raster$rasterize$polygon$PolygonRasterizer$$intervalIntersection(Tuple2<Object, Object> a, Tuple2<Object, Object> b) {
        double right;
        double left = package$.MODULE$.max(a._1$mcD$sp(), b._1$mcD$sp());
        return left <= (right = package$.MODULE$.min(a._2$mcD$sp(), b._2$mcD$sp())) ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(left, right)})) : List$.MODULE$.empty();
    }

    public List<Tuple2<Object, Object>> geotrellis$raster$rasterize$polygon$PolygonRasterizer$$intervalDifference(Tuple2<Object, Object> a, Tuple2<Object, Object> b) {
        if (a != null) {
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(a._1$mcD$sp(), a._2$mcD$sp());
            double aLeft = sp2._1$mcD$sp();
            double aRight = sp2._2$mcD$sp();
            if (b != null) {
                Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(b._1$mcD$sp(), b._2$mcD$sp());
                double bLeft = sp3._1$mcD$sp();
                double bRight = sp3._2$mcD$sp();
                return aLeft <= bLeft && bRight <= aRight ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(aLeft, bLeft), new Tuple2.mcDD.sp(bRight, aRight)})) : (bLeft <= aLeft && aRight <= bRight ? List$.MODULE$.empty() : (aLeft <= bLeft && bLeft <= aRight ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(aLeft, bLeft)})) : (bLeft <= aLeft && bRight <= aRight ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(bRight, aRight)})) : List$.MODULE$.empty())));
            }
            throw new MatchError(b);
        }
        throw new MatchError(a);
    }

    public List<Tuple2<Object, Object>> geotrellis$raster$rasterize$polygon$PolygonRasterizer$$intervalDifference(List<Tuple2<Object, Object>> a, Tuple2<Object, Object> b) {
        return (List)a.flatMap((Function1)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final Tuple2 b$1;

            public final List<Tuple2<Object, Object>> apply(Tuple2<Object, Object> x$3) {
                return PolygonRasterizer$.MODULE$.geotrellis$raster$rasterize$polygon$PolygonRasterizer$$intervalDifference(x$3, (Tuple2<Object, Object>)this.b$1);
            }
            {
                this.b$1 = b$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private double[] mergeIntervals(Seq<Tuple2<Object, Object>> sortedIntervals) {
        double[] dArray;
        if (sortedIntervals.length() > 0) {
            Tuple2 head = (Tuple2)sortedIntervals.head();
            Stack stack = (Stack)Stack$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{head._1$mcD$sp(), head._2$mcD$sp()}));
            ((IterableLike)sortedIntervals.tail()).foreach((Function1)new Serializable(stack){
                public static final long serialVersionUID = 0L;
                private final Stack stack$1;

                public final Stack<Object> apply(Tuple2<Object, Object> interval) {
                    Stack stack;
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)this.stack$1.apply(0)), BoxesRunTime.unboxToDouble((Object)this.stack$1.apply(1)));
                    Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(sp2._1$mcD$sp(), sp2._2$mcD$sp());
                    double l1 = sp3._1$mcD$sp();
                    double r1 = sp3._2$mcD$sp();
                    Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(interval._1$mcD$sp(), interval._2$mcD$sp());
                    Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(sp4._1$mcD$sp(), sp4._2$mcD$sp());
                    double l2 = sp5._1$mcD$sp();
                    double r2 = sp5._2$mcD$sp();
                    if (r1 < l2) {
                        this.stack$1.push((Object)BoxesRunTime.boxToDouble((double)interval._2$mcD$sp()));
                        stack = this.stack$1.push((Object)BoxesRunTime.boxToDouble((double)interval._1$mcD$sp()));
                    } else {
                        this.stack$1.pop();
                        this.stack$1.pop();
                        this.stack$1.push((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(r1, r2)));
                        stack = this.stack$1.push((Object)BoxesRunTime.boxToDouble((double)l1));
                    }
                    return stack;
                }
                {
                    this.stack$1 = stack$1;
                }
            });
            dArray = (double[])stack.toArray(ClassTag$.MODULE$.Double());
        } else {
            dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
        }
        return dArray;
    }

    public Tuple2<Object, Object> geotrellis$raster$rasterize$polygon$PolygonRasterizer$$lineAxisIntersection(Tuple4<Object, Object, Object, Object> line, double y) {
        if (line != null) {
            Tuple4 tuple4 = new Tuple4(line._1(), line._2(), line._3(), line._4());
            double x1 = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double y1 = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double x2 = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double y2 = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            return y == y1 ? new Tuple2.mcDI.sp(x1, 1) : (y == y2 ? new Tuple2.mcDI.sp(x2, -1) : (package$.MODULE$.min(y1, y2) <= y && y <= package$.MODULE$.max(y1, y2) ? new Tuple2.mcDI.sp(((x1 - x2) * y - (x1 * y2 - y1 * x2)) / (y1 - y2), 0) : new Tuple2.mcDI.sp(Double.NEGATIVE_INFINITY, 8)));
        }
        throw new MatchError(line);
    }

    public STRtree polygonToEdges(Polygon poly, RasterExtent re) {
        STRtree rtree = new STRtree();
        Coordinate[] coords = poly.jtsGeom().getExteriorRing().getCoordinates();
        for (int index$macro$637 = 1; index$macro$637 < coords.length; ++index$macro$637) {
            Coordinate coord1 = coords[index$macro$637 - 1];
            Coordinate coord2 = coords[index$macro$637];
            double col1 = re.mapXToGridDouble(coord1.x);
            double row1 = re.mapYToGridDouble(coord1.y);
            double col2 = re.mapXToGridDouble(coord2.x);
            double row2 = re.mapYToGridDouble(coord2.y);
            Tuple4 segment = row1 < row2 ? new Tuple4((Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1), (Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2)) : new Tuple4((Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2), (Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1));
            rtree.insert(new Envelope(package$.MODULE$.min(col1, col2), package$.MODULE$.max(col1, col2), BoxesRunTime.unboxToDouble((Object)segment._2()), BoxesRunTime.unboxToDouble((Object)segment._4())), (Object)segment);
        }
        for (int index$macro$639 = 0; index$macro$639 < poly.numberOfHoles(); ++index$macro$639) {
            Coordinate[] coords2 = poly.jtsGeom().getInteriorRingN(index$macro$639).getCoordinates();
            for (int index$macro$638 = 1; index$macro$638 < coords2.length; ++index$macro$638) {
                Coordinate coord1 = coords2[index$macro$638 - 1];
                Coordinate coord2 = coords2[index$macro$638];
                double col1 = re.mapXToGridDouble(coord1.x);
                double row1 = re.mapYToGridDouble(coord1.y);
                double col2 = re.mapXToGridDouble(coord2.x);
                double row2 = re.mapYToGridDouble(coord2.y);
                Tuple4 segment = row1 < row2 ? new Tuple4((Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1), (Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2)) : new Tuple4((Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2), (Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1));
                rtree.insert(new Envelope(package$.MODULE$.min(col1, col2), package$.MODULE$.max(col1, col2), BoxesRunTime.unboxToDouble((Object)segment._2()), BoxesRunTime.unboxToDouble((Object)segment._4())), (Object)segment);
            }
        }
        return rtree;
    }

    private double[] runsPoint(STRtree rtree, int y, int maxX) {
        double row = (double)y + 0.5;
        Map xcoordsMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer xcoordsList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rtree.query(new Envelope(Double$.MODULE$.MinValue(), Double.MAX_VALUE, row, row))).asScala()).foreach((Function1)new Serializable(row, xcoordsMap){
            public static final long serialVersionUID = 0L;
            private final double row$1;
            private final Map xcoordsMap$1;

            public final void apply(Object edgeObj) {
                Tuple4 edge = (Tuple4)edgeObj;
                if (BoxesRunTime.unboxToDouble((Object)edge._2()) != BoxesRunTime.unboxToDouble((Object)edge._4())) {
                    Tuple2<Object, Object> tuple2 = PolygonRasterizer$.MODULE$.geotrellis$raster$rasterize$polygon$PolygonRasterizer$$lineAxisIntersection((Tuple4<Object, Object, Object, Object>)edge, this.row$1);
                    if (tuple2 != null) {
                        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(tuple2._1$mcD$sp(), tuple2._2$mcI$sp());
                        double xcoord = sp2._1$mcD$sp();
                        int valence = sp2._2$mcI$sp();
                        if (this.xcoordsMap$1.contains((Object)BoxesRunTime.boxToDouble((double)xcoord))) {
                            this.xcoordsMap$1.update((Object)BoxesRunTime.boxToDouble((double)xcoord), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.xcoordsMap$1.apply((Object)BoxesRunTime.boxToDouble((double)xcoord))) + valence)));
                        } else {
                            this.xcoordsMap$1.update((Object)BoxesRunTime.boxToDouble((double)xcoord), (Object)BoxesRunTime.boxToInteger((int)valence));
                        }
                    } else {
                        throw new MatchError(tuple2);
                    }
                }
            }
            {
                this.row$1 = row$1;
                this.xcoordsMap$1 = xcoordsMap$1;
            }
        });
        xcoordsMap.foreach((Function1)new Serializable(xcoordsList){
            public static final long serialVersionUID = 0L;
            private final ListBuffer xcoordsList$1;

            public final Object apply(Tuple2<Object, Object> x0$1) {
                if (x0$1 != null) {
                    return x0$1._2$mcI$sp() == -1 || x0$1._2$mcI$sp() == 0 || x0$1._2$mcI$sp() == 1 ? this.xcoordsList$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(x0$1._1$mcD$sp() + 0.5))) : BoxedUnit.UNIT;
                }
                throw new MatchError(x0$1);
            }
            {
                this.xcoordsList$1 = xcoordsList$1;
            }
        });
        double[] xcoords = (double[])xcoordsList.toArray(ClassTag$.MODULE$.Double());
        Arrays.sort(xcoords);
        return xcoords;
    }

    private double[] runsArea(STRtree rtree, int y, int maxX, boolean partial) {
        double[] dArray;
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(y + 1, y + 0);
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(sp2._1$mcI$sp(), sp2._2$mcI$sp());
        int top = sp3._1$mcI$sp();
        int bot = sp3._2$mcI$sp();
        ListBuffer interactions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer intervals = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer botIntervals = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer topIntervals = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer midIntervals = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef botInterval = BooleanRef.create((boolean)false);
        BooleanRef topInterval = BooleanRef.create((boolean)false);
        DoubleRef botIntervalStart = DoubleRef.create((double)0.0);
        DoubleRef topIntervalStart = DoubleRef.create((double)0.0);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rtree.query(new Envelope(Double$.MODULE$.MinValue(), Double.MAX_VALUE, (double)bot, (double)top))).asScala()).foreach((Function1)new Serializable(top, bot, interactions){
            public static final long serialVersionUID = 0L;
            private final int top$1;
            private final int bot$1;
            private final ListBuffer interactions$1;

            public final Object apply(Object edgeObj) {
                boolean ignore;
                Tuple4 edge = (Tuple4)edgeObj;
                double minY = package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)edge._2()), BoxesRunTime.unboxToDouble((Object)edge._4()));
                double maxY = package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)edge._2()), BoxesRunTime.unboxToDouble((Object)edge._4()));
                boolean bl = ignore = maxY == (double)this.bot$1 || minY == (double)this.top$1;
                return ignore ? BoxedUnit.UNIT : this.interactions$1.$plus$eq((Object)(BoxesRunTime.unboxToDouble((Object)edge._1()) <= BoxesRunTime.unboxToDouble((Object)edge._3()) ? edge : new Tuple4(edge._3(), edge._4(), edge._1(), edge._2())));
            }
            {
                this.top$1 = top$1;
                this.bot$1 = bot$1;
                this.interactions$1 = interactions$1;
            }
        });
        ((TraversableForwarder)interactions.sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple4<Object, Object, Object, Object> x$15, Tuple4<Object, Object, Object, Object> x$16) {
                return BoxesRunTime.unboxToDouble((Object)x$15._1()) < BoxesRunTime.unboxToDouble((Object)x$16._1());
            }
        })).foreach((Function1)new Serializable(partial, top, bot, intervals, botIntervals, topIntervals, midIntervals, botInterval, topInterval, botIntervalStart, topIntervalStart){
            public static final long serialVersionUID = 0L;
            private final boolean partial$1;
            private final int top$1;
            private final int bot$1;
            private final ListBuffer intervals$1;
            private final ListBuffer botIntervals$1;
            private final ListBuffer topIntervals$1;
            private final ListBuffer midIntervals$1;
            private final BooleanRef botInterval$1;
            private final BooleanRef topInterval$1;
            private final DoubleRef botIntervalStart$1;
            private final DoubleRef topIntervalStart$1;

            public final Object apply(Tuple4<Object, Object, Object, Object> edge) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                BoxedUnit boxedUnit3;
                boolean touchesBot;
                double topIntervalX = PolygonRasterizer$.MODULE$.geotrellis$raster$rasterize$polygon$PolygonRasterizer$$lineAxisIntersection(edge, this.top$1)._1$mcD$sp();
                double botIntervalX = PolygonRasterizer$.MODULE$.geotrellis$raster$rasterize$polygon$PolygonRasterizer$$lineAxisIntersection(edge, this.bot$1)._1$mcD$sp();
                boolean touchesTop = topIntervalX != Double.NEGATIVE_INFINITY;
                boolean bl = touchesBot = botIntervalX != Double.NEGATIVE_INFINITY;
                if (this.partial$1) {
                    double firstX;
                    double d = BoxesRunTime.unboxToDouble((Object)edge._2()) <= (double)this.bot$1 ? botIntervalX : (firstX = BoxesRunTime.unboxToDouble((Object)edge._2()) >= (double)this.top$1 ? topIntervalX : BoxesRunTime.unboxToDouble((Object)edge._1()));
                    double secondX = BoxesRunTime.unboxToDouble((Object)edge._4()) <= (double)this.bot$1 ? botIntervalX : (BoxesRunTime.unboxToDouble((Object)edge._4()) >= (double)this.top$1 ? topIntervalX : BoxesRunTime.unboxToDouble((Object)edge._3()));
                    double smallerX = package$.MODULE$.min(firstX, secondX);
                    double largerX = package$.MODULE$.max(firstX, secondX);
                    boxedUnit3 = this.intervals$1.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.floor(smallerX), package$.MODULE$.ceil(largerX)));
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                if (touchesTop) {
                    if (!this.topInterval$1.elem) {
                        this.topInterval$1.elem = true;
                        this.topIntervalStart$1.elem = topIntervalX;
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (this.topInterval$1.elem) {
                        this.topInterval$1.elem = false;
                        double smaller = package$.MODULE$.min(this.topIntervalStart$1.elem, topIntervalX);
                        double larger = package$.MODULE$.max(this.topIntervalStart$1.elem, topIntervalX);
                        boxedUnit2 = this.partial$1 ? this.intervals$1.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.floor(smaller), package$.MODULE$.ceil(larger))) : this.topIntervals$1.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.ceil(smaller), package$.MODULE$.floor(larger)));
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (touchesBot) {
                    if (!this.botInterval$1.elem) {
                        this.botInterval$1.elem = true;
                        this.botIntervalStart$1.elem = botIntervalX;
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (this.botInterval$1.elem) {
                        this.botInterval$1.elem = false;
                        double smaller = package$.MODULE$.min(this.botIntervalStart$1.elem, botIntervalX);
                        double larger = package$.MODULE$.max(this.botIntervalStart$1.elem, botIntervalX);
                        boxedUnit = this.partial$1 ? this.intervals$1.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.floor(smaller), package$.MODULE$.ceil(larger))) : this.botIntervals$1.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.ceil(smaller), package$.MODULE$.floor(larger)));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.partial$1 || touchesTop && touchesBot ? BoxedUnit.UNIT : this.midIntervals$1.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.floor(BoxesRunTime.unboxToDouble((Object)edge._1())), package$.MODULE$.ceil(BoxesRunTime.unboxToDouble((Object)edge._3()))));
            }
            {
                this.partial$1 = partial$1;
                this.top$1 = top$1;
                this.bot$1 = bot$1;
                this.intervals$1 = intervals$1;
                this.botIntervals$1 = botIntervals$1;
                this.topIntervals$1 = topIntervals$1;
                this.midIntervals$1 = midIntervals$1;
                this.botInterval$1 = botInterval$1;
                this.topInterval$1 = topInterval$1;
                this.botIntervalStart$1 = botIntervalStart$1;
                this.topIntervalStart$1 = topIntervalStart$1;
            }
        });
        if (partial) {
            dArray = this.mergeIntervals((Seq<Tuple2<Object, Object>>)((Seq)intervals.sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x$17, Tuple2<Object, Object> x$18) {
                    return x$17._1$mcD$sp() < x$18._1$mcD$sp();
                }
            })));
        } else {
            ListBuffer sortedTopIntervals = (ListBuffer)topIntervals.sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x$19, Tuple2<Object, Object> x$20) {
                    return x$19._1$mcD$sp() < x$20._1$mcD$sp();
                }
            });
            ListBuffer sortedBotIntervals = (ListBuffer)botIntervals.sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x$21, Tuple2<Object, Object> x$22) {
                    return x$21._1$mcD$sp() < x$22._1$mcD$sp();
                }
            });
            ListBuffer intervals2 = (ListBuffer)ListBuffer$.MODULE$.empty();
            ((TraversableLike)sortedTopIntervals.zip((GenIterable)sortedBotIntervals, ListBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(midIntervals, intervals2){
                public static final long serialVersionUID = 0L;
                private final ListBuffer midIntervals$1;
                private final ListBuffer intervals$2;

                public final ListBuffer<Tuple2<Object, Object>> apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$2) {
                    if (x0$2 != null) {
                        List<Tuple2<Object, Object>> intersection = PolygonRasterizer$.MODULE$.geotrellis$raster$rasterize$polygon$PolygonRasterizer$$intervalIntersection((Tuple2<Object, Object>)((Tuple2)x0$2._1()), (Tuple2<Object, Object>)((Tuple2)x0$2._2()));
                        List differences = (List)this.midIntervals$1.foldLeft(intersection, (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<Tuple2<Object, Object>> apply(List<Tuple2<Object, Object>> a, Tuple2<Object, Object> b) {
                                return PolygonRasterizer$.MODULE$.geotrellis$raster$rasterize$polygon$PolygonRasterizer$$intervalDifference(a, b);
                            }
                        });
                        return this.intervals$2.$plus$plus$eq((TraversableOnce)differences);
                    }
                    throw new MatchError(x0$2);
                }
                {
                    this.midIntervals$1 = midIntervals$1;
                    this.intervals$2 = intervals$2;
                }
            }, ListBuffer$.MODULE$.canBuildFrom());
            dArray = this.mergeIntervals((Seq<Tuple2<Object, Object>>)intervals2);
        }
        return dArray;
    }

    public void foreachCellByPolygon(Polygon poly, RasterExtent re, Rasterizer.Options options, Function2<Object, Object, BoxedUnit> f) {
        PixelSampleType sampleType = options.sampleType();
        boolean partial = options.includePartial();
        STRtree edges = this.polygonToEdges(poly, re);
        for (int y = 0; y < re.rows(); ++y) {
            PixelSampleType pixelSampleType = sampleType;
            PixelIsPoint$ pixelIsPoint$ = PixelIsPoint$.MODULE$;
            double[] rowRuns = pixelSampleType != null && pixelSampleType.equals(pixelIsPoint$) ? this.runsPoint(edges, y, re.cols()) : this.runsArea(edges, y, re.cols(), partial);
            for (int i = 0; i < rowRuns.length; i += 2) {
                int stop = package$.MODULE$.min((int)rowRuns[i + 1], re.cols());
                for (int x = package$.MODULE$.max((int)rowRuns[i], 0); x < stop; ++x) {
                    f.apply$mcVII$sp(x, y);
                }
            }
        }
    }

    public Rasterizer.Options foreachCellByPolygon$default$3() {
        return Rasterizer$Options$.MODULE$.DEFAULT();
    }

    private PolygonRasterizer$() {
        MODULE$ = this;
    }
}

