/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.rasterize;

import com.vividsolutions.jts.geom.Coordinate;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.IntConstantNoDataArrayTile;
import geotrellis.raster.PixelIsPoint$;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import geotrellis.raster.package$IntArrayFiller$;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$Options$;
import geotrellis.raster.rasterize.extent.ExtentRasterizer$;
import geotrellis.raster.rasterize.polygon.PolygonRasterizer$;
import geotrellis.vector.Extent;
import geotrellis.vector.Geometry;
import geotrellis.vector.GeometryCollection;
import geotrellis.vector.Line;
import geotrellis.vector.MultiLine;
import geotrellis.vector.MultiPoint;
import geotrellis.vector.MultiPolygon;
import geotrellis.vector.Point;
import geotrellis.vector.Polygon;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class Rasterizer$ {
    public static final Rasterizer$ MODULE$;

    static {
        new Rasterizer$();
    }

    public Tile rasterizeWithValue(Geometry geom, RasterExtent rasterExtent, int value) {
        int cols = rasterExtent.cols();
        int[] nArray = (int[])Array$.MODULE$.ofDim(rasterExtent.cols() * rasterExtent.rows(), ClassTag$.MODULE$.Int());
        package$ package$2 = package$.MODULE$;
        package$IntArrayFiller$ package$IntArrayFiller$2 = package$IntArrayFiller$.MODULE$;
        Arrays.fill(nArray, Integer.MIN_VALUE);
        Serializable f2 = new Serializable(value, cols, nArray){
            public static final long serialVersionUID = 0L;
            private final int value$1;
            private final int cols$1;
            private final int[] array$1;

            public final void apply(int col, int row) {
                this.apply$mcVII$sp(col, row);
            }

            public void apply$mcVII$sp(int col, int row) {
                this.array$1[row * this.cols$1 + col] = this.value$1;
            }
            {
                this.value$1 = value$1;
                this.cols$1 = cols$1;
                this.array$1 = array$1;
            }
        };
        Rasterizer$Options$ rasterizer$Options$ = Rasterizer$Options$.MODULE$;
        this.foreachCellByGeometry(geom, rasterExtent, new Rasterizer.Options(true, PixelIsPoint$.MODULE$), (Function2<Object, Object, BoxedUnit>)f2);
        int n = rasterExtent.rows();
        int n2 = rasterExtent.cols();
        ArrayTile$ arrayTile$ = ArrayTile$.MODULE$;
        return new IntConstantNoDataArrayTile(nArray, n2, n);
    }

    public IntConstantNoDataArrayTile rasterize(Geometry feature, RasterExtent rasterExtent, Function2<Object, Object, Object> f) {
        int cols = rasterExtent.cols();
        int[] nArray = (int[])Array$.MODULE$.ofDim(rasterExtent.cols() * rasterExtent.rows(), ClassTag$.MODULE$.Int());
        package$ package$2 = package$.MODULE$;
        package$IntArrayFiller$ package$IntArrayFiller$2 = package$IntArrayFiller$.MODULE$;
        Arrays.fill(nArray, Integer.MIN_VALUE);
        Serializable f2 = new Serializable(f, cols, nArray){
            public static final long serialVersionUID = 0L;
            private final Function2 f$2;
            private final int cols$2;
            private final int[] array$2;

            public final void apply(int col, int row) {
                this.apply$mcVII$sp(col, row);
            }

            public void apply$mcVII$sp(int col, int row) {
                this.array$2[row * this.cols$2 + col] = this.f$2.apply$mcIII$sp(col, row);
            }
            {
                this.f$2 = f$2;
                this.cols$2 = cols$2;
                this.array$2 = array$2;
            }
        };
        Rasterizer$Options$ rasterizer$Options$ = Rasterizer$Options$.MODULE$;
        this.foreachCellByGeometry(feature, rasterExtent, new Rasterizer.Options(true, PixelIsPoint$.MODULE$), (Function2<Object, Object, BoxedUnit>)f2);
        int n = rasterExtent.rows();
        int n2 = rasterExtent.cols();
        ArrayTile$ arrayTile$ = ArrayTile$.MODULE$;
        return new IntConstantNoDataArrayTile(nArray, n2, n);
    }

    public void foreachCellByGeometry(Geometry geom, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        this.foreachCellByGeometry(geom, re, Rasterizer$Options$.MODULE$.DEFAULT(), f);
    }

    public void foreachCellByGeometry(Geometry geom, RasterExtent re, Rasterizer.Options options, Function2<Object, Object, BoxedUnit> f) {
        block10: {
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(geom instanceof Point)) break block2;
                                            Point point = (Point)geom;
                                            this.foreachCellByPoint(point, re, f);
                                            break block3;
                                        }
                                        if (!(geom instanceof MultiPoint)) break block4;
                                        MultiPoint multiPoint = (MultiPoint)geom;
                                        this.foreachCellByMultiPoint(multiPoint, re, f);
                                        break block3;
                                    }
                                    if (!(geom instanceof MultiLine)) break block5;
                                    MultiLine multiLine = (MultiLine)geom;
                                    this.foreachCellByMultiLineString(multiLine, re, f);
                                    break block3;
                                }
                                if (!(geom instanceof Line)) break block6;
                                Line line = (Line)geom;
                                this.foreachCellByLineString(line, re, f);
                                break block3;
                            }
                            if (!(geom instanceof Polygon)) break block7;
                            Polygon polygon = (Polygon)geom;
                            PolygonRasterizer$.MODULE$.foreachCellByPolygon(polygon, re, options, f);
                            break block3;
                        }
                        if (!(geom instanceof MultiPolygon)) break block8;
                        MultiPolygon multiPolygon = (MultiPolygon)geom;
                        this.foreachCellByMultiPolygon(multiPolygon, re, options, f);
                        break block3;
                    }
                    if (!(geom instanceof GeometryCollection)) break block9;
                    GeometryCollection geometryCollection = (GeometryCollection)geom;
                    geometryCollection.geometries().foreach((Function1)new Serializable(re, options, f){
                        public static final long serialVersionUID = 0L;
                        private final RasterExtent re$1;
                        private final Rasterizer.Options options$1;
                        private final Function2 f$1;

                        public final void apply(Geometry x$1) {
                            Rasterizer$.MODULE$.foreachCellByGeometry(x$1, this.re$1, this.options$1, (Function2<Object, Object, BoxedUnit>)this.f$1);
                        }
                        {
                            this.re$1 = re$1;
                            this.options$1 = options$1;
                            this.f$1 = f$1;
                        }
                    });
                    break block3;
                }
                if (!(geom instanceof Extent)) break block10;
                Extent extent2 = (Extent)geom;
                ExtentRasterizer$.MODULE$.foreachCellByExtent(extent2, re, options, f);
            }
            return;
        }
        throw new MatchError((Object)geom);
    }

    public void foreachCellByPoint(Point geom, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        int col = re.mapXToGrid(geom.x());
        int row = re.mapYToGrid(geom.y());
        f.apply$mcVII$sp(col, row);
    }

    public void foreachCellByMultiPoint(MultiPoint p, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        Predef$.MODULE$.refArrayOps((Object[])p.points()).foreach((Function1)new Serializable(re, f){
            public static final long serialVersionUID = 0L;
            private final RasterExtent re$2;
            private final Function2 f$3;

            public final void apply(Point x$2) {
                Rasterizer$.MODULE$.foreachCellByPoint(x$2, this.re$2, (Function2<Object, Object, BoxedUnit>)this.f$3);
            }
            {
                this.re$2 = re$2;
                this.f$3 = f$3;
            }
        });
    }

    public void foreachCellByPointSeq(Seq<Point> pSet, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        pSet.foreach((Function1)new Serializable(re, f){
            public static final long serialVersionUID = 0L;
            private final RasterExtent re$6;
            private final Function2 f$7;

            public final void apply(Point x$3) {
                Rasterizer$.MODULE$.foreachCellByPoint(x$3, this.re$6, (Function2<Object, Object, BoxedUnit>)this.f$7);
            }
            {
                this.re$6 = re$6;
                this.f$7 = f$7;
            }
        });
    }

    public void foreachCellByMultiLineString(MultiLine g, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        Predef$.MODULE$.refArrayOps((Object[])g.lines()).foreach((Function1)new Serializable(re, f){
            public static final long serialVersionUID = 0L;
            private final RasterExtent re$3;
            private final Function2 f$4;

            public final void apply(Line x$4) {
                Rasterizer$.MODULE$.foreachCellByLineString(x$4, this.re$3, (Function2<Object, Object, BoxedUnit>)this.f$4);
            }
            {
                this.re$3 = re$3;
                this.f$4 = f$4;
            }
        });
    }

    public void foreachCellByPolygon(Polygon p, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        Rasterizer$Options$ rasterizer$Options$ = Rasterizer$Options$.MODULE$;
        Rasterizer.Options options = new Rasterizer.Options(true, PixelIsPoint$.MODULE$);
        PolygonRasterizer$.MODULE$.foreachCellByPolygon(p, re, options, f);
    }

    public void foreachCellByPolygon(Polygon p, RasterExtent re, Rasterizer.Options options, Function2<Object, Object, BoxedUnit> f) {
        PolygonRasterizer$.MODULE$.foreachCellByPolygon(p, re, options, f);
    }

    public <D> void foreachCellByMultiPolygon(MultiPolygon p, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        this.foreachCellByMultiPolygon(p, re, Rasterizer$Options$.MODULE$.DEFAULT(), f);
    }

    public <D> void foreachCellByMultiPolygon(MultiPolygon p, RasterExtent re, Rasterizer.Options options, Function2<Object, Object, BoxedUnit> f) {
        Predef$.MODULE$.refArrayOps((Object[])p.polygons()).foreach((Function1)new Serializable(re, options, f){
            public static final long serialVersionUID = 0L;
            private final RasterExtent re$5;
            private final Rasterizer.Options options$2;
            private final Function2 f$6;

            public final void apply(Polygon x$5) {
                PolygonRasterizer$.MODULE$.foreachCellByPolygon(x$5, this.re$5, this.options$2, (Function2<Object, Object, BoxedUnit>)this.f$6);
            }
            {
                this.re$5 = re$5;
                this.options$2 = options$2;
                this.f$6 = f$6;
            }
        });
    }

    public void foreachCellByLineString(Line line, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        Object[] objectArray = line.jtsGeom().getCoordinates();
        Predef$ predef$ = Predef$.MODULE$;
        Object[] objectArray2 = (Object[])new ArrayOps.ofRef(objectArray).map((Function1)new Serializable(re){
            public static final long serialVersionUID = 0L;
            private final RasterExtent re$4;

            public final Tuple2<Object, Object> apply(Coordinate coord) {
                return new Tuple2.mcII.sp(this.re$4.mapXToGrid(coord.x), this.re$4.mapYToGrid(coord.y));
            }
            {
                this.re$4 = re$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Predef$ predef$2 = Predef$.MODULE$;
        List cells = new ArrayOps.ofRef(objectArray2).toList();
        Predef$ predef$3 = Predef$.MODULE$;
        int n = cells.size();
        Range range = Range$.MODULE$.apply(1, n);
        if (!range.isEmpty()) {
            int n2 = range.start();
            while (true) {
                MODULE$.foreachCellInGridLine(((Tuple2)cells.apply(n2 - 1))._1$mcI$sp(), ((Tuple2)cells.apply(n2 - 1))._2$mcI$sp(), ((Tuple2)cells.apply(n2))._1$mcI$sp(), ((Tuple2)cells.apply(n2))._2$mcI$sp(), line, re, n2 != cells.size() - 1, f);
                if (n2 == range.lastElement()) break;
                n2 += range.step();
            }
        }
    }

    public <D> void foreachCellInGridLine(int x0, int y0, int x1, int y1, Line p, RasterExtent re, boolean skipLast, Function2<Object, Object, BoxedUnit> f) {
        int dx = scala.math.package$.MODULE$.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = scala.math.package$.MODULE$.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int x = x0;
        int y = y0;
        int err = (dx > dy ? dx : -dy) / 2;
        while (x != x1 || y != y1) {
            if (0 <= x && x < re.cols() && 0 <= y && y < re.rows()) {
                f.apply$mcVII$sp(x, y);
            }
            int e2 = err;
            if (err > -dx) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dy) continue;
            err += dx;
            y += sy;
        }
        if (!skipLast && 0 <= x && x < re.cols() && 0 <= y && y < re.rows()) {
            f.apply$mcVII$sp(x, y);
        }
    }

    public <D> boolean foreachCellInGridLine$default$7() {
        return false;
    }

    private Rasterizer$() {
        MODULE$ = this;
    }
}

