/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.merge;

import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.CellSize$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.merge.SinglebandTileMergeMethods;
import geotrellis.raster.package$;
import geotrellis.raster.resample.Resample;
import geotrellis.raster.resample.Resample$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.vector.Extent;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.runtime.BoxesRunTime;

public abstract class SinglebandTileMergeMethods$class {
    public static Tile merge(SinglebandTileMergeMethods $this, Tile other) {
        MutableArrayTile mutableTile = ((Tile)$this.self()).mutable();
        package$.MODULE$.TraversableTileExtensions((Traversable<Tile>)((Traversable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{(Tile)$this.self(), other})))).assertEqualDimensions();
        DataType dataType = ((CellGrid)$this.self()).cellType();
        if (BitCellType$.MODULE$.equals(dataType)) {
            for (int index$macro$620 = 0; index$macro$620 < ((Grid)$this.self()).rows(); ++index$macro$620) {
                for (int index$macro$619 = 0; index$macro$619 < ((Grid)$this.self()).cols(); ++index$macro$619) {
                    if (other.get(index$macro$619, index$macro$620) != 1) continue;
                    mutableTile.set(index$macro$619, index$macro$620, 1);
                }
            }
        } else {
            boolean bl = ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : IntCellType$.MODULE$.equals(dataType))));
            if (bl) {
                for (int index$macro$622 = 0; index$macro$622 < ((Grid)$this.self()).rows(); ++index$macro$622) {
                    for (int index$macro$621 = 0; index$macro$621 < ((Grid)$this.self()).cols(); ++index$macro$621) {
                        if (((Tile)$this.self()).get(index$macro$621, index$macro$622) != 0) continue;
                        mutableTile.set(index$macro$621, index$macro$622, other.get(index$macro$621, index$macro$622));
                    }
                }
            } else {
                boolean bl2 = FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType);
                if (bl2) {
                    for (int index$macro$624 = 0; index$macro$624 < ((Grid)$this.self()).rows(); ++index$macro$624) {
                        for (int index$macro$623 = 0; index$macro$623 < ((Grid)$this.self()).cols(); ++index$macro$623) {
                            if (((Tile)$this.self()).getDouble(index$macro$623, index$macro$624) != 0.0) continue;
                            mutableTile.setDouble(index$macro$623, index$macro$624, other.getDouble(index$macro$623, index$macro$624));
                        }
                    }
                } else if (dataType.isFloatingPoint()) {
                    for (int index$macro$626 = 0; index$macro$626 < ((Grid)$this.self()).rows(); ++index$macro$626) {
                        for (int index$macro$625 = 0; index$macro$625 < ((Grid)$this.self()).cols(); ++index$macro$625) {
                            if (!Double.isNaN(((Tile)$this.self()).getDouble(index$macro$625, index$macro$626))) continue;
                            mutableTile.setDouble(index$macro$625, index$macro$626, other.getDouble(index$macro$625, index$macro$626));
                        }
                    }
                } else {
                    for (int index$macro$628 = 0; index$macro$628 < ((Grid)$this.self()).rows(); ++index$macro$628) {
                        for (int index$macro$627 = 0; index$macro$627 < ((Grid)$this.self()).cols(); ++index$macro$627) {
                            if (((Tile)$this.self()).get(index$macro$627, index$macro$628) != Integer.MIN_VALUE) continue;
                            mutableTile.set(index$macro$627, index$macro$628, other.get(index$macro$627, index$macro$628));
                        }
                    }
                }
            }
        }
        return mutableTile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tile merge(SinglebandTileMergeMethods $this, Extent extent2, Extent otherExtent, Tile other, ResampleMethod method) {
        Option option = otherExtent.$amp(extent2);
        if (!(option instanceof Some)) return (Tile)$this.self();
        Some some = (Some)option;
        MutableArrayTile mutableTile = ((Tile)$this.self()).mutable();
        RasterExtent re = RasterExtent$.MODULE$.apply(extent2, ((Grid)$this.self()).cols(), ((Grid)$this.self()).rows());
        GridBounds gridBounds = re.gridBoundsFor((Extent)some.x(), re.gridBoundsFor$default$2());
        if (gridBounds == null) throw new MatchError((Object)gridBounds);
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)gridBounds.colMin()), (Object)BoxesRunTime.boxToInteger((int)gridBounds.rowMin()), (Object)BoxesRunTime.boxToInteger((int)gridBounds.colMax()), (Object)BoxesRunTime.boxToInteger((int)gridBounds.rowMax()));
        tuple4._1();
        tuple4._2();
        int colMax = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int rowMax = BoxesRunTime.unboxToInt((Object)tuple4._4());
        CellSize targetCS = CellSize$.MODULE$.apply((Extent)some.x(), colMax, rowMax);
        DataType dataType = ((CellGrid)$this.self()).cellType();
        boolean bl = BitCellType$.MODULE$.equals(dataType) ? true : (ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : IntCellType$.MODULE$.equals(dataType)))));
        if (bl) {
            Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
            Serializable interpolate = new Serializable($this, resample){
                public static final long serialVersionUID = 0L;
                public final Resample eta$0$1$1;

                public final int apply(double x, double y) {
                    return this.eta$0$1$1.resample(x, y);
                }

                public int apply$mcIDD$sp(double x, double y) {
                    return this.eta$0$1$1.resample(x, y);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            };
            int index$macro$630 = 0;
            while (index$macro$630 < ((Grid)$this.self()).rows()) {
                for (int index$macro$629 = 0; index$macro$629 < ((Grid)$this.self()).cols(); ++index$macro$629) {
                    double y;
                    if (((Tile)$this.self()).get(index$macro$629, index$macro$630) != 0) continue;
                    Tuple2<Object, Object> tuple2 = re.gridToMap(index$macro$629, index$macro$630);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                    double x = sp2._1$mcD$sp();
                    int v = interpolate.eta$0$1$1.resample(x, y = sp2._2$mcD$sp());
                    if (v == Integer.MIN_VALUE) continue;
                    mutableTile.set(index$macro$629, index$macro$630, v);
                }
                ++index$macro$630;
            }
            return mutableTile;
        }
        boolean bl2 = FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType);
        if (bl2) {
            Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
            Serializable interpolate = new Serializable($this, resample){
                public static final long serialVersionUID = 0L;
                public final Resample eta$0$2$1;

                public final double apply(double x, double y) {
                    return this.eta$0$2$1.resampleDouble(x, y);
                }

                public double apply$mcDDD$sp(double x, double y) {
                    return this.eta$0$2$1.resampleDouble(x, y);
                }
                {
                    this.eta$0$2$1 = eta$0$2$1;
                }
            };
            int index$macro$632 = 0;
            while (index$macro$632 < ((Grid)$this.self()).rows()) {
                for (int index$macro$631 = 0; index$macro$631 < ((Grid)$this.self()).cols(); ++index$macro$631) {
                    double y;
                    if (((Tile)$this.self()).getDouble(index$macro$631, index$macro$632) != 0.0) continue;
                    Tuple2<Object, Object> tuple2 = re.gridToMap(index$macro$631, index$macro$632);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                    double x = sp3._1$mcD$sp();
                    double v = interpolate.eta$0$2$1.resampleDouble(x, y = sp3._2$mcD$sp());
                    if (Double.isNaN(v)) continue;
                    mutableTile.setDouble(index$macro$631, index$macro$632, v);
                }
                ++index$macro$632;
            }
            return mutableTile;
        }
        if (dataType.isFloatingPoint()) {
            Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
            Serializable interpolate = new Serializable($this, resample){
                public static final long serialVersionUID = 0L;
                public final Resample eta$0$3$1;

                public final double apply(double x, double y) {
                    return this.eta$0$3$1.resampleDouble(x, y);
                }

                public double apply$mcDDD$sp(double x, double y) {
                    return this.eta$0$3$1.resampleDouble(x, y);
                }
                {
                    this.eta$0$3$1 = eta$0$3$1;
                }
            };
            int index$macro$634 = 0;
            while (index$macro$634 < ((Grid)$this.self()).rows()) {
                for (int index$macro$633 = 0; index$macro$633 < ((Grid)$this.self()).cols(); ++index$macro$633) {
                    if (!Double.isNaN(((Tile)$this.self()).getDouble(index$macro$633, index$macro$634))) continue;
                    Tuple2<Object, Object> tuple2 = re.gridToMap(index$macro$633, index$macro$634);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                    double x = sp4._1$mcD$sp();
                    double y = sp4._2$mcD$sp();
                    mutableTile.setDouble(index$macro$633, index$macro$634, interpolate.eta$0$3$1.resampleDouble(x, y));
                }
                ++index$macro$634;
            }
            return mutableTile;
        }
        Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
        Serializable interpolate = new Serializable($this, resample){
            public static final long serialVersionUID = 0L;
            public final Resample eta$0$4$1;

            public final int apply(double x, double y) {
                return this.eta$0$4$1.resample(x, y);
            }

            public int apply$mcIDD$sp(double x, double y) {
                return this.eta$0$4$1.resample(x, y);
            }
            {
                this.eta$0$4$1 = eta$0$4$1;
            }
        };
        int index$macro$636 = 0;
        while (index$macro$636 < ((Grid)$this.self()).rows()) {
            for (int index$macro$635 = 0; index$macro$635 < ((Grid)$this.self()).cols(); ++index$macro$635) {
                if (((Tile)$this.self()).get(index$macro$635, index$macro$636) != Integer.MIN_VALUE) continue;
                Tuple2<Object, Object> tuple2 = re.gridToMap(index$macro$635, index$macro$636);
                if (tuple2 == null) throw new MatchError(tuple2);
                Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(tuple2._1$mcD$sp(), tuple2._2$mcD$sp());
                double x = sp5._1$mcD$sp();
                double y = sp5._2$mcD$sp();
                mutableTile.set(index$macro$635, index$macro$636, interpolate.eta$0$4$1.resample(x, y));
            }
            ++index$macro$636;
        }
        return mutableTile;
    }

    public static void $init$(SinglebandTileMergeMethods $this) {
    }
}

