/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.matching;

import geotrellis.raster.DataType;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.equalization.HistogramEqualization$;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.histogram.StreamingHistogram$;
import geotrellis.raster.matching.HistogramMatching;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector$;
import scala.math.package$;

public final class HistogramMatching$ {
    public static final HistogramMatching$ MODULE$;
    private final HistogramMatching.BucketComparator geotrellis$raster$matching$HistogramMatching$$cmp;

    static {
        new HistogramMatching$();
    }

    public HistogramMatching.BucketComparator geotrellis$raster$matching$HistogramMatching$$cmp() {
        return this.geotrellis$raster$matching$HistogramMatching$$cmp;
    }

    public double geotrellis$raster$matching$HistogramMatching$$transform(Tuple2<Object, Object>[] targetCdf, Function1<Object, Object> fn, double x) {
        double cdfx = fn.apply$mcDD$sp(x);
        int i = Arrays.binarySearch((Object[])targetCdf, new Tuple2.mcDD.sp(0.0, cdfx), this.geotrellis$raster$matching$HistogramMatching$$cmp());
        return i < 0 ? targetCdf[package$.MODULE$.min(-(i + 1), targetCdf.length - 1)]._1$mcD$sp() : targetCdf[i]._1$mcD$sp();
    }

    public <T1, T2> Tile apply(Tile tile, Histogram<T1> sourceHistogram, Histogram<T2> targetHistogram) {
        DataType cellType = tile.cellType();
        Tuple2<Object, Object>[] tuple2Array = sourceHistogram.cdf();
        Serializable localIntensityToCdf = new Serializable(cellType, tuple2Array){
            public static final long serialVersionUID = 0L;
            public final DataType cellType$1;
            public final Tuple2[] eta$0$1$1;

            public final double apply(double x) {
                double d;
                Tuple2[] tuple2Array = this.eta$0$1$1;
                HistogramEqualization$ histogramEqualization$ = HistogramEqualization$.MODULE$;
                int i1 = Arrays.binarySearch((Object[])tuple2Array, new Tuple2.mcDD.sp(x, 0.0), histogramEqualization$.geotrellis$raster$equalization$HistogramEqualization$$cmp());
                double smallestCdf1 = tuple2Array[0]._2$mcD$sp();
                if (x < tuple2Array[0]._1$mcD$sp()) {
                    d = smallestCdf1;
                } else if (-1 * i1 > tuple2Array.length) {
                    d = 1.0;
                } else if (i1 >= 0) {
                    d = tuple2Array[i1]._2$mcD$sp();
                } else {
                    int j1 = -1 * i1 - 2;
                    double label01 = tuple2Array[j1 + 0]._1$mcD$sp();
                    double label11 = tuple2Array[j1 + 1]._1$mcD$sp();
                    double t1 = (x - label01) / (label11 - label01);
                    double cdf01 = tuple2Array[j1 + 0]._2$mcD$sp();
                    double cdf11 = tuple2Array[j1 + 1]._2$mcD$sp();
                    d = (1.0 - t1) * cdf01 + t1 * cdf11;
                }
                double rawCdf1 = d;
                return package$.MODULE$.max(0.0, package$.MODULE$.min(1.0, (rawCdf1 - smallestCdf1) / (1.0 - smallestCdf1)));
            }

            public double apply$mcDD$sp(double x) {
                double d;
                Tuple2[] tuple2Array = this.eta$0$1$1;
                HistogramEqualization$ histogramEqualization$ = HistogramEqualization$.MODULE$;
                int i1 = Arrays.binarySearch((Object[])tuple2Array, new Tuple2.mcDD.sp(x, 0.0), histogramEqualization$.geotrellis$raster$equalization$HistogramEqualization$$cmp());
                double smallestCdf1 = tuple2Array[0]._2$mcD$sp();
                if (x < tuple2Array[0]._1$mcD$sp()) {
                    d = smallestCdf1;
                } else if (-1 * i1 > tuple2Array.length) {
                    d = 1.0;
                } else if (i1 >= 0) {
                    d = tuple2Array[i1]._2$mcD$sp();
                } else {
                    int j1 = -1 * i1 - 2;
                    double label01 = tuple2Array[j1 + 0]._1$mcD$sp();
                    double label11 = tuple2Array[j1 + 1]._1$mcD$sp();
                    double t1 = (x - label01) / (label11 - label01);
                    double cdf01 = tuple2Array[j1 + 0]._2$mcD$sp();
                    double cdf11 = tuple2Array[j1 + 1]._2$mcD$sp();
                    d = (1.0 - t1) * cdf01 + t1 * cdf11;
                }
                double rawCdf1 = d;
                return package$.MODULE$.max(0.0, package$.MODULE$.min(1.0, (rawCdf1 - smallestCdf1) / (1.0 - smallestCdf1)));
            }
            {
                this.cellType$1 = cellType$1;
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
        Tuple2<Object, Object>[] tuple2Array2 = targetHistogram.cdf();
        Serializable localTransform = new Serializable((Function1)localIntensityToCdf, tuple2Array2){
            public static final long serialVersionUID = 0L;
            public final Function1 localIntensityToCdf$1;
            public final Tuple2[] eta$0$2$1;

            public final double apply(double x) {
                Function1 function1 = this.localIntensityToCdf$1;
                Tuple2[] tuple2Array = this.eta$0$2$1;
                HistogramMatching$ histogramMatching$ = HistogramMatching$.MODULE$;
                double cdfx1 = function1.apply$mcDD$sp(x);
                int i1 = Arrays.binarySearch((Object[])tuple2Array, new Tuple2.mcDD.sp(0.0, cdfx1), histogramMatching$.geotrellis$raster$matching$HistogramMatching$$cmp());
                return i1 < 0 ? tuple2Array[package$.MODULE$.min(-(i1 + 1), tuple2Array.length - 1)]._1$mcD$sp() : tuple2Array[i1]._1$mcD$sp();
            }

            public double apply$mcDD$sp(double x) {
                Function1 function1 = this.localIntensityToCdf$1;
                Tuple2[] tuple2Array = this.eta$0$2$1;
                HistogramMatching$ histogramMatching$ = HistogramMatching$.MODULE$;
                double cdfx1 = function1.apply$mcDD$sp(x);
                int i1 = Arrays.binarySearch((Object[])tuple2Array, new Tuple2.mcDD.sp(0.0, cdfx1), histogramMatching$.geotrellis$raster$matching$HistogramMatching$$cmp());
                return i1 < 0 ? tuple2Array[package$.MODULE$.min(-(i1 + 1), tuple2Array.length - 1)]._1$mcD$sp() : tuple2Array[i1]._1$mcD$sp();
            }
            {
                this.localIntensityToCdf$1 = localIntensityToCdf$1;
                this.eta$0$2$1 = eta$0$2$1;
            }
        };
        return tile.mapDouble((Function1<Object, Object>)localTransform);
    }

    public <T> Tile apply(Tile tile, Histogram<T> targetHistogram) {
        return this.apply(tile, StreamingHistogram$.MODULE$.fromTile(tile, 131072), targetHistogram);
    }

    public <T1, T2> MultibandTile apply(MultibandTile tile, Seq<Histogram<T1>> sourceHistograms, Seq<Histogram<T2>> targetHistograms) {
        return MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)((TraversableLike)tile.bands().zip((GenIterable)sourceHistograms.zip(targetHistograms, Seq$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tile apply(Tuple2<Tile, Tuple2<Histogram<T1>, Histogram<T2>>> x0$1) {
                if (x0$1 != null && x0$1._2() != null) {
                    return HistogramMatching$.MODULE$.apply((Tile)x0$1._1(), (Histogram)((Tuple2)x0$1._2())._1(), (Histogram)((Tuple2)x0$1._2())._2());
                }
                throw new MatchError(x0$1);
            }
        }, Vector$.MODULE$.canBuildFrom())));
    }

    public <T> MultibandTile apply(MultibandTile tile, Seq<Histogram<T>> targetHistograms) {
        return MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)((TraversableLike)tile.bands().zip(targetHistograms, Vector$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tile apply(Tuple2<Tile, Histogram<T>> x0$2) {
                if (x0$2 != null) {
                    return HistogramMatching$.MODULE$.apply((Tile)x0$2._1(), StreamingHistogram$.MODULE$.fromTile((Tile)x0$2._1(), 131072), (Histogram)x0$2._2());
                }
                throw new MatchError(x0$2);
            }
        }, Vector$.MODULE$.canBuildFrom())));
    }

    private HistogramMatching$() {
        MODULE$ = this;
        this.geotrellis$raster$matching$HistogramMatching$$cmp = new HistogramMatching.BucketComparator();
    }
}

