/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.zonal;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ZonalPercentage$ {
    public static final ZonalPercentage$ MODULE$;

    static {
        new ZonalPercentage$();
    }

    public Tile apply(Tile r, Tile zones) {
        Map zonesToValueCounts = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map zoneTotals = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(r.cols(), r.rows());
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(sp2._1$mcI$sp(), sp2._2$mcI$sp());
        int cols = sp3._1$mcI$sp();
        int rows = sp3._2$mcI$sp();
        if (r.cols() != zones.cols() || r.rows() != zones.rows()) {
            throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The zone raster is not the same dimensions as the data raster."})).s((Seq)Nil$.MODULE$));
        }
        for (int index$macro$616 = 0; index$macro$616 < rows; ++index$macro$616) {
            for (int index$macro$615 = 0; index$macro$615 < cols; ++index$macro$615) {
                int value = r.get(index$macro$615, index$macro$616);
                int zone = zones.get(index$macro$615, index$macro$616);
                if (!zonesToValueCounts.contains((Object)BoxesRunTime.boxToInteger((int)zone))) {
                    zonesToValueCounts.update((Object)BoxesRunTime.boxToInteger((int)zone), (Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
                    zoneTotals.update((Object)BoxesRunTime.boxToInteger((int)zone), (Object)BoxesRunTime.boxToInteger((int)0));
                }
                zoneTotals.update((Object)BoxesRunTime.boxToInteger((int)zone), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)zoneTotals.apply((Object)BoxesRunTime.boxToInteger((int)zone))) + 1)));
                Map valueCounts = (Map)zonesToValueCounts.apply((Object)BoxesRunTime.boxToInteger((int)zone));
                if (!valueCounts.contains((Object)BoxesRunTime.boxToInteger((int)value))) {
                    valueCounts.update((Object)BoxesRunTime.boxToInteger((int)value), (Object)BoxesRunTime.boxToInteger((int)0));
                }
                valueCounts.update((Object)BoxesRunTime.boxToInteger((int)value), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)valueCounts.apply((Object)BoxesRunTime.boxToInteger((int)value))) + 1)));
            }
        }
        IntArrayTile tile = IntArrayTile$.MODULE$.empty(cols, rows);
        for (int index$macro$618 = 0; index$macro$618 < rows; ++index$macro$618) {
            for (int index$macro$617 = 0; index$macro$617 < cols; ++index$macro$617) {
                int v = r.get(index$macro$617, index$macro$618);
                int z = zones.get(index$macro$617, index$macro$618);
                int count = BoxesRunTime.unboxToInt((Object)((MapLike)zonesToValueCounts.apply((Object)BoxesRunTime.boxToInteger((int)z))).apply((Object)BoxesRunTime.boxToInteger((int)v)));
                int total = BoxesRunTime.unboxToInt((Object)zoneTotals.apply((Object)BoxesRunTime.boxToInteger((int)z)));
                tile.set(index$macro$617, index$macro$618, (int)package$.MODULE$.round((double)count / (double)total * (double)100));
            }
        }
        return tile;
    }

    private ZonalPercentage$() {
        MODULE$ = this;
    }
}

