/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.local;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.runtime.RichDouble$;

public final class Variance$
implements Serializable {
    public static final Variance$ MODULE$;

    static {
        new Variance$();
    }

    public Tile apply(Traversable<Tile> rs) {
        return this.apply((Seq<Tile>)rs.toSeq());
    }

    public Tile apply(Seq<Tile> rs, Predef.DummyImplicit d) {
        return this.apply(rs);
    }

    public Tile apply(Seq<Tile> rs) {
        package$.MODULE$.TraversableTileExtensions((Traversable<Tile>)rs).assertEqualDimensions();
        int layerCount = rs.length();
        if (layerCount == 0) {
            throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't compute variance of empty sequence."})).s((Seq)Nil$.MODULE$));
        }
        DataType newCellType = (DataType)((TraversableOnce)rs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Tile x$1) {
                return x$1.cellType();
            }
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(DataType x$2, DataType x$3) {
                return x$2.union(x$3);
            }
        });
        Tuple2<Object, Object> tuple2 = ((Grid)rs.apply(0)).dimensions();
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tuple2._1$mcI$sp(), tuple2._2$mcI$sp());
            int cols = sp2._1$mcI$sp();
            int rows = sp2._2$mcI$sp();
            MutableArrayTile tile = ArrayTile$.MODULE$.alloc(newCellType, cols, rows);
            for (int index$macro$608 = 0; index$macro$608 < rows; ++index$macro$608) {
                for (int index$macro$607 = 0; index$macro$607 < cols; ++index$macro$607) {
                    int count = 0;
                    double mean = 0.0;
                    double m2 = 0.0;
                    for (int index$macro$606 = 0; index$macro$606 < layerCount; ++index$macro$606) {
                        double v = ((Tile)rs.apply(index$macro$606)).getDouble(index$macro$607, index$macro$608);
                        if (Double.isNaN(v)) continue;
                        double delta = v - mean;
                        m2 += delta * (v - (mean += delta / (double)(++count)));
                    }
                    if (newCellType.isFloatingPoint()) {
                        if (count > 1) {
                            tile.setDouble(index$macro$607, index$macro$608, m2 / (double)(count - 1));
                            continue;
                        }
                        tile.setDouble(index$macro$607, index$macro$608, Double.NaN);
                        continue;
                    }
                    if (count > 1) {
                        double d = m2 / (double)(count - 1);
                        Predef$ predef$ = Predef$.MODULE$;
                        tile.set(index$macro$607, index$macro$608, (int)RichDouble$.MODULE$.round$extension(d));
                        continue;
                    }
                    tile.set(index$macro$607, index$macro$608, Integer.MIN_VALUE);
                }
            }
            return tile;
        }
        throw new MatchError(tuple2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Variance$() {
        MODULE$ = this;
    }
}

