/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.local;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;

public final class Mean$
implements Serializable {
    public static final Mean$ MODULE$;

    static {
        new Mean$();
    }

    public Tile apply(Traversable<Tile> rs) {
        return this.apply((Seq<Tile>)rs.toSeq());
    }

    public Tile apply(Seq<Tile> rs, Predef.DummyImplicit d) {
        return this.apply(rs);
    }

    public Tile apply(Seq<Tile> rs) {
        package$.MODULE$.TraversableTileExtensions((Traversable<Tile>)rs).assertEqualDimensions();
        int layerCount = rs.length();
        if (layerCount == 0) {
            throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't compute mean of empty sequence"})).s((Seq)Nil$.MODULE$));
        }
        DataType newCellType = (DataType)((TraversableOnce)rs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Tile x$1) {
                return x$1.cellType();
            }
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(DataType x$2, DataType x$3) {
                return x$2.union(x$3);
            }
        });
        Tuple2<Object, Object> tuple2 = ((Grid)rs.apply(0)).dimensions();
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tuple2._1$mcI$sp(), tuple2._2$mcI$sp());
            int cols = sp2._1$mcI$sp();
            int rows = sp2._2$mcI$sp();
            MutableArrayTile tile = ArrayTile$.MODULE$.alloc(newCellType, cols, rows);
            if (newCellType.isFloatingPoint()) {
                for (int index$macro$598 = 0; index$macro$598 < rows; ++index$macro$598) {
                    for (int index$macro$597 = 0; index$macro$597 < cols; ++index$macro$597) {
                        int count = 0;
                        double sum = 0.0;
                        for (int index$macro$596 = 0; index$macro$596 < layerCount; ++index$macro$596) {
                            double v = ((Tile)rs.apply(index$macro$596)).getDouble(index$macro$597, index$macro$598);
                            if (Double.isNaN(v)) continue;
                            ++count;
                            sum += v;
                        }
                        if (count > 0) {
                            tile.setDouble(index$macro$597, index$macro$598, sum / (double)count);
                            continue;
                        }
                        tile.setDouble(index$macro$597, index$macro$598, Double.NaN);
                    }
                }
            } else {
                for (int index$macro$601 = 0; index$macro$601 < rows; ++index$macro$601) {
                    for (int index$macro$600 = 0; index$macro$600 < cols; ++index$macro$600) {
                        int count = 0;
                        int sum = 0;
                        for (int index$macro$599 = 0; index$macro$599 < layerCount; ++index$macro$599) {
                            int v = ((Tile)rs.apply(index$macro$599)).get(index$macro$600, index$macro$601);
                            if (v == Integer.MIN_VALUE) continue;
                            ++count;
                            sum += v;
                        }
                        if (count > 0) {
                            tile.set(index$macro$600, index$macro$601, sum / count);
                            continue;
                        }
                        tile.set(index$macro$600, index$macro$601, Integer.MIN_VALUE);
                    }
                }
            }
            return tile;
        }
        throw new MatchError(tuple2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Mean$() {
        MODULE$ = this;
    }
}

