/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal.hillshade;

import geotrellis.raster.CellSize;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.FocalCalculation;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import geotrellis.raster.mapalgebra.focal.TargetCell$Data$;
import geotrellis.raster.mapalgebra.focal.TargetCell$NoData$;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePoint;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePointCalculation$;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e!B\u0001\u0003\u0003\u0003i!aF*ve\u001a\f7-\u001a)pS:$8)\u00197dk2\fG/[8o\u0015\t\u0019A!A\u0005iS2d7\u000f[1eK*\u0011QAB\u0001\u0006M>\u001c\u0017\r\u001c\u0006\u0003\u000f!\t!\"\\1qC2<WM\u0019:b\u0015\tI!\"\u0001\u0004sCN$XM\u001d\u0006\u0002\u0017\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001U\u0011a\"F\n\u0003\u0001=\u00012\u0001E\t\u0014\u001b\u0005!\u0011B\u0001\n\u0005\u0005A1unY1m\u0007\u0006d7-\u001e7bi&|g\u000e\u0005\u0002\u0015+1\u0001A!\u0002\f\u0001\u0005\u00049\"!\u0001+\u0012\u0005aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"a\u0002(pi\"Lgn\u001a\t\u00033}I!\u0001\t\u000e\u0003\u0007\u0005s\u0017\u0010C\u0005#\u0001\t\u0005\t\u0015!\u0003$O\u0005\t!\u000f\u0005\u0002%K5\t\u0001\"\u0003\u0002'\u0011\t!A+\u001b7f\u0013\t\u0011\u0013\u0003\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\u0005q\u0007C\u0001\t,\u0013\taCA\u0001\u0007OK&<\u0007NY8sQ>|G\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u00031\tg.\u00197zg&\u001c\u0018I]3b!\rI\u0002GM\u0005\u0003ci\u0011aa\u00149uS>t\u0007C\u0001\u00134\u0013\t!\u0004B\u0001\u0006He&$'i\\;oIND\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\tG\u0016dGnU5{KV\t\u0001\b\u0005\u0002%s%\u0011!\b\u0003\u0002\t\u0007\u0016dGnU5{K\"AA\b\u0001B\u0001B\u0003%\u0001(A\u0005dK2d7+\u001b>fA!Ia\b\u0001B\u0001B\u0003%qHQ\u0001\u0007i\u0006\u0014x-\u001a;\u0011\u0005A\u0001\u0015BA!\u0005\u0005)!\u0016M]4fi\u000e+G\u000e\\\u0005\u0003}EAQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtDC\u0002$I\u0013*[E\nE\u0002H\u0001Mi\u0011A\u0001\u0005\u0006E\r\u0003\ra\t\u0005\u0006S\r\u0003\rA\u000b\u0005\u0006]\r\u0003\ra\f\u0005\u0006m\r\u0003\r\u0001\u000f\u0005\b}\r\u0003\n\u00111\u0001@\u0011\u001dq\u0005\u00011A\u0005\u0002=\u000bQ\u0001\\1tif+\u0012\u0001\u0015\t\u00033EK!A\u0015\u000e\u0003\u0007%sG\u000fC\u0004U\u0001\u0001\u0007I\u0011A+\u0002\u00131\f7\u000f^-`I\u0015\fHC\u0001,Z!\tIr+\u0003\u0002Y5\t!QK\\5u\u0011\u001dQ6+!AA\u0002A\u000b1\u0001\u001f\u00132\u0011\u0019a\u0006\u0001)Q\u0005!\u00061A.Y:u3\u0002BqA\u0018\u0001A\u0002\u0013\u0005q,A\u0005dK2dw+\u001b3uQV\t\u0001\r\u0005\u0002\u001aC&\u0011!M\u0007\u0002\u0007\t>,(\r\\3\t\u000f\u0011\u0004\u0001\u0019!C\u0001K\u0006i1-\u001a7m/&$G\u000f[0%KF$\"A\u00164\t\u000fi\u001b\u0017\u0011!a\u0001A\"1\u0001\u000e\u0001Q!\n\u0001\f!bY3mY^KG\r\u001e5!\u0011\u001dQ\u0007\u00011A\u0005\u0002}\u000b!bY3mY\"+\u0017n\u001a5u\u0011\u001da\u0007\u00011A\u0005\u00025\fabY3mY\"+\u0017n\u001a5u?\u0012*\u0017\u000f\u0006\u0002W]\"9!l[A\u0001\u0002\u0004\u0001\u0007B\u00029\u0001A\u0003&\u0001-A\u0006dK2d\u0007*Z5hQR\u0004\u0003b\u0002:\u0001\u0001\u0004%\ta]\u0001\u0005o\u0016\u001cH/F\u0001u!\rIR\u000fY\u0005\u0003mj\u0011Q!\u0011:sCfDq\u0001\u001f\u0001A\u0002\u0013\u0005\u00110\u0001\u0005xKN$x\fJ3r)\t1&\u0010C\u0004[o\u0006\u0005\t\u0019\u0001;\t\rq\u0004\u0001\u0015)\u0003u\u0003\u00159Xm\u001d;!\u0011\u001dq\b\u00011A\u0005\u0002M\fAAY1tK\"I\u0011\u0011\u0001\u0001A\u0002\u0013\u0005\u00111A\u0001\tE\u0006\u001cXm\u0018\u0013fcR\u0019a+!\u0002\t\u000fi{\u0018\u0011!a\u0001i\"9\u0011\u0011\u0002\u0001!B\u0013!\u0018!\u00022bg\u0016\u0004\u0003\u0002CA\u0007\u0001\u0001\u0007I\u0011A:\u0002\t\u0015\f7\u000f\u001e\u0005\n\u0003#\u0001\u0001\u0019!C\u0001\u0003'\t\u0001\"Z1ti~#S-\u001d\u000b\u0004-\u0006U\u0001\u0002\u0003.\u0002\u0010\u0005\u0005\t\u0019\u0001;\t\u000f\u0005e\u0001\u0001)Q\u0005i\u0006)Q-Y:uA!I\u0011Q\u0004\u0001C\u0002\u0013\u0005\u0011qD\u0001\u0002gV\u0011\u0011\u0011\u0005\t\u0004\u000f\u0006\r\u0012bAA\u0013\u0005\ta1+\u001e:gC\u000e,\u0007k\\5oi\"A\u0011\u0011\u0006\u0001!\u0002\u0013\t\t#\u0001\u0002tA!9\u0011Q\u0006\u0001\u0007\u0002\u0005=\u0012\u0001C:fiZ\u000bG.^3\u0015\u000fY\u000b\t$!\u000e\u0002:!9\u00111GA\u0016\u0001\u0004\u0001\u0016!\u0001=\t\u000f\u0005]\u00121\u0006a\u0001!\u0006\t\u0011\u0010\u0003\u0005\u0002\u001e\u0005-\u0002\u0019AA\u0011\u0011%\ti\u0003\u0001b\u0001\n\u0003\ti$\u0006\u0002\u0002@A9\u0011$!\u0011a!B3\u0016bAA\"5\tIa)\u001e8di&|gn\r\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002@\u0005I1/\u001a;WC2,X\r\t\u0005\b\u0003\u0017\u0002A\u0011AA'\u0003%iwN^3SS\u001eDG\u000fF\u0001W\u0011\u001d\t\t\u0006\u0001C\t\u0003\u001b\n1bY1mGN+(OZ1dK\"9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013aB3yK\u000e,H/\u001a\u000b\u0002'\u001dI\u00111\f\u0002\u0002\u0002#\u0005\u0011QL\u0001\u0018'V\u0014h-Y2f!>Lg\u000e^\"bY\u000e,H.\u0019;j_:\u00042aRA0\r!\t!!!A\t\u0002\u0005\u00054\u0003BA0\u0003G\u00022!GA3\u0013\r\t9G\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0011\u000by\u0006\"\u0001\u0002lQ\u0011\u0011Q\f\u0005\u000b\u0003_\ny&%A\u0005\u0002\u0005E\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0003\u0002t\u0005%UCAA;U\ry\u0014qO\u0016\u0003\u0003s\u0002B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0011\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\b\u0006u$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121a#!\u001cC\u0002]\u0001")
public abstract class SurfacePointCalculation<T>
extends FocalCalculation<T> {
    private final CellSize cellSize;
    private int lastY;
    private double cellWidth;
    private double cellHeight;
    private double[] west;
    private double[] base;
    private double[] east;
    private final SurfacePoint s;
    private final Function3<Object, Object, Object, BoxedUnit> setValue;

    public static <T> TargetCell $lessinit$greater$default$5() {
        return SurfacePointCalculation$.MODULE$.$lessinit$greater$default$5();
    }

    public CellSize cellSize() {
        return this.cellSize;
    }

    public int lastY() {
        return this.lastY;
    }

    public void lastY_$eq(int x$1) {
        this.lastY = x$1;
    }

    public double cellWidth() {
        return this.cellWidth;
    }

    public void cellWidth_$eq(double x$1) {
        this.cellWidth = x$1;
    }

    public double cellHeight() {
        return this.cellHeight;
    }

    public void cellHeight_$eq(double x$1) {
        this.cellHeight = x$1;
    }

    public double[] west() {
        return this.west;
    }

    public void west_$eq(double[] x$1) {
        this.west = x$1;
    }

    public double[] base() {
        return this.base;
    }

    public void base_$eq(double[] x$1) {
        this.base = x$1;
    }

    public double[] east() {
        return this.east;
    }

    public void east_$eq(double[] x$1) {
        this.east = x$1;
    }

    public SurfacePoint s() {
        return this.s;
    }

    public abstract void setValue(int var1, int var2, SurfacePoint var3);

    public Function3<Object, Object, Object, BoxedUnit> setValue() {
        return this.setValue;
    }

    public void moveRight() {
        double[] tmp = this.west();
        this.west_$eq(this.base());
        this.base_$eq(this.east());
        this.east_$eq(tmp);
    }

    public void calcSurface() {
        if (Double.isNaN(this.base()[1])) {
            this.s().dz$divdx_$eq(Double.NaN);
            this.s().dz$divdy_$eq(Double.NaN);
        } else {
            double neValue = Double.isNaN(this.east()[0]) ? this.base()[1] : this.east()[0];
            double eValue = Double.isNaN(this.east()[1]) ? this.base()[1] : this.east()[1];
            double seValue = Double.isNaN(this.east()[2]) ? this.base()[1] : this.east()[2];
            double nValue = Double.isNaN(this.base()[0]) ? this.base()[1] : this.base()[0];
            double sValue = Double.isNaN(this.base()[2]) ? this.base()[1] : this.base()[2];
            double nwValue = Double.isNaN(this.west()[0]) ? this.base()[1] : this.west()[0];
            double wValue = Double.isNaN(this.west()[1]) ? this.base()[1] : this.west()[1];
            double swValue = Double.isNaN(this.west()[2]) ? this.base()[1] : this.west()[2];
            this.s().dz$divdx_$eq((neValue + (double)2 * eValue + seValue - nwValue - (double)2 * wValue - swValue) / ((double)8 * this.cellWidth()));
            this.s().dz$divdy_$eq((swValue + (double)2 * sValue + seValue - nwValue - (double)2 * nValue - neValue) / ((double)8 * this.cellHeight()));
        }
    }

    @Override
    public T execute() {
        int row;
        int col;
        int colMin = this.bounds().colMin();
        int colMax = this.bounds().colMax();
        int rowMin = this.bounds().rowMin();
        int rowMax = this.bounds().rowMax();
        int colBorderMax = super.r().cols() - 1;
        int rowBorderMax = super.r().rows() - 1;
        this.cellWidth_$eq(this.cellSize().width());
        this.cellHeight_$eq(this.cellSize().height());
        if (colBorderMax < 3 || rowBorderMax < 3) {
            throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tile is too small to get surface values. (", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)colBorderMax), BoxesRunTime.boxToInteger((int)rowBorderMax)})));
        }
        double focalValue = super.r().getDouble(colMin, rowMin);
        this.west()[0] = this.getValSafe$1(colMin - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.west()[1] = this.getValSafe$1(colMin - 1, rowMin, focalValue, colBorderMax, rowBorderMax);
        this.west()[2] = this.getValSafe$1(colMin - 1, rowMin + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = this.getValSafe$1(colMin, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[1] = focalValue;
        this.base()[2] = super.r().getDouble(colMin, rowMin + 1);
        this.east()[0] = this.getValSafe$1(colMin + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = super.r().getDouble(colMin + 1, rowMin);
        this.east()[2] = super.r().getDouble(colMin + 1, rowMin + 1);
        this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0));
        for (col = colMin + 1; col < colMax; ++col) {
            this.moveRight();
            focalValue = super.r().getDouble(col, rowMin);
            this.west()[0] = this.getValSafe$1(col - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[0] = this.getValSafe$1(col, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[0] = this.getValSafe$1(col + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[1] = super.r().getDouble(col + 1, rowMin);
            this.east()[2] = super.r().getDouble(col + 1, rowMin + 1);
            this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)(col - colMin)), (Object)BoxesRunTime.boxToInteger((int)0));
        }
        this.moveRight();
        focalValue = super.r().getDouble(col, rowMin);
        this.west()[0] = this.getValSafe$1(col - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = this.getValSafe$1(col, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = this.getValSafe$1(col + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = this.getValSafe$1(col + 1, rowMin, focalValue, colBorderMax, rowBorderMax);
        this.east()[2] = this.getValSafe$1(col + 1, rowMin + 1, focalValue, colBorderMax, rowBorderMax);
        this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)(col - colMin)), (Object)BoxesRunTime.boxToInteger((int)0));
        for (row = rowMin + 1; row < rowMax; ++row) {
            focalValue = super.r().getDouble(colMin, row);
            this.west()[0] = this.getValSafe$1(colMin - 1, row - 1, focalValue, colBorderMax, rowBorderMax);
            this.west()[1] = this.getValSafe$1(colMin - 1, row, focalValue, colBorderMax, rowBorderMax);
            this.west()[2] = this.getValSafe$1(colMin - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[0] = super.r().getDouble(colMin, row - 1);
            this.base()[1] = focalValue;
            this.base()[2] = super.r().getDouble(colMin, row + 1);
            this.east()[0] = super.r().getDouble(colMin + 1, row - 1);
            this.east()[1] = super.r().getDouble(colMin + 1, row);
            this.east()[2] = super.r().getDouble(colMin + 1, row + 1);
            this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)(row - rowMin)));
            for (col = colMin + 1; col < colMax; ++col) {
                this.moveRight();
                this.east()[0] = super.r().getDouble(col + 1, row - 1);
                this.east()[1] = super.r().getDouble(col + 1, row);
                this.east()[2] = super.r().getDouble(col + 1, row + 1);
                this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)(col - colMin)), (Object)BoxesRunTime.boxToInteger((int)(row - rowMin)));
            }
            this.moveRight();
            focalValue = super.r().getDouble(col, row);
            this.east()[0] = this.getValSafe$1(col + 1, row - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[1] = this.getValSafe$1(col + 1, row, focalValue, colBorderMax, rowBorderMax);
            this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)(col - colMin)), (Object)BoxesRunTime.boxToInteger((int)(row - rowMin)));
        }
        focalValue = super.r().getDouble(colMin, row);
        this.west()[0] = this.getValSafe$1(colMin - 1, row - 1, focalValue, colBorderMax, rowBorderMax);
        this.west()[1] = this.getValSafe$1(colMin - 1, row, focalValue, colBorderMax, rowBorderMax);
        this.west()[2] = this.getValSafe$1(colMin - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = super.r().getDouble(colMin, row - 1);
        this.base()[1] = focalValue;
        this.base()[2] = this.getValSafe$1(colMin, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = super.r().getDouble(colMin + 1, row - 1);
        this.east()[1] = super.r().getDouble(colMin + 1, row);
        this.east()[2] = this.getValSafe$1(colMin + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)(row - rowMin)));
        for (col = colMin + 1; col < colMax; ++col) {
            this.moveRight();
            focalValue = super.r().getDouble(col, row);
            this.west()[2] = this.getValSafe$1(col - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[2] = this.getValSafe$1(col, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[0] = super.r().getDouble(col + 1, row - 1);
            this.east()[1] = super.r().getDouble(col + 1, row);
            this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)(col - colMin)), (Object)BoxesRunTime.boxToInteger((int)(row - rowMin)));
        }
        this.moveRight();
        focalValue = super.r().getDouble(col, row);
        this.west()[2] = this.getValSafe$1(col - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[2] = this.getValSafe$1(col, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = this.getValSafe$1(col + 1, row - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = this.getValSafe$1(col + 1, row, focalValue, colBorderMax, rowBorderMax);
        this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.setValue().apply((Object)BoxesRunTime.boxToDouble((double)focalValue), (Object)BoxesRunTime.boxToInteger((int)(col - colMin)), (Object)BoxesRunTime.boxToInteger((int)(row - rowMin)));
        return this.result();
    }

    private final double getValSafe$1(int col, int row, double focalVal, int colBorderMax$1, int rowBorderMax$1) {
        return col < 0 || colBorderMax$1 < col || row < 0 || rowBorderMax$1 < row ? focalVal : super.r().getDouble(col, row);
    }

    public SurfacePointCalculation(Tile r, Neighborhood n, Option<GridBounds> analysisArea, CellSize cellSize, TargetCell target) {
        TargetCell targetCell;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        this.cellSize = cellSize;
                        super(r, n, analysisArea, target);
                        this.lastY = -1;
                        this.cellWidth = 0.0;
                        this.cellHeight = 0.0;
                        this.west = new double[3];
                        this.base = new double[3];
                        this.east = new double[3];
                        this.s = new SurfacePoint();
                        targetCell = super.target();
                        if (!TargetCell$All$.MODULE$.equals(targetCell)) break block2;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ SurfacePointCalculation $outer;

                            public final void apply(double x$1, int x, int y) {
                                this.$outer.calcSurface();
                                this.$outer.setValue(x, y, this.$outer.s());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!TargetCell$Data$.MODULE$.equals(targetCell)) break block4;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SurfacePointCalculation $outer;

                        public final void apply(double z, int x, int y) {
                            if (!Double.isNaN(z)) {
                                this.$outer.calcSurface();
                                this.$outer.setValue(x, y, this.$outer.s());
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!TargetCell$NoData$.MODULE$.equals(targetCell)) break block5;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SurfacePointCalculation $outer;

                    public final void apply(double z, int x, int y) {
                        if (Double.isNaN(z)) {
                            this.$outer.calcSurface();
                            this.$outer.setValue(x, y, this.$outer.s());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            this.setValue = object;
            return;
        }
        throw new MatchError((Object)targetCell);
    }
}

