/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal.hillshade;

import geotrellis.raster.CellSize;
import geotrellis.raster.GridBounds;
import geotrellis.raster.ShortArrayTile;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.Angles$;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.ShortArrayTileResult;
import geotrellis.raster.mapalgebra.focal.ShortArrayTileResult$class;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePoint;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePointCalculation;
import scala.Function2;
import scala.Function4;
import scala.Option;
import scala.Serializable;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public final class Hillshade$ {
    public static final Hillshade$ MODULE$;

    static {
        new Hillshade$();
    }

    public Tile apply(Tile tile, Neighborhood n, Option<GridBounds> bounds, CellSize cs, double az, double al, double z, TargetCell target) {
        return (Tile)((SurfacePointCalculation)((Object)new ShortArrayTileResult(tile, n, bounds, cs, az, al, z, target){
            private final double azimuth;
            private final double zenith;
            private final double zFactor;
            private final double cosZ;
            private final double sinZ;
            private final double cosAz;
            private final double sinAz;
            private final int cols;
            private final int rows;
            private final ShortArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public ShortArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$ShortArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ShortArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ShortArrayTileResult$_setter_$resultTile_$eq(ShortArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ShortArrayTileResult$_setter_$copyOriginalValue_$eq(Function4 x$1) {
                this.copyOriginalValue = x$1;
            }

            public ShortArrayTile result() {
                return ShortArrayTileResult$class.result(this);
            }

            public double azimuth() {
                return this.azimuth;
            }

            public double zenith() {
                return this.zenith;
            }

            public double zFactor() {
                return this.zFactor;
            }

            public double cosZ() {
                return this.cosZ;
            }

            public double sinZ() {
                return this.sinZ;
            }

            public double cosAz() {
                return this.cosAz;
            }

            public double sinAz() {
                return this.sinAz;
            }

            public void setValue(int x, int y, SurfacePoint s) {
                s.slope(this.zFactor());
                s.aspect();
                double c = this.cosAz() * s.cosAspect() + this.sinAz() * s.sinAspect();
                double v = this.cosZ() * s.cosSlope() + this.sinZ() * s.sinSlope() * c;
                this.resultTile().set(x, y, (int)package$.MODULE$.round(127.0 * package$.MODULE$.max(0.0, v)));
            }
            {
                ShortArrayTileResult$class.$init$(this);
                double d = 90.0 - az$1;
                Angles$ angles$ = Angles$.MODULE$;
                this.azimuth = d * Math.PI / 180.0;
                double d2 = 90.0 - al$1;
                Angles$ angles$2 = Angles$.MODULE$;
                this.zenith = d2 * Math.PI / 180.0;
                this.zFactor = z$1;
                this.cosZ = package$.MODULE$.cos(this.zenith());
                this.sinZ = package$.MODULE$.sin(this.zenith());
                this.cosAz = package$.MODULE$.cos(this.azimuth());
                this.sinAz = package$.MODULE$.sin(this.azimuth());
            }
        })).execute();
    }

    public TargetCell apply$default$8() {
        return TargetCell$All$.MODULE$;
    }

    public Tile indirect(Tile aspect, Tile slope, double azimuth, double altitude) {
        double d = 90.0 - azimuth;
        Angles$ angles$ = Angles$.MODULE$;
        double az = d * Math.PI / 180.0;
        double d2 = 90.0 - altitude;
        Angles$ angles$2 = Angles$.MODULE$;
        double ze = d2 * Math.PI / 180.0;
        double cosZe = package$.MODULE$.cos(ze);
        double sinZe = package$.MODULE$.sin(ze);
        Tile hr = aspect.combineDouble(slope, (Function2<Object, Object, Object>)new Serializable(az, cosZe, sinZe){
            public static final long serialVersionUID = 0L;
            private final double az$2;
            private final double cosZe$1;
            private final double sinZe$1;

            public final double apply(double aspectValue, double slopeValue) {
                return this.apply$mcDDD$sp(aspectValue, slopeValue);
            }

            public double apply$mcDDD$sp(double aspectValue, double slopeValue) {
                Angles$ angles$ = Angles$.MODULE$;
                double slopeRads = slopeValue * Math.PI / 180.0;
                Angles$ angles$2 = Angles$.MODULE$;
                double aspectRads = aspectValue * Math.PI / 180.0;
                double v = this.cosZe$1 * package$.MODULE$.cos(slopeRads) + this.sinZe$1 * package$.MODULE$.sin(slopeRads) * package$.MODULE$.cos(this.az$2 - aspectRads);
                return package$.MODULE$.round(127.0 * package$.MODULE$.max(0.0, v));
            }
            {
                this.az$2 = az$2;
                this.cosZe$1 = cosZe$1;
                this.sinZe$1 = sinZe$1;
            }
        });
        return hr.convert(ShortConstantNoDataCellType$.MODULE$);
    }

    private Hillshade$() {
        MODULE$ = this;
    }
}

