/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.CompositeTile;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;

public final class TileWithNeighbors$ {
    public static final TileWithNeighbors$ MODULE$;

    static {
        new TileWithNeighbors$();
    }

    public Tuple2<Tile, GridBounds> apply(Tile r, Seq<Option<Tile>> neighbors) {
        Tuple2 tuple2;
        if (neighbors.isEmpty()) {
            tuple2 = new Tuple2((Object)r, (Object)new GridBounds(0, 0, r.cols() - 1, r.rows() - 1));
        } else {
            Option nw = (Option)neighbors.apply(7);
            Option n = (Option)neighbors.apply(0);
            Option ne = (Option)neighbors.apply(1);
            Option w = (Option)neighbors.apply(6);
            Option e = (Option)neighbors.apply(2);
            Option sw = (Option)neighbors.apply(5);
            Option s = (Option)neighbors.apply(4);
            Option se = (Option)neighbors.apply(3);
            int westCol = ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{nw, w, sw})).flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tile> apply(Option<Tile> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            })).isEmpty() ? 0 : 1;
            int eastCol = ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{ne, e, se})).flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tile> apply(Option<Tile> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            })).isEmpty() ? 0 : 1;
            int northRow = ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{nw, n, ne})).flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tile> apply(Option<Tile> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            })).isEmpty() ? 0 : 1;
            int southRow = ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{sw, s, se})).flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tile> apply(Option<Tile> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            })).isEmpty() ? 0 : 1;
            int tileCols = 1 + westCol + eastCol;
            int tileRows = 1 + northRow + southRow;
            TileLayout tileLayout = new TileLayout(tileCols, tileRows, r.cols(), r.rows());
            int colMin = westCol == 0 ? 0 : ((Grid)((Option)neighbors.apply(6)).get()).cols();
            int colMax = colMin + r.cols() - 1;
            int rowMin = northRow == 0 ? 0 : ((Grid)((Option)neighbors.apply(0)).get()).rows();
            int rowMax = rowMin + r.rows() - 1;
            CompositeTile tiledTile = new CompositeTile((Seq<Tile>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{(Option)neighbors.apply(7), (Option)neighbors.apply(0), (Option)neighbors.apply(1), (Option)neighbors.apply(6), new Some((Object)r), (Option)neighbors.apply(2), (Option)neighbors.apply(5), (Option)neighbors.apply(4), (Option)neighbors.apply(3)})).flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tile> apply(Option<Tile> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            })), tileLayout);
            tuple2 = new Tuple2((Object)tiledTile, (Object)new GridBounds(colMin, rowMin, colMax, rowMax));
        }
        return tuple2;
    }

    private TileWithNeighbors$() {
        MODULE$ = this;
    }
}

