/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.FastMapHistogram;
import geotrellis.raster.histogram.FastMapHistogram$;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.CursorCalculation;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult$class;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import geotrellis.raster.mapalgebra.focal.TileMoransICalculation$;
import geotrellis.raster.summary.Statistics;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class TileMoransICalculation$ {
    public static final TileMoransICalculation$ MODULE$;

    static {
        new TileMoransICalculation$();
    }

    public Tile apply(Tile tile, Neighborhood n, Option<GridBounds> bounds, TargetCell target) {
        return (Tile)((CursorCalculation)((Object)new DoubleArrayTileResult(tile, n, (Option)bounds, target){
            private double mean;
            private double stddev$up2;
            private final FastMapHistogram h;
            private final Option<Statistics<Object>> stats;
            private final /* synthetic */ Tuple2 x$1;
            private final double m;
            private final double s;
            private final int cols;
            private final int rows;
            private final DoubleArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public DoubleArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$resultTile_$eq(DoubleArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$copyOriginalValue_$eq(Function4 x$1) {
                this.copyOriginalValue = x$1;
            }

            public DoubleArrayTile result() {
                return DoubleArrayTileResult$class.result(this);
            }

            public double mean() {
                return this.mean;
            }

            public void mean_$eq(double x$1) {
                this.mean = x$1;
            }

            public double stddev$up2() {
                return this.stddev$up2;
            }

            public void stddev$up2_$eq(double x$1) {
                this.stddev$up2 = x$1;
            }

            public FastMapHistogram h() {
                return this.h;
            }

            public Option<Statistics<Object>> stats() {
                return this.stats;
            }

            public double m() {
                return this.m;
            }

            public double s() {
                return this.s;
            }

            public void calc(Tile r, Cursor cursor) {
                DoubleRef z = DoubleRef.create((double)0.0);
                IntRef w = IntRef.create((int)0);
                DoubleRef base = DoubleRef.create((double)0.0);
                cursor.allCells().foreach((Function2<Object, Object, BoxedUnit>)new Serializable(this, r, cursor, z, w, base){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final Tile r$1;
                    private final Cursor cursor$1;
                    private final DoubleRef z$1;
                    private final IntRef w$1;
                    private final DoubleRef base$1;

                    public final void apply(int x, int y) {
                        this.apply$mcVII$sp(x, y);
                    }

                    public void apply$mcVII$sp(int x, int y) {
                        if (x == this.cursor$1.col() && y == this.cursor$1.row()) {
                            this.base$1.elem = this.r$1.getDouble(x, y) - this.$outer.mean();
                        } else {
                            this.z$1.elem += this.r$1.getDouble(x, y) - this.$outer.mean();
                            ++this.w$1.elem;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                        this.cursor$1 = cursor$1;
                        this.z$1 = z$1;
                        this.w$1 = w$1;
                        this.base$1 = base$1;
                    }
                });
                this.resultTile().setDouble(cursor.col(), cursor.row(), base.elem / this.stddev$up2() * z.elem / (double)w.elem);
            }
            {
                DoubleArrayTileResult$class.$init$(this);
                this.mean = 0.0;
                this.stddev$up2 = 0.0;
                this.h = FastMapHistogram$.MODULE$.fromTile(this.r());
                this.stats = this.h().statistics();
                Predef$.MODULE$.require(this.stats().nonEmpty());
                Statistics statistics2 = (Statistics)this.stats().get();
                if (statistics2 != null) {
                    this.x$1 = new Tuple2.mcDD.sp(statistics2.mean(), statistics2.stddev());
                    this.m = this.x$1._1$mcD$sp();
                    this.s = this.x$1._2$mcD$sp();
                    this.mean_$eq(this.m());
                    this.stddev$up2_$eq(this.s() * this.s());
                    return;
                }
                throw new MatchError((Object)statistics2);
            }
        })).execute();
    }

    public TargetCell apply$default$4() {
        return TargetCell$All$.MODULE$;
    }

    private TileMoransICalculation$() {
        MODULE$ = this;
    }
}

