/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileVisitor;
import geotrellis.macros.MacroIterableTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.Kernel;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001-\u0011AbS3s]\u0016d7)\u001e:t_JT!a\u0001\u0003\u0002\u000b\u0019|7-\u00197\u000b\u0005\u00151\u0011AC7ba\u0006dw-\u001a2sC*\u0011q\u0001C\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0019B\u0001\u0001\u0007\u0011-A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u0007\u0007V\u00148o\u001c:\u0011\u0005E!R\"\u0001\n\u000b\u0005MA\u0011AB7bGJ|7/\u0003\u0002\u0016%\t\tR*Y2s_&#XM]1cY\u0016$\u0016\u000e\\3\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0011A\u001d\t\u0003?\u0001j\u0011AB\u0005\u0003C\u0019\u0011A\u0001V5mK\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0004lKJtW\r\u001c\t\u0003\u001b\u0015J!A\n\u0002\u0003\r-+'O\\3m\u0011!A\u0003A!A!\u0002\u0013I\u0013\u0001D1oC2L8/[:Be\u0016\f\u0007CA\u0010+\u0013\tYcA\u0001\u0006He&$'i\\;oINDQ!\f\u0001\u0005\u00029\na\u0001P5oSRtD\u0003B\u00181cI\u0002\"!\u0004\u0001\t\u000bua\u0003\u0019\u0001\u0010\t\u000b\rb\u0003\u0019\u0001\u0013\t\u000b!b\u0003\u0019A\u0015\t\u000fQ\u0002!\u0019!C\u0005k\u0005A1\u000e^5mK\u0006\u0013(/F\u00017!\r9r'O\u0005\u0003qa\u0011Q!\u0011:sCf\u0004\"a\u0006\u001e\n\u0005mB\"aA%oi\"1Q\b\u0001Q\u0001\nY\n\u0011b\u001b;jY\u0016\f%O\u001d\u0011\t\u000f}\u0002!\u0019!C\u0005\u0001\u0006q1\u000e^5mK\u0006\u0013(\u000fR8vE2,W#A!\u0011\u0007]9$\t\u0005\u0002\u0018\u0007&\u0011A\t\u0007\u0002\u0007\t>,(\r\\3\t\r\u0019\u0003\u0001\u0015!\u0003B\u0003=YG/\u001b7f\u0003J\u0014Hi\\;cY\u0016\u0004\u0003b\u0002%\u0001\u0005\u0004%I!S\u0001\u0006W\u000e|Gn]\u000b\u0002s!11\n\u0001Q\u0001\ne\naa[2pYN\u0004\u0003BB'\u0001\u0005\u0013\u0005a*A\tg_J,\u0017m\u00195XSRDw+Z5hQR$\"a\u0014*\u0011\u0005]\u0001\u0016BA)\u0019\u0005\u0011)f.\u001b;\t\u000bMc\u0005\u0019\u0001+\u0002\u0003\u0019\u0004baF+:sez\u0015B\u0001,\u0019\u0005%1UO\\2uS>t7\u0007K\u0002M1\u0006\u0004\"!W0\u000e\u0003iS!a\u0017/\u0002\u0011%tG/\u001a:oC2T!aE/\u000b\u0005yC\u0012a\u0002:fM2,7\r^\u0005\u0003Aj\u0013\u0011\"\\1de>LU\u000e\u001d72\u0017}\u00117-\u001a8wy\u0006-\u0011QD\u0006\u0001c\u0011!#M\u00033\u0002\u000b5\f7M]82\tY\u0011gM[\u0019\u0004K\u001dDw\"\u00015\"\u0003%\f1\"\\1de>,enZ5oKF\u001aQe\u001b7\u0010\u00031\f\u0013!\\\u0001&m^r\u0003\u0007\t\u0015j[BdW-\\3oi\u0016$\u0007%\u001b8!'\u000e\fG.\u0019\u00113]E\nd\u0006M\u0017Nq%\nDA\u00062pgF\u001aQ\u0005]9\u0010\u0003E\f\u0013A]\u0001\tSN\u0014UO\u001c3mKF\u001aQ\u0005^;\u0010\u0003UL\u0012\u0001A\u0019\u0005-\t<80M\u0002&qf|\u0011!_\u0011\u0002u\u0006Q\u0011n\u001d\"mC\u000e\\'m\u001c=2\u0007\u0015\"X/M\u0003\u0017Ev\f\u0019!M\u0002&}~|\u0011a`\u0011\u0003\u0003\u0003\t\u0011b\u00197bgNt\u0015-\\32\u000b\u0015\n)!a\u0002\u0010\u0005\u0005\u001d\u0011EAA\u0005\u0003u9Wm\u001c;sK2d\u0017n\u001d\u0018nC\u000e\u0014xn\u001d\u0018US2,W*Y2s_N$\u0013G\u0002\fc\u0003\u001b\t)\"M\u0003&\u0003\u001f\t\tb\u0004\u0002\u0002\u0012\u0005\u0012\u00111C\u0001\u000b[\u0016$\bn\u001c3OC6,\u0017'B\u0013\u0002\u0018\u0005eqBAA\rC\t\tY\"A\bj]R4uN]3bG\"|\u0016.\u001c9mc\u00191\"-a\b\u0002(E*Q%!\t\u0002$=\u0011\u00111E\u0011\u0003\u0003K\t\u0011b]5h]\u0006$XO]32\u0011}\u0011\u0017\u0011FA\u001c\u0003\u0003\nd\u0001\n2\u0002,\u00055\u0012\u0002BA\u0017\u0003_\tA\u0001T5ti*!\u0011\u0011GA\u001a\u0003%IW.\\;uC\ndWMC\u0002\u00026a\t!bY8mY\u0016\u001cG/[8oc\u0019y\"-!\u000f\u0002<E2AEYA\u0016\u0003[\tT!JA\u001f\u0003\u007fy!!a\u0010\u001e\u0003}\u0010da\b2\u0002D\u0005\u0015\u0013G\u0002\u0013c\u0003W\ti#M\u0003&\u0003\u000f\nIe\u0004\u0002\u0002Ju\ta \u0003\u0005\u0002N\u0001\u0011I\u0011AA(\u0003]1wN]3bG\"<\u0016\u000e\u001e5XK&<\u0007\u000e\u001e#pk\ndW\rF\u0002P\u0003#BqaUA&\u0001\u0004\t\u0019\u0006\u0005\u0004\u0018+fJ$i\u0014\u0015\u0006\u0003\u0017B\u0016qK\u0019\u0011?\t\fI&a\u0017\u0002b\u0005\u001d\u0014QNA:\u0003\u007f\nD\u0001\n2\u000bIF2aCYA/\u0003?\n4!J4ic\r)3\u000e\\\u0019\u0007-\t\f\u0019'!\u001a2\u0007\u0015\u0002\u0018/M\u0002&iV\fdA\u00062\u0002j\u0005-\u0014gA\u0013ysF\u001aQ\u0005^;2\rY\u0011\u0017qNA9c\r)cp`\u0019\u0006K\u0005\u0015\u0011qA\u0019\u0007-\t\f)(a\u001e2\u000b\u0015\ny!!\u00052\u000b\u0015\nI(a\u001f\u0010\u0005\u0005m\u0014EAA?\u0003I!w.\u001e2mK\u001a{'/Z1dQ~KW\u000e\u001d72\rY\u0011\u0017\u0011QABc\u0015)\u0013\u0011EA\u0012c!y\"-!\"\u0002\b\u00065\u0015G\u0002\u0013c\u0003W\ti#\r\u0004 E\u0006%\u00151R\u0019\u0007I\t\fY#!\f2\u000b\u0015\ni$a\u00102\r}\u0011\u0017qRAIc\u0019!#-a\u000b\u0002.E*Q%a\u0012\u0002J!9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015!\u00054pe\u0016\f7\r[%oiZK7/\u001b;peR\u0019q*!'\t\u000fM\u000b\u0019\n1\u0001\u0002\u001cB\u0019\u0011#!(\n\u0007\u0005}%C\u0001\bJ]R$\u0016\u000e\\3WSNLGo\u001c:\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\u0006!bm\u001c:fC\u000eDGi\\;cY\u00164\u0016n]5u_J$2aTAT\u0011\u001d\u0019\u0016\u0011\u0015a\u0001\u0003S\u00032!EAV\u0013\r\tiK\u0005\u0002\u0012\t>,(\r\\3US2,g+[:ji>\u0014\b")
public class KernelCursor
extends Cursor
implements MacroIterableTile,
Serializable {
    private final Kernel kernel;
    private final int[] ktileArr;
    private final double[] ktileArrDouble;
    private final int kcols;

    private int[] ktileArr() {
        return this.ktileArr;
    }

    private double[] ktileArrDouble() {
        return this.ktileArrDouble;
    }

    private int kcols() {
        return this.kcols;
    }

    public void foreachIntVisitor(IntTileVisitor f) {
        for (int y = this.rowmin(); y <= this.rowmax(); ++y) {
            for (int x = this.colmin(); x <= this.colmax(); ++x) {
                int kcol = this.focusCol() + this.extent() - x;
                int krow = this.focusRow() + this.extent() - y;
                int w = this.ktileArr()[krow * this.kcols() + kcol];
                f.apply(x, y, w);
            }
        }
    }

    public void foreachDoubleVisitor(DoubleTileVisitor f) {
        this.kernel.tile();
        for (int y = this.rowmin(); y <= this.rowmax(); ++y) {
            for (int x = this.colmin(); x <= this.colmax(); ++x) {
                int kcol = this.focusCol() + this.extent() - x;
                int krow = this.focusRow() + this.extent() - y;
                double w = this.ktileArrDouble()[krow * this.kcols() + kcol];
                f.apply(x, y, w);
            }
        }
    }

    public KernelCursor(Tile r, Kernel kernel, GridBounds analysisArea) {
        this.kernel = kernel;
        super(r, analysisArea, kernel.extent());
        this.ktileArr = kernel.tile().toArray();
        this.ktileArrDouble = kernel.tile().toArrayDouble();
        this.kcols = kernel.tile().cols();
    }
}

