/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.Kernel;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;

public final class Kernel$
implements Serializable {
    public static final Kernel$ MODULE$;

    static {
        new Kernel$();
    }

    public Kernel tile2Kernel(Tile r) {
        return new Kernel(r);
    }

    public Kernel apply(Neighborhood nbhd) {
        boolean bl = nbhd.hasMask();
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"Neighborhood must have a mask method").toString());
        }
        int w = 2 * nbhd.extent() + 1;
        int size = w * w;
        IntArrayTile tile = IntArrayTile$.MODULE$.apply(new int[size], w, w, IntConstantNoDataCellType$.MODULE$);
        for (int r = 0; r < w; ++r) {
            for (int c = 0; c < w; ++c) {
                tile.set(c, r, nbhd.mask(c, r) ? 0 : 1);
            }
        }
        return new Kernel(tile);
    }

    public Kernel gaussian(int size, double sigma, double amp) {
        IntArrayTile output = IntArrayTile$.MODULE$.empty(size, size);
        double denom = 2.0 * sigma * sigma;
        for (int r = 0; r < size; ++r) {
            for (int c = 0; c < size; ++c) {
                int rsqr = (c - size / 2) * (c - size / 2) + (r - size / 2) * (r - size / 2);
                int g = (int)(amp * package$.MODULE$.exp((double)(-rsqr) / denom));
                output.set(c, r, g);
            }
        }
        return new Kernel(output);
    }

    public Kernel circle(int size, double cellWidth, int rad) {
        IntArrayTile output = IntArrayTile$.MODULE$.empty(size, size);
        int rad2 = rad * rad;
        int w = size / 2;
        int c = -w;
        for (int r = -w; r <= w; ++r) {
            while (c <= w) {
                output.set(c + w, r + w, r * r + c * c <= rad2 ? 1 : 0);
                ++c;
            }
            c = -w;
        }
        return new Kernel(output);
    }

    public Kernel apply(Tile tile) {
        return new Kernel(tile);
    }

    public Option<Tile> unapply(Kernel x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.tile());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Kernel$() {
        MODULE$ = this;
    }
}

