/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.GridBounds;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.Movement$;
import geotrellis.raster.mapalgebra.focal.ScanLineTraversalStrategy$;
import geotrellis.raster.mapalgebra.focal.SpiralZagTraversalStrategy$;
import geotrellis.raster.mapalgebra.focal.TraversalStrategy;
import geotrellis.raster.mapalgebra.focal.TraversalStrategy$;
import geotrellis.raster.mapalgebra.focal.ZigZagTraversalStrategy$;
import scala.Function0;
import scala.MatchError;
import scala.runtime.BoxedUnit;

public final class CursorStrategy$ {
    public static final CursorStrategy$ MODULE$;

    static {
        new CursorStrategy$();
    }

    public <C extends Cursor> void execute(Cursor cursor, Function0<BoxedUnit> calc2, GridBounds analysisArea) {
        this.execute(cursor, calc2, analysisArea, TraversalStrategy$.MODULE$.DEFAULT());
    }

    public void execute(Cursor cursor, Function0<BoxedUnit> calc2, GridBounds analysisArea, TraversalStrategy traversalStrategy) {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (!ZigZagTraversalStrategy$.MODULE$.equals(traversalStrategy)) break block2;
                        this.handleZigZag(analysisArea, cursor, calc2);
                        break block3;
                    }
                    if (!ScanLineTraversalStrategy$.MODULE$.equals(traversalStrategy)) break block4;
                    this.handleScanLine(analysisArea, cursor, calc2);
                    break block3;
                }
                if (!SpiralZagTraversalStrategy$.MODULE$.equals(traversalStrategy)) break block5;
                this.handleSpiralZag(analysisArea, cursor, calc2);
            }
            return;
        }
        throw new MatchError((Object)traversalStrategy);
    }

    private void handleSpiralZag(GridBounds analysisArea, Cursor cursor, Function0<BoxedUnit> calc2) {
        int colMax = analysisArea.colMax();
        int rowMax = analysisArea.rowMax();
        int colMin = analysisArea.colMin();
        int rowMin = analysisArea.rowMin();
        int col = colMin;
        int row = rowMin;
        boolean done = false;
        boolean zagTime = false;
        cursor.centerOn(colMin, rowMin);
        while (true) {
            if (done || zagTime) {
                int direction = 1;
                while (row <= rowMax) {
                    calc2.apply$mcV$sp();
                    if ((col += direction) < colMin || colMax < col) {
                        ++row;
                        col += (direction *= -1);
                        cursor.move(Movement$.MODULE$.Down());
                        continue;
                    }
                    if (direction == 1) {
                        cursor.move(Movement$.MODULE$.Right());
                        continue;
                    }
                    cursor.move(Movement$.MODULE$.Left());
                }
                return;
            }
            while (col < colMax) {
                calc2.apply$mcV$sp();
                cursor.move(Movement$.MODULE$.Right());
                ++col;
            }
            while (row < rowMax) {
                calc2.apply$mcV$sp();
                cursor.move(Movement$.MODULE$.Down());
                ++row;
            }
            while (col > colMin) {
                calc2.apply$mcV$sp();
                cursor.move(Movement$.MODULE$.Left());
                --col;
            }
            while (row > rowMin + 1) {
                calc2.apply$mcV$sp();
                cursor.move(Movement$.MODULE$.Up());
                --row;
            }
            calc2.apply$mcV$sp();
            if (++rowMin == --rowMax || ++colMin == --colMax) {
                done = true;
                continue;
            }
            cursor.move(Movement$.MODULE$.Right());
            if (++col - cursor.extent() < 0) continue;
            zagTime = true;
        }
    }

    private void handleZigZag(GridBounds analysisArea, Cursor cursor, Function0<BoxedUnit> calc2) {
        int colMax = analysisArea.colMax();
        int rowMax = analysisArea.rowMax();
        int colMin = analysisArea.colMin();
        int rowMin = analysisArea.rowMin();
        int col = colMin;
        int row = rowMin;
        int direction = 1;
        cursor.centerOn(colMin, rowMin);
        while (row <= rowMax) {
            calc2.apply$mcV$sp();
            if ((col += direction) < colMin || colMax < col) {
                ++row;
                col += (direction *= -1);
                cursor.move(Movement$.MODULE$.Down());
                continue;
            }
            if (direction == 1) {
                cursor.move(Movement$.MODULE$.Right());
                continue;
            }
            cursor.move(Movement$.MODULE$.Left());
        }
    }

    private void handleScanLine(GridBounds analysisArea, Cursor cursor, Function0<BoxedUnit> calc2) {
        int colMax = analysisArea.colMax();
        int rowMax = analysisArea.rowMax();
        int colMin = analysisArea.colMin();
        int rowMin = analysisArea.rowMin();
        int col = colMin;
        int row = rowMin;
        cursor.centerOn(colMin, rowMin);
        while (row <= rowMax) {
            calc2.apply$mcV$sp();
            if (colMax < ++col) {
                col = colMin;
                cursor.centerOn(colMin, ++row);
                continue;
            }
            cursor.move(Movement$.MODULE$.Right());
        }
    }

    private CursorStrategy$() {
        MODULE$ = this;
    }
}

