/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.ArrayTileResult;
import geotrellis.raster.mapalgebra.focal.ArrayTileResult$class;
import geotrellis.raster.mapalgebra.focal.Kernel;
import geotrellis.raster.mapalgebra.focal.KernelCalculation;
import geotrellis.raster.mapalgebra.focal.KernelCursor;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class Convolve$ {
    public static final Convolve$ MODULE$;

    static {
        new Convolve$();
    }

    public KernelCalculation<Tile> calculation(Tile tile, Kernel kernel, Option<GridBounds> bounds, TargetCell target) {
        return tile.cellType().isFloatingPoint() ? (kernel.cellType().isFloatingPoint() ? new ArrayTileResult(tile, kernel, (Option)bounds, target){
            private final int cols;
            private final int rows;
            private final MutableArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public MutableArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$resultTile_$eq(MutableArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$copyOriginalValue_$eq(Function4 x$1) {
                this.copyOriginalValue = x$1;
            }

            public DataType resultCellType() {
                return ArrayTileResult$class.resultCellType(this);
            }

            public MutableArrayTile result() {
                return ArrayTileResult$class.result(this);
            }

            public void calc(Tile t, KernelCursor cursor) {
                DoubleRef s = DoubleRef.create((double)Double.NaN);
                cursor.foreachDoubleVisitor(new DoubleTileVisitor(this, t, s){
                    private final Tile t$1;
                    private final DoubleRef s$1;

                    public void apply(int col, int row, double z) {
                        double v = this.t$1.getDouble(col, row);
                        if (!Double.isNaN(v)) {
                            this.s$1.elem = Double.isNaN(this.s$1.elem) ? v * z : (this.s$1.elem += v * z);
                        }
                    }
                    {
                        this.t$1 = t$1;
                        this.s$1 = s$1;
                    }
                });
                this.resultTile().setDouble(cursor.col(), cursor.row(), s.elem);
            }
            {
                ArrayTileResult$class.$init$(this);
            }
        } : new ArrayTileResult(tile, kernel, (Option)bounds, target){
            private final int cols;
            private final int rows;
            private final MutableArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public MutableArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$resultTile_$eq(MutableArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$copyOriginalValue_$eq(Function4 x$1) {
                this.copyOriginalValue = x$1;
            }

            public DataType resultCellType() {
                return ArrayTileResult$class.resultCellType(this);
            }

            public MutableArrayTile result() {
                return ArrayTileResult$class.result(this);
            }

            public void calc(Tile t, KernelCursor cursor) {
                DoubleRef s = DoubleRef.create((double)Double.NaN);
                cursor.foreachIntVisitor(new IntTileVisitor(this, t, s){
                    private final Tile t$2;
                    private final DoubleRef s$2;

                    public void apply(int col, int row, int z) {
                        double v = this.t$2.getDouble(col, row);
                        if (!Double.isNaN(v)) {
                            this.s$2.elem = Double.isNaN(this.s$2.elem) ? v * (double)z : (this.s$2.elem += v * (double)z);
                        }
                    }
                    {
                        this.t$2 = t$2;
                        this.s$2 = s$2;
                    }
                });
                this.resultTile().setDouble(cursor.col(), cursor.row(), s.elem);
            }
            {
                ArrayTileResult$class.$init$(this);
            }
        }) : (kernel.cellType().isFloatingPoint() ? new ArrayTileResult(tile, kernel, (Option)bounds, target){
            private final int cols;
            private final int rows;
            private final MutableArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public MutableArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$resultTile_$eq(MutableArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$copyOriginalValue_$eq(Function4 x$1) {
                this.copyOriginalValue = x$1;
            }

            public DataType resultCellType() {
                return ArrayTileResult$class.resultCellType(this);
            }

            public MutableArrayTile result() {
                return ArrayTileResult$class.result(this);
            }

            public void calc(Tile t, KernelCursor cursor) {
                IntRef s = IntRef.create((int)Integer.MIN_VALUE);
                cursor.foreachDoubleVisitor(new DoubleTileVisitor(this, t, s){
                    private final Tile t$3;
                    private final IntRef s$3;

                    public void apply(int col, int row, double z) {
                        int v = this.t$3.get(col, row);
                        if (v != Integer.MIN_VALUE) {
                            this.s$3.elem = this.s$3.elem != Integer.MIN_VALUE ? (this.s$3.elem += (int)((double)v * z)) : (int)((double)v * z);
                        }
                    }
                    {
                        this.t$3 = t$3;
                        this.s$3 = s$3;
                    }
                });
                this.resultTile().set(cursor.col(), cursor.row(), s.elem);
            }
            {
                ArrayTileResult$class.$init$(this);
            }
        } : new ArrayTileResult(tile, kernel, (Option)bounds, target){
            private final int cols;
            private final int rows;
            private final MutableArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public MutableArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$resultTile_$eq(MutableArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$copyOriginalValue_$eq(Function4 x$1) {
                this.copyOriginalValue = x$1;
            }

            public DataType resultCellType() {
                return ArrayTileResult$class.resultCellType(this);
            }

            public MutableArrayTile result() {
                return ArrayTileResult$class.result(this);
            }

            public void calc(Tile t, KernelCursor cursor) {
                IntRef s = IntRef.create((int)Integer.MIN_VALUE);
                cursor.foreachIntVisitor(new IntTileVisitor(this, t, s){
                    private final Tile t$4;
                    private final IntRef s$4;

                    public void apply(int col, int row, int z) {
                        int v = this.t$4.get(col, row);
                        if (v != Integer.MIN_VALUE) {
                            this.s$4.elem = this.s$4.elem != Integer.MIN_VALUE ? (this.s$4.elem += v * z) : v * z;
                        }
                    }
                    {
                        this.t$4 = t$4;
                        this.s$4 = s$4;
                    }
                });
                this.resultTile().set(cursor.col(), cursor.row(), s.elem);
            }
            {
                ArrayTileResult$class.$init$(this);
            }
        });
    }

    public Option<GridBounds> calculation$default$3() {
        return None$.MODULE$;
    }

    public TargetCell calculation$default$4() {
        return TargetCell$All$.MODULE$;
    }

    public Tile apply(Tile tile, Kernel kernel, Option<GridBounds> bounds, TargetCell target) {
        return this.calculation(tile, kernel, bounds, target).execute();
    }

    public Option<GridBounds> apply$default$3() {
        return None$.MODULE$;
    }

    public TargetCell apply$default$4() {
        return TargetCell$All$.MODULE$;
    }

    private Convolve$() {
        MODULE$ = this;
    }
}

