/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.CellwiseStrategyCalculation;
import geotrellis.raster.mapalgebra.focal.Square;
import scala.math.package$;

public final class CellwiseStrategy$ {
    public static final CellwiseStrategy$ MODULE$;

    static {
        new CellwiseStrategy$();
    }

    public void execute(Tile r, Square n, CellwiseStrategyCalculation calc2, GridBounds analysisArea) {
        this.handleScanLine(r, n.extent(), calc2, analysisArea);
    }

    private void handleScanLine(Tile r, int n, CellwiseStrategyCalculation calc2, GridBounds analysisArea) {
        int rowMin = analysisArea.rowMin();
        int colMin = analysisArea.colMin();
        int rowMax = analysisArea.rowMax();
        int rowBorderMax = r.rows() - 1;
        int colMax = analysisArea.colMax();
        int colBorderMax = r.cols() - 1;
        analysisArea.colMin();
        analysisArea.rowMin();
        for (int focusRow = rowMin; focusRow <= rowMax; ++focusRow) {
            int curRowMin = package$.MODULE$.max(0, focusRow - n);
            int curRowMax = package$.MODULE$.min(rowBorderMax, focusRow + n);
            calc2.reset();
            int curColMax = package$.MODULE$.min(colBorderMax, colMin + n);
            int curColMin = package$.MODULE$.max(0, colMin - n);
            for (int curRow = curRowMin; curRow <= curRowMax; ++curRow) {
                for (int curCol = curColMin; curCol <= curColMax; ++curCol) {
                    calc2.add(r, curCol, curRow);
                }
            }
            calc2.setValue(colMin, focusRow, 0, focusRow - rowMin);
            for (int focusCol = colMin + 1; focusCol <= colMax; ++focusCol) {
                int newEastCol;
                int oldWestCol = focusCol - n - 1;
                if (oldWestCol >= 0) {
                    for (int yy = curRowMin; yy <= curRowMax; ++yy) {
                        calc2.remove(r, oldWestCol, yy);
                    }
                }
                if ((newEastCol = focusCol + n) <= colBorderMax) {
                    for (int yy = curRowMin; yy <= curRowMax; ++yy) {
                        calc2.add(r, newEastCol, yy);
                    }
                }
                calc2.setValue(focusCol, focusRow, focusCol - colMin, focusRow - rowMin);
            }
        }
    }

    private CellwiseStrategy$() {
        MODULE$ = this;
    }
}

