/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.CellwiseCalculation;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult$class;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import scala.Function4;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u0017\t12)\u001a7mo&\u001cX-T3b]\u000e\u000bGn\u0019#pk\ndWM\u0003\u0002\u0004\t\u0005)am\\2bY*\u0011QAB\u0001\u000b[\u0006\u0004\u0018\r\\4fEJ\f'BA\u0004\t\u0003\u0019\u0011\u0018m\u001d;fe*\t\u0011\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u0001\u0019Q\u00012!\u0004\b\u0011\u001b\u0005\u0011\u0011BA\b\u0003\u0005M\u0019U\r\u001c7xSN,7)\u00197dk2\fG/[8o!\t\t\"#D\u0001\u0007\u0013\t\u0019bA\u0001\u0003US2,\u0007CA\u0007\u0016\u0013\t1\"AA\u000bE_V\u0014G.Z!se\u0006LH+\u001b7f%\u0016\u001cX\u000f\u001c;\t\u0013a\u0001!\u0011!Q\u0001\nAI\u0012!\u0001:\n\u0005aQ\u0012BA\u000e\u0003\u0005A1unY1m\u0007\u0006d7-\u001e7bi&|g\u000e\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0005q\u0007CA\u0007 \u0013\t\u0001#A\u0001\u0007OK&<\u0007NY8sQ>|G\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\u0019\u0011w.\u001e8egB\u0019AeJ\u0015\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012aa\u00149uS>t\u0007CA\t+\u0013\tYcA\u0001\u0006He&$'i\\;oIND\u0011\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0019\u0002\rQ\f'oZ3u!\tiq&\u0003\u00021\u0005\tQA+\u0019:hKR\u001cU\r\u001c7\n\u00055R\u0002\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\bF\u00036m]B\u0014\b\u0005\u0002\u000e\u0001!)\u0001D\ra\u0001!!)QD\ra\u0001=!)!E\ra\u0001G!)QF\ra\u0001]!91\b\u0001a\u0001\n\u0003a\u0014!B2pk:$X#A\u001f\u0011\u0005\u0011r\u0014BA &\u0005\rIe\u000e\u001e\u0005\b\u0003\u0002\u0001\r\u0011\"\u0001C\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011A\u0005R\u0005\u0003\u000b\u0016\u0012A!\u00168ji\"9q\tQA\u0001\u0002\u0004i\u0014a\u0001=%c!1\u0011\n\u0001Q!\nu\naaY8v]R\u0004\u0003bB&\u0001\u0001\u0004%\t\u0001T\u0001\u0004gVlW#A'\u0011\u0005\u0011r\u0015BA(&\u0005\u0019!u.\u001e2mK\"9\u0011\u000b\u0001a\u0001\n\u0003\u0011\u0016aB:v[~#S-\u001d\u000b\u0003\u0007NCqa\u0012)\u0002\u0002\u0003\u0007Q\n\u0003\u0004V\u0001\u0001\u0006K!T\u0001\u0005gVl\u0007\u0005C\u0003X\u0001\u0011\u0005\u0001,A\u0002bI\u0012$BaQ-[9\")\u0001D\u0016a\u0001!!)1L\u0016a\u0001{\u0005\t\u0001\u0010C\u0003^-\u0002\u0007Q(A\u0001z\u0011\u0015y\u0006\u0001\"\u0001a\u0003\u0019\u0011X-\\8wKR!1)\u00192d\u0011\u0015Ab\f1\u0001\u0011\u0011\u0015Yf\f1\u0001>\u0011\u0015if\f1\u0001>\u0011\u0015)\u0007\u0001\"\u0001g\u0003!\u0019X\r\u001e,bYV,GcA\"hQ\")1\f\u001aa\u0001{!)Q\f\u001aa\u0001{!)!\u000e\u0001C\u0001W\u0006)!/Z:fiR\t1\t")
public class CellwiseMeanCalcDouble
extends CellwiseCalculation<Tile>
implements DoubleArrayTileResult {
    private int count;
    private double sum;
    private final int cols;
    private final int rows;
    private final DoubleArrayTile resultTile;
    private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public DoubleArrayTile resultTile() {
        return this.resultTile;
    }

    @Override
    public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
        return this.copyOriginalValue;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$cols_$eq(int x$1) {
        this.cols = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$rows_$eq(int x$1) {
        this.rows = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$resultTile_$eq(DoubleArrayTile x$1) {
        this.resultTile = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$copyOriginalValue_$eq(Function4 x$1) {
        this.copyOriginalValue = x$1;
    }

    @Override
    public DoubleArrayTile result() {
        return DoubleArrayTileResult$class.result(this);
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public double sum() {
        return this.sum;
    }

    public void sum_$eq(double x$1) {
        this.sum = x$1;
    }

    @Override
    public void add(Tile r, int x, int y) {
        double z = r.getDouble(x, y);
        if (!Double.isNaN(z)) {
            this.count_$eq(this.count() + 1);
            this.sum_$eq(this.sum() + z);
        }
    }

    @Override
    public void remove(Tile r, int x, int y) {
        double v = r.getDouble(x, y);
        if (!Double.isNaN(v)) {
            this.count_$eq(this.count() - 1);
            if (this.count() == 0) {
                this.sum_$eq(0.0);
            } else {
                this.sum_$eq(this.sum() - v);
            }
        }
    }

    @Override
    public void setValue(int x, int y) {
        this.resultTile().setDouble(x, y, this.sum() / (double)this.count());
    }

    @Override
    public void reset() {
        this.count_$eq(0);
        this.sum_$eq(0.0);
    }

    public CellwiseMeanCalcDouble(Tile r, Neighborhood n, Option<GridBounds> bounds, TargetCell target) {
        super(r, n, bounds, target);
        DoubleArrayTileResult$class.$init$(this);
        this.count = 0;
        this.sum = 0.0;
    }
}

