/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.CellwiseCalculation;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult$class;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import scala.Function4;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u0017\t\u00012)\u001a7mo&\u001cX-T3b]\u000e\u000bGn\u0019\u0006\u0003\u0007\u0011\tQAZ8dC2T!!\u0002\u0004\u0002\u00155\f\u0007/\u00197hK\n\u0014\u0018M\u0003\u0002\b\u0011\u00051!/Y:uKJT\u0011!C\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u00011!\u0002cA\u0007\u000f!5\t!!\u0003\u0002\u0010\u0005\t\u00192)\u001a7mo&\u001cXmQ1mGVd\u0017\r^5p]B\u0011\u0011CE\u0007\u0002\r%\u00111C\u0002\u0002\u0005)&dW\r\u0005\u0002\u000e+%\u0011aC\u0001\u0002\u0016\t>,(\r\\3BeJ\f\u0017\u0010V5mKJ+7/\u001e7u\u0011%A\u0002A!A!\u0002\u0013\u0001\u0012$A\u0001s\u0013\tA\"$\u0003\u0002\u001c\u0005\t\u0001bi\\2bY\u000e\u000bGnY;mCRLwN\u001c\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005\ta\u000e\u0005\u0002\u000e?%\u0011\u0001E\u0001\u0002\r\u001d\u0016Lw\r\u001b2pe\"|w\u000e\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u00051!m\\;oIN\u00042\u0001J\u0014*\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB(qi&|g\u000e\u0005\u0002\u0012U%\u00111F\u0002\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\b\"C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u00182\u0003\u0019!\u0018M]4fiB\u0011QbL\u0005\u0003a\t\u0011!\u0002V1sO\u0016$8)\u001a7m\u0013\ti#\u0004C\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0006kY:\u0004(\u000f\t\u0003\u001b\u0001AQ\u0001\u0007\u001aA\u0002AAQ!\b\u001aA\u0002yAQA\t\u001aA\u0002\rBQ!\f\u001aA\u00029Bqa\u000f\u0001A\u0002\u0013\u0005A(A\u0003d_VtG/F\u0001>!\t!c(\u0003\u0002@K\t\u0019\u0011J\u001c;\t\u000f\u0005\u0003\u0001\u0019!C\u0001\u0005\u0006I1m\\;oi~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"\u0001\n#\n\u0005\u0015+#\u0001B+oSRDqa\u0012!\u0002\u0002\u0003\u0007Q(A\u0002yIEBa!\u0013\u0001!B\u0013i\u0014AB2pk:$\b\u0005C\u0004L\u0001\u0001\u0007I\u0011\u0001\u001f\u0002\u0007M,X\u000eC\u0004N\u0001\u0001\u0007I\u0011\u0001(\u0002\u000fM,Xn\u0018\u0013fcR\u00111i\u0014\u0005\b\u000f2\u000b\t\u00111\u0001>\u0011\u0019\t\u0006\u0001)Q\u0005{\u0005!1/^7!\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\r\tG\r\u001a\u000b\u0005\u0007V3\u0006\fC\u0003\u0019%\u0002\u0007\u0001\u0003C\u0003X%\u0002\u0007Q(A\u0001y\u0011\u0015I&\u000b1\u0001>\u0003\u0005I\b\"B.\u0001\t\u0003a\u0016A\u0002:f[>4X\r\u0006\u0003D;z{\u0006\"\u0002\r[\u0001\u0004\u0001\u0002\"B,[\u0001\u0004i\u0004\"B-[\u0001\u0004i\u0004\"B1\u0001\t\u0003\u0011\u0017\u0001C:fiZ\u000bG.^3\u0015\u0007\r\u001bG\rC\u0003XA\u0002\u0007Q\bC\u0003ZA\u0002\u0007Q\bC\u0003g\u0001\u0011\u0005q-A\u0003sKN,G\u000fF\u0001D\u0001")
public class CellwiseMeanCalc
extends CellwiseCalculation<Tile>
implements DoubleArrayTileResult {
    private int count;
    private int sum;
    private final int cols;
    private final int rows;
    private final DoubleArrayTile resultTile;
    private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public DoubleArrayTile resultTile() {
        return this.resultTile;
    }

    @Override
    public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
        return this.copyOriginalValue;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$cols_$eq(int x$1) {
        this.cols = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$rows_$eq(int x$1) {
        this.rows = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$resultTile_$eq(DoubleArrayTile x$1) {
        this.resultTile = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$copyOriginalValue_$eq(Function4 x$1) {
        this.copyOriginalValue = x$1;
    }

    @Override
    public DoubleArrayTile result() {
        return DoubleArrayTileResult$class.result(this);
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public int sum() {
        return this.sum;
    }

    public void sum_$eq(int x$1) {
        this.sum = x$1;
    }

    @Override
    public void add(Tile r, int x, int y) {
        int z = r.get(x, y);
        if (z != Integer.MIN_VALUE) {
            this.count_$eq(this.count() + 1);
            this.sum_$eq(this.sum() + z);
        }
    }

    @Override
    public void remove(Tile r, int x, int y) {
        int z = r.get(x, y);
        if (z != Integer.MIN_VALUE) {
            this.count_$eq(this.count() - 1);
            this.sum_$eq(this.sum() - z);
        }
    }

    @Override
    public void setValue(int x, int y) {
        this.resultTile().setDouble(x, y, (double)this.sum() / (double)this.count());
    }

    @Override
    public void reset() {
        this.count_$eq(0);
        this.sum_$eq(0);
    }

    public CellwiseMeanCalc(Tile r, Neighborhood n, Option<GridBounds> bounds, TargetCell target) {
        super(r, n, bounds, target);
        DoubleArrayTileResult$class.$init$(this);
        this.count = 0;
        this.sum = 0;
    }
}

