/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.writer;

import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.ByteUserDefinedNoDataCellType;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleUserDefinedNoDataCellType;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatUserDefinedNoDataCellType;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.ShortUserDefinedNoDataCellType;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UByteConstantNoDataCellType$;
import geotrellis.raster.UByteUserDefinedNoDataCellType;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortUserDefinedNoDataCellType;
import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.tags.codes.ColorSpace$;
import geotrellis.raster.io.geotiff.tags.codes.PlanarConfigurations$;
import geotrellis.raster.io.geotiff.tags.codes.TagCodes$;
import geotrellis.raster.io.geotiff.tags.codes.TiffFieldType$;
import geotrellis.raster.io.geotiff.writer.BigEndianToBytes$;
import geotrellis.raster.io.geotiff.writer.CoordinateSystemParser$;
import geotrellis.raster.io.geotiff.writer.GeoDirectoryTags;
import geotrellis.raster.io.geotiff.writer.IncompatibleGeoTiffOptionsException;
import geotrellis.raster.io.geotiff.writer.LittleEndianToBytes$;
import geotrellis.raster.io.geotiff.writer.TiffTagFieldValue;
import geotrellis.raster.io.geotiff.writer.ToBytes;
import geotrellis.raster.package$;
import geotrellis.raster.render.IndexedColorMap;
import geotrellis.raster.render.IndexedColorMap$;
import geotrellis.vector.Extent;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.PrettyPrinter;

public final class TiffTagFieldValue$
implements Serializable {
    public static final TiffTagFieldValue$ MODULE$;

    static {
        new TiffTagFieldValue$();
    }

    public TiffTagFieldValue apply(int tag, int fieldType, int length, int value, ToBytes toBytes) {
        block4: {
            TiffTagFieldValue tiffTagFieldValue;
            block3: {
                block2: {
                    if (TiffFieldType$.MODULE$.ShortsFieldType() != fieldType) break block2;
                    tiffTagFieldValue = new TiffTagFieldValue(tag, fieldType, length, toBytes.apply((short)value));
                    break block3;
                }
                if (TiffFieldType$.MODULE$.IntsFieldType() != fieldType) break block4;
                tiffTagFieldValue = new TiffTagFieldValue(tag, fieldType, length, toBytes.apply(value));
            }
            return tiffTagFieldValue;
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)fieldType));
    }

    public Option<String> createNoDataString(DataType cellType) {
        block16: {
            None$ none$;
            block3: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block5: {
                                                            block4: {
                                                                block2: {
                                                                    boolean bl = BitCellType$.MODULE$.equals(cellType) ? true : (ByteCellType$.MODULE$.equals(cellType) ? true : (UByteCellType$.MODULE$.equals(cellType) ? true : (ShortCellType$.MODULE$.equals(cellType) ? true : (UShortCellType$.MODULE$.equals(cellType) ? true : (IntCellType$.MODULE$.equals(cellType) ? true : (FloatCellType$.MODULE$.equals(cellType) ? true : DoubleCellType$.MODULE$.equals(cellType)))))));
                                                                    if (!bl) break block2;
                                                                    none$ = None$.MODULE$;
                                                                    break block3;
                                                                }
                                                                if (!ByteConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                                                                none$ = new Some((Object)((Object)BoxesRunTime.boxToByte((byte)-128)).toString());
                                                                break block3;
                                                            }
                                                            if (!(cellType instanceof ByteUserDefinedNoDataCellType)) break block5;
                                                            ByteUserDefinedNoDataCellType byteUserDefinedNoDataCellType = (ByteUserDefinedNoDataCellType)cellType;
                                                            none$ = new Some((Object)((Object)BoxesRunTime.boxToByte((byte)byteUserDefinedNoDataCellType.noDataValue())).toString());
                                                            break block3;
                                                        }
                                                        if (!UByteConstantNoDataCellType$.MODULE$.equals(cellType)) break block6;
                                                        none$ = new Some((Object)((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.ubyteNODATA())).toString());
                                                        break block3;
                                                    }
                                                    if (!(cellType instanceof UByteUserDefinedNoDataCellType)) break block7;
                                                    UByteUserDefinedNoDataCellType uByteUserDefinedNoDataCellType = (UByteUserDefinedNoDataCellType)cellType;
                                                    none$ = new Some((Object)((Object)BoxesRunTime.boxToByte((byte)uByteUserDefinedNoDataCellType.noDataValue())).toString());
                                                    break block3;
                                                }
                                                if (!ShortConstantNoDataCellType$.MODULE$.equals(cellType)) break block8;
                                                none$ = new Some((Object)((Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE)).toString());
                                                break block3;
                                            }
                                            if (!(cellType instanceof ShortUserDefinedNoDataCellType)) break block9;
                                            ShortUserDefinedNoDataCellType shortUserDefinedNoDataCellType = (ShortUserDefinedNoDataCellType)cellType;
                                            none$ = new Some((Object)((Object)BoxesRunTime.boxToShort((short)shortUserDefinedNoDataCellType.noDataValue())).toString());
                                            break block3;
                                        }
                                        if (!UShortConstantNoDataCellType$.MODULE$.equals(cellType)) break block10;
                                        none$ = new Some((Object)((Object)BoxesRunTime.boxToShort((short)package$.MODULE$.ushortNODATA())).toString());
                                        break block3;
                                    }
                                    if (!(cellType instanceof UShortUserDefinedNoDataCellType)) break block11;
                                    UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)cellType;
                                    none$ = new Some((Object)((Object)BoxesRunTime.boxToShort((short)uShortUserDefinedNoDataCellType.noDataValue())).toString());
                                    break block3;
                                }
                                if (!IntConstantNoDataCellType$.MODULE$.equals(cellType)) break block12;
                                none$ = new Some((Object)((Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)).toString());
                                break block3;
                            }
                            if (!(cellType instanceof IntUserDefinedNoDataCellType)) break block13;
                            IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)cellType;
                            none$ = new Some((Object)((Object)BoxesRunTime.boxToInteger((int)intUserDefinedNoDataCellType.noDataValue())).toString());
                            break block3;
                        }
                        boolean bl = FloatConstantNoDataCellType$.MODULE$.equals(cellType) ? true : DoubleConstantNoDataCellType$.MODULE$.equals(cellType);
                        if (!bl) break block14;
                        none$ = new Some((Object)"nan");
                        break block3;
                    }
                    if (!(cellType instanceof FloatUserDefinedNoDataCellType)) break block15;
                    FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)cellType;
                    none$ = new Some((Object)((Object)BoxesRunTime.boxToDouble((double)floatUserDefinedNoDataCellType.noDataValue())).toString());
                    break block3;
                }
                if (!(cellType instanceof DoubleUserDefinedNoDataCellType)) break block16;
                DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)cellType;
                none$ = new Some((Object)((Object)BoxesRunTime.boxToDouble((double)doubleUserDefinedNoDataCellType.noDataValue())).toString());
            }
            return none$;
        }
        throw new MatchError((Object)cellType);
    }

    public Tuple2<TiffTagFieldValue[], Function1<int[], TiffTagFieldValue>> collect(GeoTiffData geoTiff) {
        GeoDirectoryTags geoDirectoryTags;
        block10: {
            Tags tags;
            block11: {
                Option<PixelSampleType> option;
                block14: {
                    Option option2;
                    block17: {
                        StorageMethod storageMethod;
                        block20: {
                            Object object;
                            ListBuffer fieldValues;
                            block19: {
                                int[] segmentByteCounts;
                                GeoTiffImageData imageData;
                                ToBytes toBytes;
                                block18: {
                                    Map modifiedHeaderTags;
                                    block16: {
                                        block15: {
                                            block13: {
                                                block12: {
                                                    Option<String> option3;
                                                    ByteOrder byteOrder = geoTiff.imageData().decompressor().byteOrder();
                                                    ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
                                                    toBytes = !(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null) ? BigEndianToBytes$.MODULE$ : LittleEndianToBytes$.MODULE$;
                                                    imageData = geoTiff.imageData();
                                                    Extent extent2 = geoTiff.extent();
                                                    fieldValues = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                                                    fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.ImageWidthTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, imageData.cols(), toBytes));
                                                    fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.ImageLengthTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, imageData.rows(), toBytes));
                                                    fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.BitsPerSampleTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.bandType().bitsPerSample(), toBytes));
                                                    fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.CompressionTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.decompressor().code(), toBytes));
                                                    fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.PhotometricInterpTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, geoTiff.options().colorSpace(), toBytes));
                                                    fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.SamplesPerPixelTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.bandCount(), toBytes));
                                                    fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.PlanarConfigurationTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, PlanarConfigurations$.MODULE$.PixelInterleave(), toBytes));
                                                    fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.SampleFormatTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.bandType().sampleFormat(), toBytes));
                                                    if (geoTiff.options().colorSpace() == ColorSpace$.MODULE$.Palette()) {
                                                        int bitsPerSample = imageData.bandType().bitsPerSample();
                                                        if (bitsPerSample > 16 || geoTiff.cellType().isFloatingPoint()) {
                                                            throw new IncompatibleGeoTiffOptionsException("'Palette' color space only supported for 8 or 16 bit integral cell types.");
                                                        }
                                                        int divider = 1 << bitsPerSample;
                                                        Option<IndexedColorMap> option4 = geoTiff.options().colorMap();
                                                        if (!option4.isEmpty()) {
                                                            IndexedColorMap indexedColorMap = (IndexedColorMap)option4.get();
                                                            Seq<Tuple3<Object, Object, Object>> palette1 = IndexedColorMap$.MODULE$.toTiffPalette(indexedColorMap);
                                                            int size1 = scala.math.package$.MODULE$.min(palette1.size(), divider);
                                                            short[] flattenedPalette1 = (short[])Array$.MODULE$.ofDim(divider * 3, ClassTag$.MODULE$.Short());
                                                            for (int index$macro$5711 = 0; index$macro$5711 < size1; ++index$macro$5711) {
                                                                Tuple3 c1 = (Tuple3)palette1.apply(index$macro$5711);
                                                                flattenedPalette1[index$macro$5711] = BoxesRunTime.unboxToShort((Object)c1._1());
                                                                flattenedPalette1[index$macro$5711 + divider] = BoxesRunTime.unboxToShort((Object)c1._2());
                                                                flattenedPalette1[index$macro$5711 + divider * 2] = BoxesRunTime.unboxToShort((Object)c1._3());
                                                            }
                                                            fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.ColorMapTag(), TiffFieldType$.MODULE$.ShortsFieldType(), flattenedPalette1.length, toBytes.apply(flattenedPalette1)));
                                                        }
                                                    }
                                                    if ((option3 = this.createNoDataString(geoTiff.cellType())) instanceof Some) {
                                                        Some some = (Some)option3;
                                                        byte[] bs = toBytes.apply((String)some.x());
                                                        fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.GDALInternalNoDataTag(), TiffFieldType$.MODULE$.AsciisFieldType(), bs.length, bs));
                                                    }
                                                    RasterExtent re = RasterExtent$.MODULE$.apply(extent2, imageData.cols(), imageData.rows());
                                                    fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.ModelPixelScaleTag(), TiffFieldType$.MODULE$.DoublesFieldType(), 3, toBytes.apply(new double[]{re.cellwidth(), re.cellheight(), 0.0})));
                                                    fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.ModelTiePointsTag(), TiffFieldType$.MODULE$.DoublesFieldType(), 6, toBytes.apply(new double[]{0.0, 0.0, 0.0, extent2.xmin(), extent2.ymax(), 0.0})));
                                                    geoDirectoryTags = CoordinateSystemParser$.MODULE$.parse(geoTiff.crs(), geoTiff.pixelSampleType());
                                                    if (geoDirectoryTags == null) break block10;
                                                    Tuple2 tuple2 = new Tuple2(geoDirectoryTags.shortTags(), (Object)geoDirectoryTags.doubles());
                                                    Tuple4[] shortGeoKeys = (Tuple4[])tuple2._1();
                                                    double[] doubleGeoKeys = (double[])tuple2._2();
                                                    short[] shortValues = (short[])Array$.MODULE$.ofDim((shortGeoKeys.length + 1) * 4, ClassTag$.MODULE$.Short());
                                                    shortValues[0] = 1;
                                                    shortValues[1] = 1;
                                                    shortValues[2] = 0;
                                                    shortValues[3] = (short)shortGeoKeys.length;
                                                    for (int index$macro$572 = 0; index$macro$572 < shortGeoKeys.length; ++index$macro$572) {
                                                        int start = (index$macro$572 + 1) * 4;
                                                        shortValues[start] = (short)BoxesRunTime.unboxToInt((Object)shortGeoKeys[index$macro$572]._1());
                                                        shortValues[start + 1] = (short)BoxesRunTime.unboxToInt((Object)shortGeoKeys[index$macro$572]._2());
                                                        shortValues[start + 2] = (short)BoxesRunTime.unboxToInt((Object)shortGeoKeys[index$macro$572]._3());
                                                        shortValues[start + 3] = (short)BoxesRunTime.unboxToInt((Object)shortGeoKeys[index$macro$572]._4());
                                                    }
                                                    Predef$ predef$ = Predef$.MODULE$;
                                                    Object object2 = new ArrayOps.ofShort(shortValues).isEmpty() ? BoxedUnit.UNIT : fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.GeoKeyDirectoryTag(), TiffFieldType$.MODULE$.ShortsFieldType(), shortValues.length, toBytes.apply(shortValues)));
                                                    Predef$ predef$2 = Predef$.MODULE$;
                                                    Object object3 = new ArrayOps.ofDouble(doubleGeoKeys).isEmpty() ? BoxedUnit.UNIT : fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.GeoDoubleParamsTag(), TiffFieldType$.MODULE$.DoublesFieldType(), doubleGeoKeys.length, toBytes.apply(doubleGeoKeys)));
                                                    tags = geoTiff.tags();
                                                    if (tags == null) break block11;
                                                    Tuple2 tuple22 = new Tuple2(tags.headTags(), tags.bandTags());
                                                    Map headerTags = (Map)tuple22._1();
                                                    List cfr_ignored_0 = (List)tuple22._2();
                                                    modifiedHeaderTags = headerTags;
                                                    option = geoTiff.pixelSampleType();
                                                    if (!(option instanceof Some)) break block12;
                                                    modifiedHeaderTags = (Map)headerTags.$minus((Object)"AREA_OR_POINT");
                                                    break block13;
                                                }
                                                if (!None$.MODULE$.equals(option)) break block14;
                                            }
                                            option2 = modifiedHeaderTags.get((Object)"TIFFTAG_DATETIME");
                                            if (!(option2 instanceof Some)) break block15;
                                            Some some = (Some)option2;
                                            byte[] bs = toBytes.apply((String)some.x());
                                            fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.DateTimeTag(), TiffFieldType$.MODULE$.AsciisFieldType(), bs.length, bs));
                                            modifiedHeaderTags = (Map)modifiedHeaderTags.$minus((Object)"TIFFTAG_DATETIME");
                                            break block16;
                                        }
                                        if (!None$.MODULE$.equals(option2)) break block17;
                                    }
                                    PrettyPrinter qual$1 = new PrettyPrinter(Integer.MAX_VALUE, 2);
                                    Elem x$8 = new Tags((Map<String, String>)modifiedHeaderTags, geoTiff.tags().bandTags()).toXml();
                                    NamespaceBinding x$9 = qual$1.format$default$2();
                                    byte[] metadata = toBytes.apply(qual$1.format((Node)x$8, x$9));
                                    fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.MetadataTag(), TiffFieldType$.MODULE$.AsciisFieldType(), metadata.length, metadata));
                                    segmentByteCounts = (int[])((TraversableOnce)imageData.segmentBytes().map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(byte[] x$7) {
                                            return x$7.length;
                                        }
                                    }, Traversable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                                    storageMethod = imageData.segmentLayout().storageMethod();
                                    if (!(storageMethod instanceof Tiled)) break block18;
                                    Tiled tiled = (Tiled)storageMethod;
                                    fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.TileWidthTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, toBytes.apply(tiled.blockCols())));
                                    fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.TileLengthTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, toBytes.apply(tiled.blockRows())));
                                    fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.TileByteCountsTag(), TiffFieldType$.MODULE$.IntsFieldType(), segmentByteCounts.length, toBytes.apply(segmentByteCounts)));
                                    object = new Serializable(toBytes){
                                        public static final long serialVersionUID = 0L;
                                        private final ToBytes toBytes$1;

                                        public final TiffTagFieldValue apply(int[] offsets2) {
                                            return new TiffTagFieldValue(TagCodes$.MODULE$.TileOffsetsTag(), TiffFieldType$.MODULE$.IntsFieldType(), offsets2.length, this.toBytes$1.apply(offsets2));
                                        }
                                        {
                                            this.toBytes$1 = toBytes$1;
                                        }
                                    };
                                    break block19;
                                }
                                if (!(storageMethod instanceof Striped)) break block20;
                                int rowsPerStrip = imageData.segmentLayout().tileLayout().tileRows();
                                fieldValues.$plus$eq((Object)(rowsPerStrip < Short.MAX_VALUE ? this.apply(TagCodes$.MODULE$.RowsPerStripTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, rowsPerStrip, toBytes) : this.apply(TagCodes$.MODULE$.RowsPerStripTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, rowsPerStrip, toBytes)));
                                fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.StripByteCountsTag(), TiffFieldType$.MODULE$.IntsFieldType(), segmentByteCounts.length, toBytes.apply(segmentByteCounts)));
                                object = new Serializable(toBytes){
                                    public static final long serialVersionUID = 0L;
                                    private final ToBytes toBytes$1;

                                    public final TiffTagFieldValue apply(int[] offsets2) {
                                        return new TiffTagFieldValue(TagCodes$.MODULE$.StripOffsetsTag(), TiffFieldType$.MODULE$.IntsFieldType(), offsets2.length, this.toBytes$1.apply(offsets2));
                                    }
                                    {
                                        this.toBytes$1 = toBytes$1;
                                    }
                                };
                            }
                            return new Tuple2(fieldValues.toArray(ClassTag$.MODULE$.apply(TiffTagFieldValue.class)), object);
                        }
                        throw new MatchError((Object)storageMethod);
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)tags);
        }
        throw new MatchError((Object)geoDirectoryTags);
    }

    public TiffTagFieldValue apply(int tag, int fieldType, int length, byte[] value) {
        return new TiffTagFieldValue(tag, fieldType, length, value);
    }

    public Option<Tuple4<Object, Object, Object, byte[]>> unapply(TiffTagFieldValue x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)x$0.tag()), (Object)BoxesRunTime.boxToInteger((int)x$0.fieldType()), (Object)BoxesRunTime.boxToInteger((int)x$0.length()), (Object)x$0.value()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TiffTagFieldValue$() {
        MODULE$ = this;
    }
}

