/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.writer;

import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.writer.BigEndianToBytes$;
import geotrellis.raster.io.geotiff.writer.LittleEndianToBytes$;
import geotrellis.raster.io.geotiff.writer.TiffTagFieldValue;
import geotrellis.raster.io.geotiff.writer.TiffTagFieldValue$;
import geotrellis.raster.io.geotiff.writer.ToBytes;
import java.io.DataOutputStream;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rt!B\u0001\u0003\u0011\u0003i\u0011!D$f_RKgMZ,sSR,'O\u0003\u0002\u0004\t\u00051qO]5uKJT!!\u0002\u0004\u0002\u000f\u001d,w\u000e^5gM*\u0011q\u0001C\u0001\u0003S>T!!\u0003\u0006\u0002\rI\f7\u000f^3s\u0015\u0005Y\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"!D$f_RKgMZ,sSR,'o\u0005\u0002\u0010%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!G\b\u0005\u0002i\ta\u0001P5oSRtD#A\u0007\t\u000bqyA\u0011A\u000f\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007y\ts\u0005\u0005\u0002\u0014?%\u0011\u0001\u0005\u0006\u0002\u0005+:LG\u000fC\u0003#7\u0001\u00071%A\u0004hK>$\u0016N\u001a4\u0011\u0005\u0011*S\"\u0001\u0003\n\u0005\u0019\"!aC$f_RKgM\u001a#bi\u0006DQ\u0001K\u000eA\u0002%\nA\u0001]1uQB\u0011!&\f\b\u0003'-J!\u0001\f\u000b\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003YQAQ\u0001H\b\u0005\u0002E\"\"A\r\u001d\u0011\u0007M\u0019T'\u0003\u00025)\t)\u0011I\u001d:bsB\u00111CN\u0005\u0003oQ\u0011AAQ=uK\")!\u0005\ra\u0001G\u0019!\u0001C\u0001\u0001;'\tI$\u0003\u0003\u0005#s\t\u0005\t\u0015!\u0003$\u0011!i\u0014H!A!\u0002\u0013q\u0014a\u00013pgB\u0011qhQ\u0007\u0002\u0001*\u0011q!\u0011\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!\u0005I\u0001\tECR\fw*\u001e;qkR\u001cFO]3b[\")\u0011$\u000fC\u0001\rR\u0019q\tS%\u0011\u00059I\u0004\"\u0002\u0012F\u0001\u0004\u0019\u0003\"B\u001fF\u0001\u0004q\u0004bB&:\u0005\u0004%\u0019\u0001T\u0001\bi>\u0014\u0015\u0010^3t+\u0005i\u0005C\u0001\bO\u0013\ty%AA\u0004U_\nKH/Z:\t\rEK\u0004\u0015!\u0003N\u0003!!xNQ=uKN\u0004\u0003BC*:!\u0003\u0005\u0019\u0011)A\u0005)\u0006\u0019\u0001\u0010J\u0019\u0011\tM)vkW\u0005\u0003-R\u0011a\u0001V;qY\u0016\u0014\u0004cA\n41B\u0011a\"W\u0005\u00035\n\u0011\u0011\u0003V5gMR\u000bwMR5fY\u00124\u0016\r\\;f!\u0011\u0019BL\u0018-\n\u0005u#\"!\u0003$v]\u000e$\u0018n\u001c82!\r\u00192g\u0018\t\u0003'\u0001L!!\u0019\u000b\u0003\u0007%sG\u000fC\u0004ds\t\u0007I\u0011\u00013\u0002\u0017\u0019LW\r\u001c3WC2,Xm]\u000b\u0002/\"1a-\u000fQ\u0001\n]\u000bABZ5fY\u00124\u0016\r\\;fg\u0002Bq\u0001[\u001dC\u0002\u0013\u0005\u0011.A\fpM\u001a\u001cX\r\u001e$jK2$g+\u00197vK\n+\u0018\u000e\u001c3feV\t1\f\u0003\u0004ls\u0001\u0006IaW\u0001\u0019_\u001a47/\u001a;GS\u0016dGMV1mk\u0016\u0014U/\u001b7eKJ\u0004\u0003bB7:\u0005\u0004%\tA\\\u0001\tg\u0016<W.\u001a8ugV\tq\u000e\u0005\u0002%a&\u0011\u0011\u000f\u0002\u0002\r'\u0016<W.\u001a8u\u0005f$Xm\u001d\u0005\u0007gf\u0002\u000b\u0011B8\u0002\u0013M,w-\\3oiN\u0004\u0003bB;:\u0005\u0004%\tA^\u0001\rg\u0016<W.\u001a8u\u0007>,h\u000e^\u000b\u0002?\"1\u00010\u000fQ\u0001\n}\u000bQb]3h[\u0016tGoQ8v]R\u0004\u0003b\u0002>:\u0005\u0004%\tA^\u0001\u0012i\u0006<g)[3mI\nKH/Z\"pk:$\bB\u0002?:A\u0003%q,\u0001\nuC\u001e4\u0015.\u001a7e\u0005f$XmQ8v]R\u0004\u0003b\u0002@:\u0005\u0004%\tA^\u0001\u0011i\u0006<G)\u0019;b\u0005f$XmQ8v]RDq!!\u0001:A\u0003%q,A\tuC\u001e$\u0015\r^1CsR,7i\\;oi\u0002B\u0001\"!\u0002:\u0001\u0004%\tA^\u0001\u0006S:$W\r\u001f\u0005\n\u0003\u0013I\u0004\u0019!C\u0001\u0003\u0017\t\u0011\"\u001b8eKb|F%Z9\u0015\u0007y\ti\u0001\u0003\u0005T\u0003\u000f\t\t\u00111\u0001`\u0011\u001d\t\t\"\u000fQ!\n}\u000ba!\u001b8eKb\u0004\u0003bBA\u000bs\u0011\u0005\u0011qC\u0001\noJLG/\u001a\"zi\u0016$2AHA\r\u0011\u001d\tY\"a\u0005A\u0002U\nQA^1mk\u0016Dq!a\b:\t\u0003\t\t#\u0001\u0006xe&$XMQ=uKN$2AHA\u0012\u0011\u001d\tY\"!\bA\u0002IBq!a\n:\t\u0003\tI#\u0001\u0006xe&$Xm\u00155peR$2AHA\u0016\u0011\u001d\tY\"!\nA\u0002}Cq!a\f:\t\u0003\t\t$\u0001\u0005xe&$X-\u00138u)\rq\u00121\u0007\u0005\b\u00037\ti\u00031\u0001`\u0011\u001d\t9$\u000fC\u0001\u0003s\t\u0011b\u001e:ji\u0016duN\\4\u0015\u0007y\tY\u0004\u0003\u0005\u0002\u001c\u0005U\u0002\u0019AA\u001f!\r\u0019\u0012qH\u0005\u0004\u0003\u0003\"\"\u0001\u0002'p]\u001eDq!!\u0012:\t\u0003\t9%\u0001\u0006xe&$XM\u00127pCR$2AHA%\u0011!\tY\"a\u0011A\u0002\u0005-\u0003cA\n\u0002N%\u0019\u0011q\n\u000b\u0003\u000b\u0019cw.\u0019;\t\u000f\u0005M\u0013\b\"\u0001\u0002V\u0005YqO]5uK\u0012{WO\u00197f)\rq\u0012q\u000b\u0005\t\u00037\t\t\u00061\u0001\u0002ZA\u00191#a\u0017\n\u0007\u0005uCC\u0001\u0004E_V\u0014G.\u001a\u0005\u00079e\"\t!!\u0019\u0015\u0003y\u0001")
public class GeoTiffWriter {
    private final GeoTiffData geoTiff;
    private final DataOutputStream dos;
    private final ToBytes toBytes;
    private final /* synthetic */ Tuple2 x$1;
    private final TiffTagFieldValue[] fieldValues;
    private final Function1<int[], TiffTagFieldValue> offsetFieldValueBuilder;
    private final SegmentBytes segments;
    private final int segmentCount;
    private final int tagFieldByteCount;
    private final int tagDataByteCount;
    private int index;

    public ToBytes toBytes() {
        return this.toBytes;
    }

    public TiffTagFieldValue[] fieldValues() {
        return this.fieldValues;
    }

    public Function1<int[], TiffTagFieldValue> offsetFieldValueBuilder() {
        return this.offsetFieldValueBuilder;
    }

    public SegmentBytes segments() {
        return this.segments;
    }

    public int segmentCount() {
        return this.segmentCount;
    }

    public int tagFieldByteCount() {
        return this.tagFieldByteCount;
    }

    public int tagDataByteCount() {
        return this.tagDataByteCount;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public void writeByte(byte value) {
        this.dos.writeByte(value);
        this.index_$eq(this.index() + 1);
    }

    public void writeBytes(byte[] value) {
        this.dos.write(value, 0, value.length);
        this.index_$eq(this.index() + value.length);
    }

    public void writeShort(int value) {
        this.writeBytes(this.toBytes().apply((short)value));
    }

    public void writeInt(int value) {
        this.writeBytes(this.toBytes().apply(value));
    }

    public void writeLong(long value) {
        this.writeBytes(this.toBytes().apply(value));
    }

    public void writeFloat(float value) {
        this.writeBytes(this.toBytes().apply(value));
    }

    public void writeDouble(double value) {
        this.writeBytes(this.toBytes().apply(value));
    }

    public void write() {
        int tagDataStartOffset;
        ByteOrder byteOrder = this.geoTiff.imageData().decompressor().byteOrder();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null)) {
            byte m = (byte)77;
            this.writeByte(m);
            this.writeByte(m);
        } else {
            byte i = (byte)73;
            this.writeByte(i);
            this.writeByte(i);
        }
        this.writeShort((short)42);
        this.writeInt(this.index() + 4);
        int imageDataStartOffset = this.index() + 2 + 4 + this.tagFieldByteCount() + this.tagDataByteCount();
        int[] offsets2 = (int[])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.Int());
        int offset = imageDataStartOffset;
        for (int index$macro$567 = 0; index$macro$567 < this.segmentCount(); ++index$macro$567) {
            offsets2[index$macro$567] = offset;
            offset += this.segments().getSegment(index$macro$567).length;
        }
        TiffTagFieldValue offsetFieldValue = (TiffTagFieldValue)this.offsetFieldValueBuilder().apply((Object)offsets2);
        Object[] objectArray = this.fieldValues();
        Predef$ predef$ = Predef$.MODULE$;
        List list = new ArrayOps.ofRef(objectArray).toList();
        TiffTagFieldValue[] sortedTagFieldValues = (TiffTagFieldValue[])((TraversableOnce)new .colon.colon((Object)offsetFieldValue, list).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(TiffTagFieldValue x$7) {
                return x$7.tag();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).toArray(ClassTag$.MODULE$.apply(TiffTagFieldValue.class));
        this.writeShort(sortedTagFieldValues.length);
        int tagDataOffset = tagDataStartOffset = this.index() + 4 + this.tagFieldByteCount();
        for (int index$macro$568 = 0; index$macro$568 < sortedTagFieldValues.length; ++index$macro$568) {
            TiffTagFieldValue tiffTagFieldValue = sortedTagFieldValues[index$macro$568];
            if (tiffTagFieldValue != null) {
                int i;
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)tiffTagFieldValue.tag()), (Object)BoxesRunTime.boxToInteger((int)tiffTagFieldValue.fieldType()), (Object)BoxesRunTime.boxToInteger((int)tiffTagFieldValue.length()), (Object)tiffTagFieldValue.value());
                int tag = BoxesRunTime.unboxToInt((Object)tuple4._1());
                int fieldType = BoxesRunTime.unboxToInt((Object)tuple4._2());
                int length = BoxesRunTime.unboxToInt((Object)tuple4._3());
                byte[] value = (byte[])tuple4._4();
                this.writeShort(tag);
                this.writeShort(fieldType);
                this.writeInt(length);
                if (value.length > 4) {
                    this.writeInt(tagDataOffset);
                    tagDataOffset += value.length;
                    continue;
                }
                for (i = 0; i < value.length; ++i) {
                    this.writeByte(value[i]);
                }
                while (i < 4) {
                    this.writeByte((byte)0);
                    ++i;
                }
                continue;
            }
            throw new MatchError((Object)tiffTagFieldValue);
        }
        this.writeInt(0);
        boolean bl = this.index() == tagDataStartOffset;
        Predef$ predef$2 = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writer error: index at ", ", should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.index()), BoxesRunTime.boxToInteger((int)tagDataStartOffset)}))).toString());
        }
        Predef$.MODULE$.assert(tagDataOffset == tagDataStartOffset + this.tagDataByteCount());
        for (int index$macro$569 = 0; index$macro$569 < sortedTagFieldValues.length; ++index$macro$569) {
            TiffTagFieldValue tiffTagFieldValue = sortedTagFieldValues[index$macro$569];
            if (tiffTagFieldValue != null) {
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)tiffTagFieldValue.tag()), (Object)BoxesRunTime.boxToInteger((int)tiffTagFieldValue.fieldType()), (Object)BoxesRunTime.boxToInteger((int)tiffTagFieldValue.length()), (Object)tiffTagFieldValue.value());
                tuple4._1();
                tuple4._2();
                tuple4._3();
                byte[] value = (byte[])tuple4._4();
                if (value.length <= 4) continue;
                this.writeBytes(value);
                continue;
            }
            throw new MatchError((Object)tiffTagFieldValue);
        }
        for (int index$macro$570 = 0; index$macro$570 < this.segmentCount(); ++index$macro$570) {
            this.writeBytes(this.segments().getSegment(index$macro$570));
        }
        this.dos.flush();
    }

    public GeoTiffWriter(GeoTiffData geoTiff, DataOutputStream dos) {
        this.geoTiff = geoTiff;
        this.dos = dos;
        ByteOrder byteOrder = geoTiff.imageData().decompressor().byteOrder();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        this.toBytes = !(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null) ? BigEndianToBytes$.MODULE$ : LittleEndianToBytes$.MODULE$;
        Tuple2<TiffTagFieldValue[], Function1<int[], TiffTagFieldValue>> tuple2 = TiffTagFieldValue$.MODULE$.collect(geoTiff);
        if (tuple2 != null) {
            this.x$1 = new Tuple2(tuple2._1(), tuple2._2());
            this.fieldValues = (TiffTagFieldValue[])this.x$1._1();
            this.offsetFieldValueBuilder = (Function1)this.x$1._2();
            this.segments = geoTiff.imageData().segmentBytes();
            this.segmentCount = this.segments().size();
            this.tagFieldByteCount = (this.fieldValues().length + 1) * 12;
            int s = 0;
            for (int index$macro$566 = 0; index$macro$566 < this.fieldValues().length; ++index$macro$566) {
                int len = this.fieldValues()[index$macro$566].value().length;
                if (len <= 4) continue;
                s += this.fieldValues()[index$macro$566].value().length;
            }
            if (this.segmentCount() > 1) {
                s += this.segmentCount() * 4;
            }
            this.tagDataByteCount = s;
            this.index = 0;
            return;
        }
        throw new MatchError(tuple2);
    }
}

