/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.reader;

import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.reader.TiffTagsReader$ByteReaderTagReaderWrapper$;
import geotrellis.raster.io.geotiff.tags.TiffTagMetadata;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.TiffTags$;
import geotrellis.raster.io.geotiff.tags.codes.TagCodes$;
import geotrellis.raster.io.geotiff.tags.codes.TiffFieldType$;
import geotrellis.raster.io.geotiff.util.package$;
import geotrellis.util.ByteReader;
import geotrellis.util.ByteReader$;
import geotrellis.util.Filesystem$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class TiffTagsReader$ {
    public static final TiffTagsReader$ MODULE$;

    static {
        new TiffTagsReader$();
    }

    public TiffTags read(String path) {
        return this.read(ByteReader$.MODULE$.byteBuffer2ByteReader(Filesystem$.MODULE$.toMappedByteBuffer(path)));
    }

    public TiffTags read(byte[] bytes) {
        return this.read(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)));
    }

    public TiffTags read(ByteReader byteReader) {
        block8: {
            TiffTags tiffTags;
            block7: {
                Tuple2.mcCC.sp sp2;
                block6: {
                    sp2 = new Tuple2.mcCC.sp((char)byteReader.get(), (char)byteReader.get());
                    if ('I' != sp2._1$mcC$sp() || 'I' != sp2._2$mcC$sp()) break block6;
                    byteReader.order(ByteOrder.LITTLE_ENDIAN);
                    break block7;
                }
                if ('M' != sp2._1$mcC$sp() || 'M' != sp2._2$mcC$sp()) break block8;
                byteReader.order(ByteOrder.BIG_ENDIAN);
            }
            char geoTiffIdNumber = byteReader.getChar();
            if (geoTiffIdNumber != '*' && geoTiffIdNumber != '+') {
                throw new MalformedGeoTiffException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bad identification number (must be 42 or 43, was ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)geoTiffIdNumber)})));
            }
            if (geoTiffIdNumber == '*') {
                int smallOffset = byteReader.getInt();
                tiffTags = this.read(byteReader, BoxesRunTime.boxToInteger((int)smallOffset));
            } else {
                byteReader.position(8L);
                long bigOffset = byteReader.getLong();
                tiffTags = this.read(byteReader, BoxesRunTime.boxToLong((long)bigOffset));
            }
            return tiffTags;
        }
        throw new MalformedGeoTiffException("incorrect byte order");
    }

    /*
     * WARNING - void declaration
     */
    public <T> TiffTags read(ByteReader byteReader, T tagsStartPosition) {
        block11: {
            block14: {
                void var12_7;
                block20: {
                    TiffTags tiffTags;
                    block19: {
                        None$ geoTags;
                        block18: {
                            long l;
                            block13: {
                                block12: {
                                    block10: {
                                        block9: {
                                            if (!(tagsStartPosition instanceof Integer)) break block9;
                                            int n = BoxesRunTime.unboxToInt(tagsStartPosition);
                                            byteReader.position((long)n);
                                            break block10;
                                        }
                                        if (!(tagsStartPosition instanceof Long)) break block11;
                                        long l2 = BoxesRunTime.unboxToLong(tagsStartPosition);
                                        byteReader.position(l2);
                                    }
                                    if (!(tagsStartPosition instanceof Integer)) break block12;
                                    l = byteReader.getShort();
                                    break block13;
                                }
                                if (!(tagsStartPosition instanceof Long)) break block14;
                                l = byteReader.getLong();
                            }
                            tiffTags = new TiffTags(TiffTags$.MODULE$.apply$default$1(), TiffTags$.MODULE$.apply$default$2(), TiffTags$.MODULE$.apply$default$3(), TiffTags$.MODULE$.apply$default$4(), TiffTags$.MODULE$.apply$default$5(), TiffTags$.MODULE$.apply$default$6(), TiffTags$.MODULE$.apply$default$7(), TiffTags$.MODULE$.apply$default$8(), TiffTags$.MODULE$.apply$default$9(), TiffTags$.MODULE$.apply$default$10(), TiffTags$.MODULE$.apply$default$11(), TiffTags$.MODULE$.apply$default$12());
                            geoTags = None$.MODULE$;
                            int index$macro$444 = 0;
                            while ((long)index$macro$444 < l) {
                                block17: {
                                    TiffTagMetadata tiffTagMetadata;
                                    block16: {
                                        block15: {
                                            if (!(tagsStartPosition instanceof Integer)) break block15;
                                            tiffTagMetadata = new TiffTagMetadata(package$.MODULE$.ByteReaderUtilities((ByteReader)byteReader).geotrellis$raster$io$geotiff$util$ByteReaderExtensions$ByteReaderUtilities$$byteReader.getChar(), package$.MODULE$.ByteReaderUtilities((ByteReader)byteReader).geotrellis$raster$io$geotiff$util$ByteReaderExtensions$ByteReaderUtilities$$byteReader.getChar(), byteReader.getInt(), byteReader.getInt());
                                            break block16;
                                        }
                                        if (!(tagsStartPosition instanceof Long)) break block17;
                                        tiffTagMetadata = new TiffTagMetadata(package$.MODULE$.ByteReaderUtilities((ByteReader)byteReader).geotrellis$raster$io$geotiff$util$ByteReaderExtensions$ByteReaderUtilities$$byteReader.getChar(), package$.MODULE$.ByteReaderUtilities((ByteReader)byteReader).geotrellis$raster$io$geotiff$util$ByteReaderExtensions$ByteReaderUtilities$$byteReader.getChar(), byteReader.getLong(), byteReader.getLong());
                                    }
                                    if (tiffTagMetadata.tag() == TagCodes$.MODULE$.GeoKeyDirectoryTag()) {
                                        geoTags = new Some((Object)tiffTagMetadata);
                                    } else {
                                        tiffTags = this.readTag(byteReader, tiffTags, tiffTagMetadata);
                                    }
                                    ++index$macro$444;
                                    continue;
                                }
                                throw new MatchError(tagsStartPosition);
                            }
                            if (!(geoTags instanceof Some)) break block18;
                            Some some = (Some)geoTags;
                            tiffTags = this.readTag(byteReader, tiffTags, (TiffTagMetadata)some.x());
                            break block19;
                        }
                        if (!None$.MODULE$.equals(geoTags)) break block20;
                    }
                    return tiffTags;
                }
                throw new MatchError((Object)var12_7);
            }
            throw new MatchError(tagsStartPosition);
        }
        throw new MatchError(tagsStartPosition);
    }

    public TiffTags readTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata) {
        Tuple2.mcII.sp sp2;
        block20: {
            TiffTags tiffTags2;
            block3: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                block11: {
                                                    block10: {
                                                        block9: {
                                                            block8: {
                                                                block7: {
                                                                    block6: {
                                                                        block5: {
                                                                            block4: {
                                                                                block2: {
                                                                                    sp2 = new Tuple2.mcII.sp(tagMetadata.tag(), tagMetadata.fieldType());
                                                                                    if (TagCodes$.MODULE$.ModelPixelScaleTag() != sp2._1$mcI$sp()) break block2;
                                                                                    tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readModelPixelScaleTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                                                    break block3;
                                                                                }
                                                                                if (TagCodes$.MODULE$.ModelTiePointsTag() != sp2._1$mcI$sp()) break block4;
                                                                                tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readModelTiePointsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                                                break block3;
                                                                            }
                                                                            if (TagCodes$.MODULE$.GeoKeyDirectoryTag() != sp2._1$mcI$sp()) break block5;
                                                                            tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readGeoKeyDirectoryTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                                            break block3;
                                                                        }
                                                                        if (TiffFieldType$.MODULE$.BytesFieldType() != sp2._2$mcI$sp()) break block6;
                                                                        tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readBytesTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                                        break block3;
                                                                    }
                                                                    if (TiffFieldType$.MODULE$.AsciisFieldType() != sp2._2$mcI$sp()) break block7;
                                                                    tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readAsciisTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                                    break block3;
                                                                }
                                                                if (TiffFieldType$.MODULE$.ShortsFieldType() != sp2._2$mcI$sp()) break block8;
                                                                tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readShortsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                                break block3;
                                                            }
                                                            if (TiffFieldType$.MODULE$.IntsFieldType() != sp2._2$mcI$sp()) break block9;
                                                            tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readIntsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                            break block3;
                                                        }
                                                        if (TiffFieldType$.MODULE$.FractionalsFieldType() != sp2._2$mcI$sp()) break block10;
                                                        tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readFractionalsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                        break block3;
                                                    }
                                                    if (TiffFieldType$.MODULE$.SignedBytesFieldType() != sp2._2$mcI$sp()) break block11;
                                                    tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readSignedBytesTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                    break block3;
                                                }
                                                if (TiffFieldType$.MODULE$.UndefinedFieldType() != sp2._2$mcI$sp()) break block12;
                                                tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readUndefinedTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                                break block3;
                                            }
                                            if (TiffFieldType$.MODULE$.SignedShortsFieldType() != sp2._2$mcI$sp()) break block13;
                                            tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readSignedShortsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                            break block3;
                                        }
                                        if (TiffFieldType$.MODULE$.SignedIntsFieldType() != sp2._2$mcI$sp()) break block14;
                                        tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readSignedIntsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                        break block3;
                                    }
                                    if (TiffFieldType$.MODULE$.SignedFractionalsFieldType() != sp2._2$mcI$sp()) break block15;
                                    tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readSignedFractionalsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                    break block3;
                                }
                                if (TiffFieldType$.MODULE$.FloatsFieldType() != sp2._2$mcI$sp()) break block16;
                                tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readFloatsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                                break block3;
                            }
                            if (TiffFieldType$.MODULE$.DoublesFieldType() != sp2._2$mcI$sp()) break block17;
                            tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readDoublesTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                            break block3;
                        }
                        if (TiffFieldType$.MODULE$.LongsFieldType() != sp2._2$mcI$sp()) break block18;
                        tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readLongsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                        break block3;
                    }
                    if (TiffFieldType$.MODULE$.SignedLongsFieldType() != sp2._2$mcI$sp()) break block19;
                    tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readLongsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
                    break block3;
                }
                if (TiffFieldType$.MODULE$.IFDOffset() != sp2._2$mcI$sp()) break block20;
                tiffTags2 = TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readLongsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata);
            }
            return tiffTags2;
        }
        throw new MatchError((Object)sp2);
    }

    public ByteReader ByteReaderTagReaderWrapper(ByteReader byteReader) {
        return byteReader;
    }

    private TiffTagsReader$() {
        MODULE$ = this;
    }
}

