/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.reader;

import geotrellis.raster.io.geotiff.ArraySegmentBytes$;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile$;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GeoTiffTile$;
import geotrellis.raster.io.geotiff.LazySegmentBytes;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped;
import geotrellis.raster.io.geotiff.Striped$;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.Decompressor$;
import geotrellis.raster.io.geotiff.compression.DeflateCompression$;
import geotrellis.raster.io.geotiff.compression.NoCompression$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.reader.TiffTagsReader$;
import geotrellis.raster.io.geotiff.tags.BasicTags;
import geotrellis.raster.io.geotiff.tags.BasicTags$;
import geotrellis.raster.io.geotiff.tags.GeoTiffTags;
import geotrellis.raster.io.geotiff.tags.GeoTiffTags$;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.TiffTags$;
import geotrellis.raster.io.geotiff.tags.TileTags;
import geotrellis.raster.io.geotiff.tags.TileTags$;
import geotrellis.raster.io.geotiff.tags.codes.ColorSpace$;
import geotrellis.raster.render.IndexedColorMap;
import geotrellis.raster.render.IndexedColorMap$;
import geotrellis.util.ByteReader;
import geotrellis.util.ByteReader$;
import geotrellis.util.Filesystem$;
import geotrellis.vector.Extent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import monocle.PLens;
import monocle.PLens$;
import monocle.syntax.ApplyLens;
import monocle.syntax.apply$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class GeoTiffReader$ {
    public static final GeoTiffReader$ MODULE$;

    static {
        new GeoTiffReader$();
    }

    public SinglebandGeoTiff readSingleband(String path) {
        return this.readSingleband(path, true, false);
    }

    public SinglebandGeoTiff readSingleband(String path, Extent e) {
        return this.readSingleband(path, (Option<Extent>)new Some((Object)e));
    }

    public SinglebandGeoTiff readSingleband(String path, Option<Extent> e) {
        block4: {
            SinglebandGeoTiff singlebandGeoTiff;
            block3: {
                block2: {
                    if (!(e instanceof Some)) break block2;
                    Some some = (Some)e;
                    singlebandGeoTiff = this.readSingleband(path, false, true).crop((Extent)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(e)) break block4;
                singlebandGeoTiff = this.readSingleband(path);
            }
            return singlebandGeoTiff;
        }
        throw new MatchError(e);
    }

    public SinglebandGeoTiff readSingleband(String path, boolean decompress, boolean streaming) {
        return streaming ? this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(Filesystem$.MODULE$.toMappedByteBuffer(path)), decompress, streaming) : this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2()))), decompress, streaming);
    }

    public SinglebandGeoTiff readSingleband(byte[] bytes) {
        return this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), true, false);
    }

    public SinglebandGeoTiff readSingleband(byte[] bytes, boolean decompress, boolean streaming) {
        return this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), decompress, streaming);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader) {
        return this.readSingleband(byteReader, true, false);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, Extent e) {
        return this.readSingleband(byteReader, (Option<Extent>)new Some((Object)e));
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, Option<Extent> e) {
        block4: {
            SinglebandGeoTiff singlebandGeoTiff;
            block3: {
                block2: {
                    if (!(e instanceof Some)) break block2;
                    Some some = (Some)e;
                    singlebandGeoTiff = this.readSingleband(byteReader, false, true).crop((Extent)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(e)) break block4;
                singlebandGeoTiff = this.readSingleband(byteReader);
            }
            return singlebandGeoTiff;
        }
        throw new MatchError(e);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, boolean decompress, boolean streaming) {
        GeoTiffReader.GeoTiffInfo info = this.readGeoTiffInfo(byteReader, decompress, streaming);
        GeoTiffTile geoTiffTile = info.bandCount() == 1 ? GeoTiffTile$.MODULE$.apply(info.segmentBytes(), info.decompressor(), info.segmentLayout(), info.compression(), info.cellType(), (Option<BandType>)new Some((Object)info.bandType())) : GeoTiffMultibandTile$.MODULE$.apply(info.segmentBytes(), info.decompressor(), info.segmentLayout(), info.compression(), info.bandCount(), info.hasPixelInterleave(), info.cellType(), (Option<BandType>)new Some((Object)info.bandType())).band(0);
        return new SinglebandGeoTiff(decompress ? geoTiffTile.toArrayTile() : geoTiffTile, info.extent(), info.crs(), info.tags(), info.options());
    }

    public boolean readSingleband$default$3() {
        return false;
    }

    public MultibandGeoTiff readMultiband(String path) {
        return this.readMultiband(path, true, false);
    }

    public MultibandGeoTiff readMultiband(String path, Extent e) {
        return this.readMultiband(path, (Option<Extent>)new Some((Object)e));
    }

    public MultibandGeoTiff readMultiband(String path, Option<Extent> e) {
        block4: {
            MultibandGeoTiff multibandGeoTiff;
            block3: {
                block2: {
                    if (!(e instanceof Some)) break block2;
                    Some some = (Some)e;
                    multibandGeoTiff = this.readMultiband(path, false, true).crop((Extent)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(e)) break block4;
                multibandGeoTiff = this.readMultiband(path);
            }
            return multibandGeoTiff;
        }
        throw new MatchError(e);
    }

    public MultibandGeoTiff readMultiband(String path, boolean decompress, boolean streaming) {
        return streaming ? this.readMultiband(ByteReader$.MODULE$.byteBuffer2ByteReader(Filesystem$.MODULE$.toMappedByteBuffer(path)), decompress, streaming) : this.readMultiband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2()))), decompress, streaming);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader) {
        return this.readMultiband(byteReader, true, false);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, Extent e) {
        return this.readMultiband(byteReader, (Option<Extent>)new Some((Object)e));
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, Option<Extent> e) {
        block4: {
            MultibandGeoTiff multibandGeoTiff;
            block3: {
                block2: {
                    if (!(e instanceof Some)) break block2;
                    Some some = (Some)e;
                    multibandGeoTiff = this.readMultiband(byteReader, false, true).crop((Extent)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(e)) break block4;
                multibandGeoTiff = this.readMultiband(byteReader);
            }
            return multibandGeoTiff;
        }
        throw new MatchError(e);
    }

    public MultibandGeoTiff readMultiband(byte[] bytes) {
        return this.readMultiband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), true, false);
    }

    public MultibandGeoTiff readMultiband(byte[] bytes, boolean decompress, boolean streaming) {
        return this.readMultiband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), decompress, streaming);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, boolean decompress, boolean streaming) {
        GeoTiffReader.GeoTiffInfo info = this.readGeoTiffInfo(byteReader, decompress, streaming);
        GeoTiffMultibandTile geoTiffTile = GeoTiffMultibandTile$.MODULE$.apply(info.segmentBytes(), info.decompressor(), info.segmentLayout(), info.compression(), info.bandCount(), info.hasPixelInterleave(), info.cellType(), (Option<BandType>)new Some((Object)info.bandType()));
        return new MultibandGeoTiff(decompress ? geoTiffTile.toArrayTile() : geoTiffTile, info.extent(), info.crs(), info.tags(), info.options());
    }

    public boolean readMultiband$default$3() {
        return false;
    }

    private GeoTiffReader.GeoTiffInfo readGeoTiffInfo(ByteReader byteReader, boolean decompress, boolean streaming) {
        block10: {
            StorageMethod storageMethod;
            TiffTags tiffTags;
            block9: {
                Tuple2.mcCC.sp sp2;
                block8: {
                    sp2 = new Tuple2.mcCC.sp((char)byteReader.get(), (char)byteReader.get());
                    if ('I' != sp2._1$mcC$sp() || 'I' != sp2._2$mcC$sp()) break block8;
                    byteReader.order(ByteOrder.LITTLE_ENDIAN);
                    break block9;
                }
                if ('M' != sp2._1$mcC$sp() || 'M' != sp2._2$mcC$sp()) break block10;
                byteReader.order(ByteOrder.BIG_ENDIAN);
            }
            char tiffIdNumber = byteReader.getChar();
            if (tiffIdNumber != '*' && tiffIdNumber != '+') {
                throw new MalformedGeoTiffException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bad identification number (must be 42 or 43, was ", " (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)tiffIdNumber), BoxesRunTime.boxToInteger((int)tiffIdNumber)})));
            }
            if (tiffIdNumber == '*') {
                int smallStart = byteReader.getInt();
                tiffTags = TiffTagsReader$.MODULE$.read(byteReader, BoxesRunTime.boxToInteger((int)smallStart));
            } else {
                byteReader.position(8L);
                long bigStart = byteReader.getLong();
                tiffTags = TiffTagsReader$.MODULE$.read(byteReader, BoxesRunTime.boxToLong((long)bigStart));
            }
            TiffTags tiffTags2 = tiffTags;
            boolean hasPixelInterleave = tiffTags2.hasPixelInterleave();
            Decompressor decompressor = Decompressor$.MODULE$.apply(tiffTags2, byteReader.order());
            if (tiffTags2.hasStripStorage()) {
                PLens<BasicTags, BasicTags, Object, Object> pLens = BasicTags$.MODULE$._rowsPerStrip();
                ApplyLens applyLens = apply$.MODULE$.toApplyLensOps((Object)tiffTags2).$amp$bar$minus$greater(TiffTags$.MODULE$._basicTags());
                PLens pLens2 = applyLens.lens();
                ApplyLens applyLens2 = new ApplyLens(applyLens.s(), (PLens)new PLens$.anon.1(pLens2, pLens));
                int rowsPerStrip = (int)BoxesRunTime.unboxToLong((Object)applyLens2.lens().get(applyLens2.s()));
                storageMethod = Striped$.MODULE$.apply(rowsPerStrip);
            } else {
                PLens<TileTags, TileTags, Option<Object>, Option<Object>> pLens = TileTags$.MODULE$._tileWidth();
                ApplyLens applyLens = apply$.MODULE$.toApplyLensOps((Object)tiffTags2).$amp$bar$minus$greater(TiffTags$.MODULE$._tileTags());
                PLens pLens3 = applyLens.lens();
                ApplyLens applyLens3 = new ApplyLens(applyLens.s(), (PLens)new PLens$.anon.1(pLens3, pLens));
                int blockCols = (int)BoxesRunTime.unboxToLong((Object)((Option)applyLens3.lens().get(applyLens3.s())).get());
                PLens<TileTags, TileTags, Option<Object>, Option<Object>> pLens4 = TileTags$.MODULE$._tileLength();
                ApplyLens applyLens4 = apply$.MODULE$.toApplyLensOps((Object)tiffTags2).$amp$bar$minus$greater(TiffTags$.MODULE$._tileTags());
                ApplyLens applyLens5 = new ApplyLens(applyLens4.s(), applyLens4.lens().composeLens(pLens4));
                int blockRows = (int)BoxesRunTime.unboxToLong((Object)((Option)applyLens5.lens().get(applyLens5.s())).get());
                storageMethod = new Tiled(blockCols, blockRows);
            }
            Striped storageMethod2 = storageMethod;
            SegmentBytes segmentBytes = streaming ? new LazySegmentBytes(byteReader, tiffTags2) : ArraySegmentBytes$.MODULE$.apply(byteReader, tiffTags2);
            int cols = tiffTags2.cols();
            int rows = tiffTags2.rows();
            BandType bandType = tiffTags2.bandType();
            int bandCount = tiffTags2.bandCount();
            GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(cols, rows, storageMethod2, bandType);
            PLens<GeoTiffTags, GeoTiffTags, Option<Object>, Option<Object>> pLens = GeoTiffTags$.MODULE$._gdalInternalNoData();
            ApplyLens applyLens = apply$.MODULE$.toApplyLensOps((Object)tiffTags2).$amp$bar$minus$greater(TiffTags$.MODULE$._geoTiffTags());
            PLens pLens5 = applyLens.lens();
            ApplyLens applyLens6 = new ApplyLens(applyLens.s(), (PLens)new PLens$.anon.1(pLens5, pLens));
            Option noDataValue = (Option)applyLens6.lens().get(applyLens6.s());
            Compression compression = NoCompression$.MODULE$.equals(decompressor) ? NoCompression$.MODULE$ : DeflateCompression$.MODULE$;
            int colorSpace = tiffTags2.basicTags().photometricInterp();
            None$ colorMap = colorSpace == ColorSpace$.MODULE$.Palette() && tiffTags2.basicTags().colorMap().nonEmpty() ? Option$.MODULE$.apply((Object)IndexedColorMap$.MODULE$.fromTiffPalette(tiffTags2.basicTags().colorMap())) : None$.MODULE$;
            return new GeoTiffReader.GeoTiffInfo(tiffTags2.extent(), tiffTags2.crs(), tiffTags2.tags(), new GeoTiffOptions(storageMethod2, compression, colorSpace, (Option<IndexedColorMap>)colorMap), bandType, segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (Option<Object>)noDataValue);
        }
        throw new MalformedGeoTiffException("incorrect byte order");
    }

    private GeoTiffReader$() {
        MODULE$ = this;
    }
}

