/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.Decompressor$class;
import geotrellis.raster.io.geotiff.compression.LZWDecompressor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.TokenTable$;
import geotrellis.raster.io.geotiff.compression.TokenTableEntry;
import geotrellis.raster.io.geotiff.tags.codes.CompressionType$;
import java.nio.ByteOrder;
import scala.Array$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001]<Q!\u0001\u0002\t\u00025\tq\u0002\u0014.X\t\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\bO\u0016|G/\u001b4g\u0015\t9\u0001\"\u0001\u0002j_*\u0011\u0011BC\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003-\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011q\u0002\u0014.X\t\u0016\u001cw.\u001c9sKN\u001cxN]\n\u0004\u001fIA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u00143%\u0011!\u0004\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00069=!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035AQaH\b\u0005\u0002\u0001\nQ!\u00199qYf$\"!I6\u0011\u00059\u0011c\u0001\u0002\t\u0003\u0001\r\u001a2A\t\n%!\tqQ%\u0003\u0002'\u0005\taA)Z2p[B\u0014Xm]:pe\"A\u0001F\tB\u0001B\u0003%\u0011&\u0001\u0007tK\u001elWM\u001c;TSj,7\u000fE\u0002\u0014U1J!a\u000b\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Mi\u0013B\u0001\u0018\u0015\u0005\rIe\u000e\u001e\u0005\u00069\t\"\t\u0001\r\u000b\u0003CEBQ\u0001K\u0018A\u0002%BQa\r\u0012\u0005\u0002Q\nAaY8eKV\tA\u0006C\u00047E\t\u0007I\u0011\u0001\u001b\u0002\u0015Q\f'\r\\3MS6LG\u000f\u0003\u00049E\u0001\u0006I\u0001L\u0001\fi\u0006\u0014G.\u001a'j[&$\b\u0005C\u0004;E\t\u0007I\u0011\u0001\u001b\u0002\u0013\rcW-\u0019:D_\u0012,\u0007B\u0002\u001f#A\u0003%A&\u0001\u0006DY\u0016\f'oQ8eK\u0002BqA\u0010\u0012C\u0002\u0013\u0005A'A\u0004F_&\u001bu\u000eZ3\t\r\u0001\u0013\u0003\u0015!\u0003-\u0003!)u.S\"pI\u0016\u0004\u0003\"\u0002\"#\t\u0003\u0019\u0015A\u00033fG>l\u0007O]3tgR\u0019A\t\u0013&\u0011\u0007MQS\t\u0005\u0002\u0014\r&\u0011q\t\u0006\u0002\u0005\u0005f$X\rC\u0003J\u0003\u0002\u0007A)A\u0004tK\u001elWM\u001c;\t\u000b-\u000b\u0005\u0019\u0001\u0017\u0002\u0019M,w-\\3oi&sG-\u001a=\u0007\t5\u0013CA\u0014\u0002\u0012\u0019j;&)\u001b;J]B,Ho\u0015;sK\u0006l7C\u0001'\u0013\u0011!\u0001FJ!A!\u0002\u0013!\u0015aA1se\")A\u0004\u0014C\u0001%R\u00111+\u0016\t\u0003)2k\u0011A\t\u0005\u0006!F\u0003\r\u0001\u0012\u0005\b/2\u0013\r\u0011\"\u00015\u0003\raWM\u001c\u0005\u000732\u0003\u000b\u0011\u0002\u0017\u0002\t1,g\u000e\t\u0005\b72\u0003\r\u0011\"\u00035\u0003\u0015Ig\u000eZ3y\u0011\u001diF\n1A\u0005\ny\u000b\u0011\"\u001b8eKb|F%Z9\u0015\u0005}\u0013\u0007CA\na\u0013\t\tGC\u0001\u0003V]&$\bbB2]\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\n\u0004BB3MA\u0003&A&\u0001\u0004j]\u0012,\u0007\u0010\t\u0005\u0006O2#\t\u0001[\u0001\u0004O\u0016$HC\u0001\u0017j\u0011\u0015Qg\r1\u0001-\u0003\u0011qW\r\u001f;\t\u000b!r\u0002\u0019A\u0015\t\u000f5|\u0011\u0011!C\u0005]\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0011a\u0017M\\4\u000b\u0003Q\fAA[1wC&\u0011a/\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class LZWDecompressor
implements Decompressor {
    private final int[] segmentSizes;
    private final int tableLimit;
    private final int ClearCode;
    private final int EoICode;

    public static LZWDecompressor apply(int[] nArray) {
        return LZWDecompressor$.MODULE$.apply(nArray);
    }

    @Override
    public ByteOrder byteOrder() {
        return Decompressor$class.byteOrder(this);
    }

    @Override
    public Decompressor flipEndian(int bytesPerFlip) {
        return Decompressor$class.flipEndian(this, bytesPerFlip);
    }

    @Override
    public Decompressor withPredictor(Predictor predictor) {
        return Decompressor$class.withPredictor(this, predictor);
    }

    @Override
    public int code() {
        return CompressionType$.MODULE$.LZWCoded();
    }

    public int tableLimit() {
        return this.tableLimit;
    }

    public int ClearCode() {
        return this.ClearCode;
    }

    public int EoICode() {
        return this.EoICode;
    }

    @Override
    public byte[] decompress(byte[] segment, int segmentIndex) {
        int code;
        LZWBitInputStream bis = new LZWBitInputStream(this, segment);
        ObjectRef tokenTable = ObjectRef.create((Object)TokenTable$.MODULE$.initial());
        IntRef tokenTableIndex = IntRef.create((int)258);
        int outputArrayIndex = 0;
        int size = this.segmentSizes[segmentIndex];
        byte[] outputArray = (byte[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.Byte());
        IntRef threshold = IntRef.create((int)9);
        int oldCode = 0;
        boolean bl = false;
        while (!bl && (code = bis.get(threshold.elem)) != this.EoICode() && outputArrayIndex < size) {
            if (code == this.ClearCode()) {
                this.initializeTokenTable$1(tokenTable, tokenTableIndex, threshold);
                code = bis.get(threshold.elem);
                if (code == this.EoICode()) {
                    bl = true;
                } else {
                    outputArrayIndex = TokenTable$.MODULE$.writeToOutput(((TokenTableEntry[])tokenTable.elem)[code], outputArray, outputArrayIndex);
                }
            } else if (code < tokenTableIndex.elem) {
                TokenTableEntry entry = ((TokenTableEntry[])tokenTable.elem)[code];
                outputArrayIndex = TokenTable$.MODULE$.writeToOutput(entry, outputArray, outputArrayIndex);
                TokenTableEntry oldEntry = ((TokenTableEntry[])tokenTable.elem)[oldCode];
                this.addEntry$1(oldEntry.concat(entry.firstByte()), tokenTable, tokenTableIndex, threshold);
            } else {
                TokenTableEntry oldEntry = ((TokenTableEntry[])tokenTable.elem)[oldCode];
                TokenTableEntry newEntry = oldEntry.concat(oldEntry.firstByte());
                outputArrayIndex = TokenTable$.MODULE$.writeToOutput(newEntry, outputArray, outputArrayIndex);
                this.addEntry$1(newEntry, tokenTable, tokenTableIndex, threshold);
            }
            oldCode = code;
        }
        return outputArray;
    }

    private final void initializeTokenTable$1(ObjectRef tokenTable$1, IntRef tokenTableIndex$1, IntRef threshold$1) {
        tokenTable$1.elem = TokenTable$.MODULE$.initial();
        tokenTableIndex$1.elem = 258;
        threshold$1.elem = 9;
    }

    private final void addEntry$1(TokenTableEntry entry, ObjectRef tokenTable$1, IntRef tokenTableIndex$1, IntRef threshold$1) {
        ((TokenTableEntry[])tokenTable$1.elem)[tokenTableIndex$1.elem] = entry;
        ++tokenTableIndex$1.elem;
        if (tokenTableIndex$1.elem == 511) {
            threshold$1.elem = 10;
        }
        if (tokenTableIndex$1.elem == 1023) {
            threshold$1.elem = 11;
        }
        if (tokenTableIndex$1.elem == 2047) {
            threshold$1.elem = 12;
        }
    }

    public LZWDecompressor(int[] segmentSizes) {
        this.segmentSizes = segmentSizes;
        Decompressor$class.$init$(this);
        this.tableLimit = 4096;
        this.ClearCode = 256;
        this.EoICode = 257;
    }

    public class LZWBitInputStream {
        private final byte[] arr;
        private final int len;
        private int index;
        public final /* synthetic */ LZWDecompressor $outer;

        public int len() {
            return this.len;
        }

        private int index() {
            return this.index;
        }

        private void index_$eq(int x$1) {
            this.index = x$1;
        }

        public int get(int next) {
            int n;
            if (next + this.index() > this.len() * 8) {
                n = this.geotrellis$raster$io$geotiff$compression$LZWDecompressor$LZWBitInputStream$$$outer().EoICode();
            } else {
                int n2;
                int start = this.index() / 8;
                int end = (this.index() + next - 1) / 8;
                int ebi = (this.index() + next - 1) % 8;
                if (end - start == 2) {
                    int c = (this.arr[start] & 0xFF) << 16 | (this.arr[end - 1] & 0xFF) << 8 | this.arr[end] & 0xFF;
                    n2 = c >> 7 - ebi & 0xFFFFFF >> 24 - next;
                } else {
                    int c = (this.arr[start] & 0xFF) << 8 | this.arr[end] & 0xFF;
                    n2 = c >> 7 - ebi & 65535 >> 16 - next;
                }
                int res = n2;
                this.index_$eq(this.index() + next);
                n = res;
            }
            return n;
        }

        public /* synthetic */ LZWDecompressor geotrellis$raster$io$geotiff$compression$LZWDecompressor$LZWBitInputStream$$$outer() {
            return this.$outer;
        }

        public LZWBitInputStream(LZWDecompressor $outer, byte[] arr) {
            this.arr = arr;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.len = arr.length;
            this.index = 0;
        }
    }
}

