/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.compression.HorizontalPredictor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u;Q!\u0001\u0002\t\u00025\t1\u0003S8sSj|g\u000e^1m!J,G-[2u_JT!a\u0001\u0003\u0002\u0017\r|W\u000e\u001d:fgNLwN\u001c\u0006\u0003\u000b\u0019\tqaZ3pi&4gM\u0003\u0002\b\u0011\u0005\u0011\u0011n\u001c\u0006\u0003\u0013)\taA]1ti\u0016\u0014(\"A\u0006\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u0003'!{'/\u001b>p]R\fG\u000e\u0015:fI&\u001cGo\u001c:\u0014\u0005=\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\rC\u0003\u001a\u001f\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!)Ad\u0004C\u0001;\u0005)\u0011\r\u001d9msR\u0011a$\t\t\u0003\u001d}I!\u0001\t\u0002\u0003\u0013A\u0013X\rZ5di>\u0014\b\"\u0002\u0012\u001c\u0001\u0004\u0019\u0013\u0001\u0003;jM\u001a$\u0016mZ:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011\u0001\u0002;bONL!\u0001K\u0013\u0003\u0011QKgM\u001a+bON4A\u0001\u0005\u0002\u0001UM\u0011\u0011F\u0005\u0005\tY%\u0012\t\u0011)A\u0005[\u0005!1m\u001c7t!\t\u0019b&\u0003\u00020)\t\u0019\u0011J\u001c;\t\u0011EJ#\u0011!Q\u0001\nI\nQB]8xg&s7+Z4nK:$\b\u0003B\n4[5J!\u0001\u000e\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0002\u0003\u001c*\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0013\t\fg\u000eZ\"pk:$\b\"B\r*\t\u0003AD\u0003B\u001d;wq\u0002\"AD\u0015\t\u000b1:\u0004\u0019A\u0017\t\u000bE:\u0004\u0019\u0001\u001a\t\u000bY:\u0004\u0019A\u0017\t\u000byJC\u0011A \u0002\u0017\u0019|'OQ1oIRK\b/\u001a\u000b\u0003=\u0001CQ!Q\u001fA\u0002\t\u000b\u0001BY1oIRK\b/\u001a\t\u0003\u0007\u0012k\u0011\u0001B\u0005\u0003\u000b\u0012\u0011\u0001BQ1oIRK\b/\u001a\u0005\u0006\u000f&\"\t\u0001S\u0001\u0007CB\u0004H.\u001f\u001d\u0015\u0007%{\u0015\u000bE\u0002\u0014\u00152K!a\u0013\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Mi\u0015B\u0001(\u0015\u0005\u0011\u0011\u0015\u0010^3\t\u000bA3\u0005\u0019A%\u0002\u000b\tLH/Z:\t\u000bI3\u0005\u0019A\u0017\u0002\u0019M,w-\\3oi&sG-\u001a=\t\u000bQKC\u0011A+\u0002\u000f\u0005\u0004\b\u000f\\=2mQ\u0019\u0011JV,\t\u000bA\u001b\u0006\u0019A%\t\u000bI\u001b\u0006\u0019A\u0017\t\u000beKC\u0011\u0001.\u0002\u000f\u0005\u0004\b\u000f\\=4eQ\u0019\u0011j\u0017/\t\u000bAC\u0006\u0019A%\t\u000bIC\u0006\u0019A\u0017")
public class HorizontalPredictor {
    private final int cols;
    private final Function1<Object, Object> rowsInSegment;
    private final int bandCount;

    public static Predictor apply(TiffTags tiffTags) {
        return HorizontalPredictor$.MODULE$.apply(tiffTags);
    }

    public Predictor forBandType(BandType bandType) {
        Object object;
        int n = bandType.bitsPerSample();
        switch (n) {
            default: {
                throw new MalformedGeoTiffException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Horizontal differencing \"Predictor\" not supported with ", " bits per sample"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bandType.bitsPerSample())})));
            }
            case 32: {
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HorizontalPredictor $outer;

                    public final byte[] apply(byte[] bytes, int segmentIndex) {
                        return this.$outer.apply32(bytes, segmentIndex);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                break;
            }
            case 16: {
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HorizontalPredictor $outer;

                    public final byte[] apply(byte[] bytes, int segmentIndex) {
                        return this.$outer.apply16(bytes, segmentIndex);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                break;
            }
            case 8: {
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HorizontalPredictor $outer;

                    public final byte[] apply(byte[] bytes, int segmentIndex) {
                        return this.$outer.apply8(bytes, segmentIndex);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
        }
        Object applyFunc = object;
        return new Predictor(this, (Function2)applyFunc){
            private final boolean checkEndian;
            private final Function2 applyFunc$1;

            public boolean checkEndian() {
                return this.checkEndian;
            }

            public byte[] apply(byte[] bytes, int segmentIndex) {
                return (byte[])this.applyFunc$1.apply((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)segmentIndex));
            }
            {
                this.applyFunc$1 = applyFunc$1;
                this.checkEndian = true;
            }
        };
    }

    public byte[] apply8(byte[] bytes, int segmentIndex) {
        int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
        for (int index$macro$388 = 0; index$macro$388 < rows; ++index$macro$388) {
            int count = this.bandCount * (index$macro$388 * this.cols + 1);
            for (int index$macro$387 = this.bandCount; index$macro$387 < this.cols * this.bandCount && index$macro$387 < bytes.length; ++index$macro$387) {
                bytes[count] = (byte)(bytes[count] + bytes[count - this.bandCount]);
                ++count;
            }
        }
        return bytes;
    }

    public byte[] apply16(byte[] bytes, int segmentIndex) {
        ShortBuffer buffer = ByteBuffer.wrap(bytes).asShortBuffer();
        int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
        for (int index$macro$390 = 0; index$macro$390 < rows; ++index$macro$390) {
            int count = this.bandCount * (index$macro$390 * this.cols + 1);
            for (int index$macro$389 = this.bandCount; index$macro$389 < this.cols * this.bandCount; ++index$macro$389) {
                buffer.put(count, (short)(buffer.get(count) + buffer.get(count - this.bandCount)));
                ++count;
            }
        }
        return bytes;
    }

    public byte[] apply32(byte[] bytes, int segmentIndex) {
        IntBuffer buffer = ByteBuffer.wrap(bytes).asIntBuffer();
        int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
        for (int index$macro$392 = 0; index$macro$392 < rows; ++index$macro$392) {
            int count = this.bandCount * (index$macro$392 * this.cols + 1);
            for (int index$macro$391 = this.bandCount; index$macro$391 < this.cols * this.bandCount; ++index$macro$391) {
                buffer.put(count, buffer.get(count) + buffer.get(count - this.bandCount));
                ++count;
            }
        }
        return bytes;
    }

    public HorizontalPredictor(int cols, Function1<Object, Object> rowsInSegment, int bandCount) {
        this.cols = cols;
        this.rowsInSegment = rowsInSegment;
        this.bandCount = bandCount;
    }
}

